/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.p2p.builder;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import net.tomp2p.connection.ConnectionConfiguration;
import net.tomp2p.connection.DefaultConnectionConfiguration;
import net.tomp2p.connection.PeerConnection;
import net.tomp2p.connection.RequestHandler;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.BaseFutureListener;
import net.tomp2p.futures.FutureChannelCreator;
import net.tomp2p.futures.FuturePing;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.p2p.Peer;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.utils.Utils;

public class PingBuilder {
    private static final FuturePing FUTURE_PING_SHUTDOWN = (FuturePing)new FuturePing().failed("Peer is shutting down.");
    private final Peer peer;
    private PeerAddress peerAddress;
    private InetAddress inetAddress;
    private int port = 7700;
    private boolean tcpPing = false;
    private PeerConnection peerConnection;
    private ConnectionConfiguration connectionConfiguration;

    public PingBuilder(Peer peer) {
        this.peer = peer;
    }

    public PingBuilder notifyAutomaticFutures(BaseFuture future) {
        this.peer.notifyAutomaticFutures(future);
        return this;
    }

    public PeerAddress getPeerAddress() {
        return this.peerAddress;
    }

    public PingBuilder peerAddress(PeerAddress peerAddress) {
        this.peerAddress = peerAddress;
        return this;
    }

    public InetAddress inetAddress() {
        return this.inetAddress;
    }

    public PingBuilder inetAddress(InetAddress inetAddress) {
        this.inetAddress = inetAddress;
        return this;
    }

    public PingBuilder inetSocketAddress(InetSocketAddress socket) {
        this.inetAddress = socket.getAddress();
        this.port = socket.getPort();
        return this;
    }

    public int port() {
        return this.port;
    }

    public PingBuilder port(int port) {
        this.port = port;
        return this;
    }

    public boolean isTcpPing() {
        return this.tcpPing;
    }

    public PingBuilder tcpPing() {
        this.tcpPing = true;
        return this;
    }

    public PingBuilder tcpPing(boolean tcpPing) {
        this.tcpPing = tcpPing;
        return this;
    }

    public PingBuilder peerConnection(PeerConnection peerConnection) {
        this.peerConnection = peerConnection;
        return this;
    }

    public PeerConnection peerConnection() {
        return this.peerConnection;
    }

    public FuturePing start() {
        if (this.peer.isShutdown()) {
            return FUTURE_PING_SHUTDOWN;
        }
        if (this.connectionConfiguration == null) {
            this.connectionConfiguration = new DefaultConnectionConfiguration();
        }
        if (this.peerAddress != null) {
            if (this.tcpPing) {
                return this.ping(this.peerAddress, false);
            }
            return this.ping(this.peerAddress, true);
        }
        if (this.inetAddress != null) {
            if (this.tcpPing) {
                return this.ping(new InetSocketAddress(this.inetAddress, this.port), Number160.ZERO, false);
            }
            return this.ping(new InetSocketAddress(this.inetAddress, this.port), Number160.ZERO, true);
        }
        if (this.peerConnection != null) {
            return this.pingPeerConnection(this.peerConnection);
        }
        throw new IllegalArgumentException("Cannot ping. Peer address or inet address required.");
    }

    private FuturePing ping(InetSocketAddress address, Number160 peerId, boolean isUDP) {
        return this.ping(new PeerAddress(peerId, address), isUDP);
    }

    private FuturePing ping(PeerAddress peerAddress, boolean isUDP) {
        final FuturePing futurePing = new FuturePing();
        final RequestHandler<FutureResponse> request = this.peer.pingRPC().ping(peerAddress, this.connectionConfiguration);
        if (isUDP) {
            FutureChannelCreator fcc = this.peer.connectionBean().reservation().create(1, 0);
            Utils.addReleaseListener(fcc, (BaseFuture)futurePing);
            fcc.addListener((BaseFutureListener<BaseFuture>)new BaseFutureAdapter<FutureChannelCreator>(){

                @Override
                public void operationComplete(FutureChannelCreator future) throws Exception {
                    if (future.isSuccess()) {
                        Object futureResponse = request.sendUDP(future.channelCreator());
                        PingBuilder.this.addPingListener(futurePing, futureResponse);
                    } else {
                        futurePing.failed(future);
                    }
                }
            });
        } else {
            FutureChannelCreator fcc = this.peer.connectionBean().reservation().create(0, 1);
            Utils.addReleaseListener(fcc, (BaseFuture)futurePing);
            fcc.addListener((BaseFutureListener<BaseFuture>)new BaseFutureAdapter<FutureChannelCreator>(){

                @Override
                public void operationComplete(FutureChannelCreator future) throws Exception {
                    if (future.isSuccess()) {
                        Object futureResponse = request.sendTCP(future.channelCreator());
                        PingBuilder.this.addPingListener(futurePing, futureResponse);
                    } else {
                        futurePing.failed(future);
                    }
                }
            });
        }
        return futurePing;
    }

    private FuturePing pingPeerConnection(final PeerConnection peerConnection) {
        final FuturePing futurePing = new FuturePing();
        final RequestHandler<FutureResponse> request = this.peer.pingRPC().ping(peerConnection.remotePeer(), this.connectionConfiguration);
        FutureChannelCreator futureChannelCreator = peerConnection.acquire(request.futureResponse());
        futureChannelCreator.addListener((BaseFutureListener<BaseFuture>)new BaseFutureAdapter<FutureChannelCreator>(){

            @Override
            public void operationComplete(FutureChannelCreator future) throws Exception {
                if (future.isSuccess()) {
                    ((FutureResponse)request.futureResponse()).request().keepAlive(true);
                    Object futureResponse = request.sendTCP(peerConnection);
                    PingBuilder.this.addPingListener(futurePing, futureResponse);
                } else {
                    futurePing.failed(future);
                }
            }
        });
        return futurePing;
    }

    private void addPingListener(final FuturePing futurePing, FutureResponse futureResponse) {
        futureResponse.addListener((BaseFutureListener<BaseFuture>)new BaseFutureAdapter<FutureResponse>(){

            @Override
            public void operationComplete(FutureResponse future) throws Exception {
                if (future.isSuccess()) {
                    futurePing.done(future.responseMessage().sender());
                } else {
                    futurePing.failed(future);
                }
            }
        });
    }
}

