/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.p2p;

import net.tomp2p.p2p.RequestConfiguration;

public class RequestP2PConfiguration
implements RequestConfiguration {
    private final int minimumResults;
    private final int maxFailure;
    private final int parallelDiff;
    private final boolean forceUDP;
    private final boolean forceTCP;

    public RequestP2PConfiguration(int minimumResults, int maxFailure, int parallelDiff) {
        this(minimumResults, maxFailure, parallelDiff, false, false);
    }

    public RequestP2PConfiguration(int minimumResults, int maxFailure, int parallelDiff, boolean forceUDP, boolean forceTCP) {
        if (minimumResults < 0 || maxFailure < 0 || parallelDiff < 0) {
            throw new IllegalArgumentException("Some values need to be larger or equal to zero.");
        }
        this.minimumResults = minimumResults;
        this.maxFailure = maxFailure;
        this.parallelDiff = parallelDiff;
        this.forceUDP = forceUDP;
        this.forceTCP = forceTCP;
    }

    public RequestP2PConfiguration adjustMinimumResult(int minimumResultsLow) {
        return new RequestP2PConfiguration(Math.min(minimumResultsLow, this.minimumResults), this.maxFailure, this.parallelDiff, this.forceUDP, this.forceTCP);
    }

    public int minimumResults() {
        return this.minimumResults;
    }

    public int maxFailure() {
        return this.maxFailure;
    }

    public int parallelDiff() {
        return this.parallelDiff;
    }

    @Override
    public int parallel() {
        return this.minimumResults + this.parallelDiff;
    }

    @Override
    public boolean isForceUPD() {
        return this.forceUDP;
    }

    @Override
    public boolean isForceTCP() {
        return this.forceTCP;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("minRes=");
        sb.append(this.minimumResults);
        sb.append("maxFail=");
        sb.append(this.maxFailure);
        sb.append("pDiff=");
        sb.append(this.parallelDiff);
        return sb.toString();
    }
}

