/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.p2p;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.BaseFutureImpl;
import net.tomp2p.futures.BaseFutureListener;
import net.tomp2p.futures.FutureDone;
import net.tomp2p.p2p.Peer;
import net.tomp2p.peers.Maintainable;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.peers.PeerStatistic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaintenanceTask
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(MaintenanceTask.class);
    private static final int MAX_PING = 5;
    private static final AtomicInteger COUNTER = new AtomicInteger(0);
    private Peer peer;
    private int intervalMillis = 1000;
    private List<Maintainable> maintainables = new ArrayList<Maintainable>();
    private Map<BaseFuture, PeerAddress> runningFutures = new HashMap<BaseFuture, PeerAddress>();
    private boolean shutdown = false;
    private final Object lock = new Object();
    private ScheduledFuture<?> scheduledFuture;

    public void init(Peer peer, ScheduledExecutorService timer) {
        this.peer = peer;
        this.scheduledFuture = timer.scheduleAtFixedRate(this, this.intervalMillis, this.intervalMillis, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object = this.lock;
        synchronized (object) {
            if (this.shutdown || COUNTER.get() > 5) {
                return;
            }
            for (Maintainable maintainable : this.maintainables) {
                BaseFutureImpl future;
                PeerStatistic peerStatatistic = maintainable.nextForMaintenance(this.runningFutures.values());
                if (peerStatatistic == null) continue;
                if (peerStatatistic.isLocal()) {
                    future = this.peer.localAnnounce().ping().peerAddress(peerStatatistic.peerAddress()).start();
                    LOG.debug("Maintenance local ping from {} to {}.", (Object)this.peer.peerAddress(), (Object)peerStatatistic.peerAddress());
                } else {
                    future = this.peer.ping().peerAddress(peerStatatistic.peerAddress()).start();
                    LOG.debug("Maintenance ping from {} to {}.", (Object)this.peer.peerAddress(), (Object)peerStatatistic.peerAddress());
                }
                this.peer.notifyAutomaticFutures(future);
                this.runningFutures.put(future, peerStatatistic.peerAddress());
                COUNTER.incrementAndGet();
                future.addListener((BaseFutureListener<? extends BaseFuture>)new BaseFutureAdapter<BaseFuture>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void operationComplete(BaseFuture future) throws Exception {
                        Object object = MaintenanceTask.this.lock;
                        synchronized (object) {
                            MaintenanceTask.this.runningFutures.remove(future);
                            COUNTER.decrementAndGet();
                        }
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FutureDone<Void> shutdown() {
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(false);
        }
        final FutureDone<Void> futureShutdown = new FutureDone<Void>();
        Object object = this.lock;
        synchronized (object) {
            this.shutdown = true;
            final int max = this.runningFutures.size();
            if (max == 0) {
                futureShutdown.done();
                return futureShutdown;
            }
            final AtomicInteger counter = new AtomicInteger(0);
            for (BaseFuture future : this.runningFutures.keySet()) {
                future.addListener((BaseFutureListener<? extends BaseFuture>)new BaseFutureAdapter<BaseFuture>(){

                    @Override
                    public void operationComplete(BaseFuture future) throws Exception {
                        if (counter.incrementAndGet() == max) {
                            futureShutdown.done();
                        }
                    }
                });
            }
        }
        return futureShutdown;
    }

    public int intervalMillis() {
        return this.intervalMillis;
    }

    public MaintenanceTask intervalMillis(int intervalMillis) {
        this.intervalMillis = intervalMillis;
        return this;
    }

    public void addMaintainable(Maintainable maintainable) {
        this.maintainables.add(maintainable);
    }
}

