/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.message;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import java.io.IOException;
import net.tomp2p.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Buffer {
    private static final Logger LOG = LoggerFactory.getLogger(Buffer.class);
    private final ByteBuf buffer;
    private final int length;
    private int read = 0;

    public Buffer(ByteBuf buffer, int length) {
        this.buffer = buffer;
        this.length = length;
    }

    public Buffer(ByteBuf buffer) {
        this.buffer = buffer;
        this.length = buffer.readableBytes();
    }

    public int length() {
        return this.length;
    }

    public ByteBuf buffer() {
        return this.buffer;
    }

    public int readable() {
        int remaining = this.length - this.read;
        int available = this.buffer.readableBytes();
        return Math.min(remaining, available);
    }

    public boolean isComplete() {
        return this.length == this.buffer.readableBytes();
    }

    public int incRead(int read) {
        this.read += read;
        return this.read;
    }

    public boolean done() {
        return this.read == this.length;
    }

    public int alreadyRead() {
        return this.read;
    }

    public Buffer addComponent(ByteBuf slice) {
        if (this.buffer instanceof CompositeByteBuf) {
            CompositeByteBuf cbb = (CompositeByteBuf)this.buffer;
            slice.retain();
            cbb.addComponent(slice);
            cbb.writerIndex(cbb.writerIndex() + slice.readableBytes());
        } else {
            this.buffer.writeBytes(slice);
            LOG.debug("Buffer copied. You can use a CompositeByteBuf");
        }
        return this;
    }

    public Object object() throws ClassNotFoundException, IOException {
        return Utils.decodeJavaObject(this.buffer.duplicate().readerIndex(0));
    }

    protected void finalize() throws Throwable {
        this.buffer.release();
    }

    public int hashCode() {
        return this.buffer.duplicate().readerIndex(0).hashCode() ^ this.length;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Buffer)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        Buffer b = (Buffer)obj;
        if (b.length != this.length) {
            return false;
        }
        return b.buffer.duplicate().readerIndex(0).equals((Object)this.buffer.duplicate().readerIndex(0));
    }

    public void reset() {
        this.read = 0;
        this.buffer.resetReaderIndex();
    }
}

