/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.futures;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.FutureDone;

public class Futures {
    public static <K extends BaseFuture> FutureDone<K[]> whenAll(K ... all) {
        final AtomicInteger counter = new AtomicInteger();
        final int size = all.length;
        final FutureDone<K[]> futureDone = new FutureDone<K[]>();
        for (K future : all) {
            future.addListener(new BaseFutureAdapter<K>((BaseFuture[])all){
                final /* synthetic */ BaseFuture[] val$all;
                {
                    this.val$all = baseFutureArray;
                }

                @Override
                public void operationComplete(K future) throws Exception {
                    if (counter.incrementAndGet() == size) {
                        futureDone.done(this.val$all);
                    }
                }
            });
        }
        return futureDone;
    }

    public static <K extends BaseFuture> FutureDone<List<K>> whenAll(final List<K> all) {
        final AtomicInteger counter = new AtomicInteger();
        final int size = all.size();
        final FutureDone<List<K>> futureDone = new FutureDone<List<K>>();
        for (BaseFuture future : all) {
            future.addListener(new BaseFutureAdapter<K>(){

                @Override
                public void operationComplete(K future) throws Exception {
                    if (counter.incrementAndGet() == size) {
                        futureDone.done(all);
                    }
                }
            });
        }
        return futureDone;
    }

    public static <K extends BaseFuture> FutureDone<List<K>> whenAllSuccess(final List<K> all) {
        final AtomicInteger counter = new AtomicInteger();
        final int size = all.size();
        final FutureDone<List<K>> futureDone = new FutureDone<List<K>>();
        for (BaseFuture future : all) {
            future.addListener(new BaseFutureAdapter<K>(){

                @Override
                public void operationComplete(K future) throws Exception {
                    if (futureDone.isCompleted()) {
                        return;
                    }
                    if (future.isFailed()) {
                        futureDone.failed((BaseFuture)future);
                    } else if (counter.incrementAndGet() == size) {
                        futureDone.done(all);
                    }
                }
            });
        }
        return futureDone;
    }

    public static <K extends BaseFuture> FutureDone<K[]> whenAllSuccess(K ... all) {
        final AtomicInteger counter = new AtomicInteger();
        final int size = all.length;
        final FutureDone<K[]> futureDone = new FutureDone<K[]>();
        for (K future : all) {
            future.addListener(new BaseFutureAdapter<K>((BaseFuture[])all){
                final /* synthetic */ BaseFuture[] val$all;
                {
                    this.val$all = baseFutureArray;
                }

                @Override
                public void operationComplete(K future) throws Exception {
                    if (futureDone.isCompleted()) {
                        return;
                    }
                    if (future.isFailed()) {
                        futureDone.failed((BaseFuture)future);
                    } else if (counter.incrementAndGet() == size) {
                        futureDone.done(this.val$all);
                    }
                }
            });
        }
        return futureDone;
    }

    public static <K extends BaseFuture> FutureDone<K> whenAny(List<K> all) {
        final FutureDone futureDone = new FutureDone();
        for (BaseFuture future : all) {
            future.addListener(new BaseFutureAdapter<K>(){

                @Override
                public void operationComplete(K future) throws Exception {
                    futureDone.done(future);
                }
            });
        }
        return futureDone;
    }

    public static <K extends BaseFuture> FutureDone<K> whenAny(K ... all) {
        final FutureDone futureDone = new FutureDone();
        for (K future : all) {
            future.addListener(new BaseFutureAdapter<K>(){

                @Override
                public void operationComplete(K future) throws Exception {
                    futureDone.done(future);
                }
            });
        }
        return futureDone;
    }

    public static <K extends BaseFuture> FutureDone<K> whenAnySuccess(List<K> all) {
        final AtomicInteger counter = new AtomicInteger();
        final int size = all.size();
        final FutureDone futureDone = new FutureDone();
        for (BaseFuture future : all) {
            future.addListener(new BaseFutureAdapter<K>(){

                @Override
                public void operationComplete(K future) throws Exception {
                    if (futureDone.isCompleted()) {
                        return;
                    }
                    if (future.isSuccess()) {
                        futureDone.done(future);
                    } else if (counter.incrementAndGet() == size) {
                        futureDone.failed("not a single future was successful");
                    }
                }
            });
        }
        return futureDone;
    }

    public static <K extends BaseFuture> FutureDone<K> whenAnySuccess(K ... all) {
        final AtomicInteger counter = new AtomicInteger();
        final int size = all.length;
        final FutureDone futureDone = new FutureDone();
        for (K future : all) {
            future.addListener(new BaseFutureAdapter<K>(){

                @Override
                public void operationComplete(K future) throws Exception {
                    if (futureDone.isCompleted()) {
                        return;
                    }
                    if (future.isSuccess()) {
                        futureDone.done(future);
                    } else if (counter.incrementAndGet() == size) {
                        futureDone.failed("not a single future was successful");
                    }
                }
            });
        }
        return futureDone;
    }
}

