/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.connection;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class DropConnectionInboundHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(DropConnectionInboundHandler.class);
    private final AtomicInteger counter = new AtomicInteger();
    final int limit;

    public DropConnectionInboundHandler(int limit) {
        this.limit = limit;
    }

    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        int current = this.counter.incrementAndGet();
        if (current > this.limit) {
            ctx.channel().close();
            LOG.warn("Dropped connection because {} > {} connections active.", (Object)current, (Object)this.limit);
        } else {
            ctx.fireChannelRegistered();
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.counter.decrementAndGet();
        ctx.fireChannelInactive();
    }
}

