/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.p2p;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Random;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.concurrent.atomic.AtomicReferenceArray;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.futures.FutureRouting;
import net.tomp2p.p2p.PostRoutingFilter;
import net.tomp2p.p2p.UpdatableTreeSet;
import net.tomp2p.p2p.builder.RoutingBuilder;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.peers.PeerMapFilter;
import net.tomp2p.peers.PeerStatistic;
import net.tomp2p.rpc.DigestInfo;
import net.tomp2p.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoutingMechanism {
    private static final Logger LOG = LoggerFactory.getLogger(RoutingMechanism.class);
    private final AtomicReferenceArray<FutureResponse> futureResponses;
    private final FutureRouting futureRoutingResponse;
    private final Collection<PeerMapFilter> peerMapFilters;
    private NavigableSet<PeerStatistic> queueToAsk;
    private SortedSet<PeerAddress> alreadyAsked;
    private SortedMap<PeerAddress, DigestInfo> directHits;
    private NavigableSet<PeerAddress> potentialHits;
    private int nrNoNewInfo = 0;
    private int nrFailures = 0;
    private int nrSuccess = 0;
    private int maxDirectHits;
    private int maxNoNewInfo;
    private int maxFailures;
    private int maxSuccess;
    private boolean stopCreatingNewFutures;

    public RoutingMechanism(AtomicReferenceArray<FutureResponse> futureResponses, FutureRouting futureRoutingResponse, Collection<PeerMapFilter> peerMapFilters) {
        this.futureResponses = futureResponses;
        this.futureRoutingResponse = futureRoutingResponse;
        this.peerMapFilters = peerMapFilters;
    }

    public FutureRouting futureRoutingResponse() {
        return this.futureRoutingResponse;
    }

    public int parallel() {
        return this.futureResponses.length();
    }

    public boolean isStopCreatingNewFutures() {
        return this.stopCreatingNewFutures;
    }

    public FutureResponse futureResponse(int i) {
        return this.futureResponses.get(i);
    }

    public FutureResponse futureResponse(int i, FutureResponse futureResponse) {
        return this.futureResponses.getAndSet(i, futureResponse);
    }

    public RoutingMechanism queueToAsk(NavigableSet<PeerStatistic> queueToAsk) {
        this.queueToAsk = queueToAsk;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NavigableSet<PeerStatistic> queueToAsk() {
        RoutingMechanism routingMechanism = this;
        synchronized (routingMechanism) {
            return this.queueToAsk;
        }
    }

    public RoutingMechanism alreadyAsked(SortedSet<PeerAddress> alreadyAsked) {
        this.alreadyAsked = alreadyAsked;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedSet<PeerAddress> alreadyAsked() {
        RoutingMechanism routingMechanism = this;
        synchronized (routingMechanism) {
            return this.alreadyAsked;
        }
    }

    public RoutingMechanism potentialHits(NavigableSet<PeerAddress> potentialHits) {
        this.potentialHits = potentialHits;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NavigableSet<PeerAddress> potentialHits() {
        RoutingMechanism routingMechanism = this;
        synchronized (routingMechanism) {
            return this.potentialHits;
        }
    }

    public RoutingMechanism directHits(SortedMap<PeerAddress, DigestInfo> directHits) {
        this.directHits = directHits;
        return this;
    }

    public SortedMap<PeerAddress, DigestInfo> directHits() {
        return this.directHits;
    }

    public int getMaxDirectHits() {
        return this.maxDirectHits;
    }

    public void maxDirectHits(int maxDirectHits) {
        this.maxDirectHits = maxDirectHits;
    }

    public int maxNoNewInfo() {
        return this.maxNoNewInfo;
    }

    public void maxNoNewInfo(int maxNoNewInfo) {
        this.maxNoNewInfo = maxNoNewInfo;
    }

    public int maxFailures() {
        return this.maxFailures;
    }

    public void maxFailures(int maxFailures) {
        this.maxFailures = maxFailures;
    }

    public int maxSucess() {
        return this.maxSuccess;
    }

    public void maxSucess(int maxSucess) {
        this.maxSuccess = maxSucess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PeerAddress pollFirstInQueueToAsk() {
        RoutingMechanism routingMechanism = this;
        synchronized (routingMechanism) {
            PeerStatistic first = this.queueToAsk.pollFirst();
            if (first == null) {
                return null;
            }
            return first.peerAddress();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PeerAddress pollRandomInQueueToAsk(Random rnd) {
        RoutingMechanism routingMechanism = this;
        synchronized (routingMechanism) {
            PeerStatistic first = Utils.pollRandom(this.queueToAsk(), rnd);
            if (first == null) {
                return null;
            }
            return first.peerAddress();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToAlreadyAsked(PeerAddress next) {
        RoutingMechanism routingMechanism = this;
        synchronized (routingMechanism) {
            this.alreadyAsked.add(next);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void neighbors(RoutingBuilder builder) {
        RoutingMechanism routingMechanism = this;
        synchronized (routingMechanism) {
            RoutingMechanism.applyPostRouting(builder, this.directHits, this.potentialHits);
            this.futureRoutingResponse.neighbors(this.directHits, this.potentialHits, this.alreadyAsked, builder.isBootstrap(), builder.isRoutingToOthers());
        }
    }

    public void cancel() {
        int len = this.futureResponses.length();
        for (int i = 0; i < len; ++i) {
            BaseFuture baseFuture = this.futureResponses.get(i);
            if (baseFuture == null) continue;
            baseFuture.cancel();
        }
    }

    public AtomicReferenceArray<FutureResponse> futureResponses() {
        return this.futureResponses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPotentialHits(PeerAddress remotePeer) {
        RoutingMechanism routingMechanism = this;
        synchronized (routingMechanism) {
            this.potentialHits.add(remotePeer);
        }
    }

    public void stopCreatingNewFutures(boolean stopCreatingNewFutures) {
        this.stopCreatingNewFutures = stopCreatingNewFutures;
    }

    public boolean evaluateFailed() {
        return ++this.nrFailures > this.maxFailures();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean evaluateSuccess(PeerAddress remotePeer, DigestInfo digestBean, Collection<PeerStatistic> newNeighbors, boolean last, Number160 locationkey) {
        boolean finished;
        RoutingMechanism routingMechanism = this;
        synchronized (routingMechanism) {
            this.filterPeers(newNeighbors, this.alreadyAsked, this.queueToAsk, locationkey);
            if (RoutingMechanism.evaluateDirectHits(remotePeer, this.directHits, digestBean, this.getMaxDirectHits())) {
                LOG.debug("we have enough direct hits {}", this.directHits);
                finished = true;
                this.stopCreatingNewFutures = true;
            } else if (++this.nrSuccess > this.maxSucess()) {
                LOG.debug("we have reached max success {}", (Object)this.nrSuccess);
                finished = last;
                this.stopCreatingNewFutures = true;
            } else if (this.evaluateInformation(newNeighbors, this.queueToAsk, this.alreadyAsked, this.maxNoNewInfo())) {
                LOG.debug("we have no new information for the {} time", (Object)this.maxNoNewInfo());
                finished = last;
                this.stopCreatingNewFutures = true;
            } else {
                finished = false;
                this.stopCreatingNewFutures = false;
            }
        }
        return finished;
    }

    private void filterPeers(Collection<PeerStatistic> newNeighbors, SortedSet<PeerAddress> alreadyAsked, NavigableSet<PeerStatistic> queueToAsk, Number160 locationkey) {
        if (this.peerMapFilters == null || this.peerMapFilters.size() == 0) {
            return;
        }
        ArrayList<PeerAddress> all = new ArrayList<PeerAddress>();
        all.addAll(alreadyAsked);
        for (PeerStatistic peerStatistic : queueToAsk) {
            all.add(peerStatistic.peerAddress());
        }
        Iterator<PeerStatistic> iterator = newNeighbors.iterator();
        while (iterator.hasNext()) {
            PeerAddress newNeighbor = iterator.next().peerAddress();
            for (PeerMapFilter peerFilter : this.peerMapFilters) {
                if (!peerFilter.rejectPreRouting(newNeighbor, all)) continue;
                iterator.remove();
            }
        }
    }

    static boolean evaluateDirectHits(PeerAddress remotePeer, Map<PeerAddress, DigestInfo> directHits, DigestInfo digestBean, int maxDirectHits) {
        if (digestBean.size() > 0) {
            directHits.put(remotePeer, digestBean);
            if (directHits.size() >= maxDirectHits) {
                return true;
            }
        }
        return false;
    }

    boolean evaluateInformation(Collection<PeerStatistic> newNeighbors, SortedSet<PeerStatistic> queueToAsk, Set<PeerAddress> alreadyAsked, int maxNoNewInfo) {
        boolean newInformation = RoutingMechanism.merge(queueToAsk, newNeighbors, alreadyAsked);
        if (newInformation) {
            this.nrNoNewInfo = 0;
            return false;
        }
        return ++this.nrNoNewInfo >= maxNoNewInfo;
    }

    static boolean merge(SortedSet<PeerStatistic> queueToAsk, Collection<PeerStatistic> newPeers, Collection<PeerAddress> alreadyAsked) {
        UpdatableTreeSet<PeerStatistic> result = new UpdatableTreeSet<PeerStatistic>(queueToAsk.comparator());
        for (PeerStatistic newPeer : newPeers) {
            if (alreadyAsked.contains(newPeer.peerAddress())) continue;
            result.add(newPeer);
        }
        if (result.size() == 0) {
            return false;
        }
        PeerStatistic first = (PeerStatistic)result.first();
        boolean newInfo = RoutingMechanism.isNew(queueToAsk, first);
        queueToAsk.addAll(result);
        return newInfo;
    }

    private static boolean isNew(SortedSet<PeerStatistic> queueToAsk, PeerStatistic item) {
        if (queueToAsk.contains(item)) {
            return false;
        }
        SortedSet<PeerStatistic> tmp = queueToAsk.headSet(item);
        return tmp.size() == 0;
    }

    public int nrNoNewInfo() {
        return this.nrNoNewInfo;
    }

    private static void applyPostRouting(RoutingBuilder routingBuilder, SortedMap<PeerAddress, DigestInfo> directHits, NavigableSet<PeerAddress> potentialHits) {
        if (routingBuilder.postRoutingFilters() != null) {
            for (PostRoutingFilter filter : routingBuilder.postRoutingFilters()) {
                Iterator<PeerAddress> potentialIter = potentialHits.iterator();
                while (potentialIter.hasNext()) {
                    if (!filter.rejectPotentialHit(potentialIter.next())) continue;
                    potentialIter.remove();
                }
                Iterator<PeerAddress> directIter = directHits.keySet().iterator();
                while (directIter.hasNext()) {
                    if (!filter.rejectDirectHit(directIter.next())) continue;
                    directIter.remove();
                }
            }
        }
    }
}

