/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.message;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.socket.DatagramPacket;
import java.net.InetSocketAddress;
import net.tomp2p.connection.SignatureFactory;
import net.tomp2p.message.Decoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class TomP2PSinglePacketUDP
extends ChannelInboundHandlerAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(TomP2PSinglePacketUDP.class);
    private final SignatureFactory signatureFactory;
    private final ByteBufAllocator byteBufAllocator;

    public TomP2PSinglePacketUDP(SignatureFactory signatureFactory, ByteBufAllocator byteBufAllocator) {
        this.signatureFactory = signatureFactory;
        this.byteBufAllocator = byteBufAllocator;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (!(msg instanceof DatagramPacket)) {
            ctx.fireChannelRead(msg);
            return;
        }
        DatagramPacket d = (DatagramPacket)msg;
        LOG.debug("got UDP message {}", (Object)d);
        ByteBuf buf = (ByteBuf)d.content();
        InetSocketAddress sender = (InetSocketAddress)d.sender();
        InetSocketAddress recipient = (InetSocketAddress)d.recipient();
        try {
            Decoder decoder = new Decoder(this.signatureFactory, this.byteBufAllocator);
            boolean finished = decoder.decode(ctx, buf, recipient, sender);
            if (finished) {
                ctx.fireChannelRead((Object)decoder.prepareFinish());
            } else {
                LOG.warn("did not get the complete packet!");
            }
        }
        catch (Throwable t) {
            LOG.error("Error in UDP decoding", t);
            throw new Exception(t);
        }
        finally {
            buf.release();
        }
    }
}

