/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.message;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import net.tomp2p.connection.SignatureFactory;
import net.tomp2p.message.Encoder;
import net.tomp2p.message.Message;
import net.tomp2p.storage.AlternativeCompositeByteBuf;
import net.tomp2p.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TomP2POutbound
extends ChannelOutboundHandlerAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(TomP2POutbound.class);
    private final Encoder encoder;
    private final ByteBufAllocator byteBufAllocator;

    public TomP2POutbound(SignatureFactory signatureFactory, ByteBufAllocator byteBufAllocator) {
        this.encoder = new Encoder(signatureFactory);
        this.byteBufAllocator = byteBufAllocator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        AlternativeCompositeByteBuf buf = null;
        if (!(msg instanceof Message)) {
            ctx.write(msg, promise);
            return;
        }
        try {
            boolean done = false;
            buf = AlternativeCompositeByteBuf.compBuffer(this.byteBufAllocator, buf);
            done = this.encoder.write(buf, (Message)msg, null);
            Message message = this.encoder.message();
            if (buf.isReadable()) {
                if (ctx.channel() instanceof DatagramChannel) {
                    InetSocketAddress sender;
                    InetSocketAddress recipient;
                    if (message.senderSocket() == null) {
                        InetSocketAddress recipientUnreflected = message.recipientRelay() != null ? message.recipientRelay().createSocketUDP() : message.recipient().createSocketUDP();
                        recipient = Utils.natReflection(recipientUnreflected, true, message.sender());
                        sender = message.sender().createSocketUDP(0);
                    } else {
                        recipient = message.senderSocket();
                        sender = message.recipientSocket();
                    }
                    recipient = new InetSocketAddress(InetAddress.getByAddress(recipient.getAddress().getAddress()), recipient.getPort());
                    sender = new InetSocketAddress(InetAddress.getByAddress(sender.getAddress().getAddress()), sender.getPort());
                    DatagramPacket d = new DatagramPacket((ByteBuf)buf, recipient, sender);
                    LOG.debug("Send UPD message {}, datagram: {}", (Object)message, (Object)d);
                    ctx.writeAndFlush((Object)d, promise);
                } else {
                    LOG.debug("Send TCP message {} to {}", (Object)message, (Object)message.senderSocket());
                    ctx.writeAndFlush((Object)buf, promise);
                }
                if (done) {
                    message.setDone(true);
                    this.encoder.reset();
                }
            } else {
                buf.release();
                ctx.write((Object)Unpooled.EMPTY_BUFFER, promise);
            }
            buf = null;
        }
        catch (Throwable t) {
            this.exceptionCaught(ctx, t);
        }
        finally {
            if (buf != null) {
                buf.release();
            }
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (this.encoder.message() == null) {
            LOG.error("exception in encoding, starting", cause);
            cause.printStackTrace();
        } else if (this.encoder.message() != null && !this.encoder.message().isDone()) {
            LOG.error("exception in encoding, started", cause);
            cause.printStackTrace();
        }
    }
}

