/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.connection;

import io.netty.channel.EventLoopGroup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.tomp2p.connection.ChannelClientConfiguration;
import net.tomp2p.connection.ChannelCreator;
import net.tomp2p.connection.DefaultConnectionConfiguration;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.BaseFutureListener;
import net.tomp2p.futures.FutureChannelCreator;
import net.tomp2p.futures.FutureDone;
import net.tomp2p.p2p.RequestConfiguration;
import net.tomp2p.p2p.RoutingConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Reservation {
    private static final Logger LOG = LoggerFactory.getLogger(Reservation.class);
    private final int maxPermitsUDP;
    private final int maxPermitsTCP;
    private final int maxPermitsPermanentTCP;
    private final Semaphore semaphoreUPD;
    private final Semaphore semaphoreTCP;
    private final Semaphore semaphorePermanentTCP;
    private final ChannelClientConfiguration channelClientConfiguration;
    private final BlockingQueue<Runnable> queue = new LinkedBlockingQueue<Runnable>();
    private final ExecutorService executor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, this.queue);
    private final EventLoopGroup workerGroup;
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock(true);
    private final Lock read = this.readWriteLock.readLock();
    private final Lock write = this.readWriteLock.writeLock();
    private boolean shutdown = false;
    private final Collection<ChannelCreator> channelCreators = Collections.synchronizedList(new ArrayList());
    private final FutureDone<Void> futureReservationDone = new FutureDone();

    public Reservation(EventLoopGroup workerGroup, ChannelClientConfiguration channelClientConfiguration) {
        this.workerGroup = workerGroup;
        this.maxPermitsUDP = channelClientConfiguration.maxPermitsUDP();
        this.maxPermitsTCP = channelClientConfiguration.maxPermitsTCP();
        this.maxPermitsPermanentTCP = channelClientConfiguration.maxPermitsPermanentTCP();
        this.semaphoreUPD = new Semaphore(this.maxPermitsUDP);
        this.semaphoreTCP = new Semaphore(this.maxPermitsTCP);
        this.semaphorePermanentTCP = new Semaphore(this.maxPermitsPermanentTCP);
        this.channelClientConfiguration = channelClientConfiguration;
    }

    public int pendingRequests() {
        return this.queue.size();
    }

    public FutureChannelCreator create(RoutingConfiguration routingConfiguration, RequestConfiguration requestP2PConfiguration, DefaultConnectionConfiguration builder) {
        if (routingConfiguration == null && requestP2PConfiguration == null) {
            throw new IllegalArgumentException("Both routingConfiguration and requestP2PConfiguration cannot be null");
        }
        int nrConnectionsTCP = 0;
        int nrConnectionsUDP = 0;
        if (requestP2PConfiguration != null) {
            if (builder.isForceUDP()) {
                nrConnectionsUDP = requestP2PConfiguration.parallel();
            } else {
                nrConnectionsTCP = requestP2PConfiguration.parallel();
            }
        }
        if (routingConfiguration != null) {
            if (!builder.isForceTCP()) {
                nrConnectionsUDP = Math.max(nrConnectionsUDP, routingConfiguration.parallel());
            } else {
                nrConnectionsTCP = Math.max(nrConnectionsTCP, routingConfiguration.parallel());
            }
        }
        LOG.debug("Reservation UDP={}, TCP={}", (Object)nrConnectionsUDP, (Object)nrConnectionsTCP);
        return this.create(nrConnectionsUDP, nrConnectionsTCP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FutureChannelCreator create(final int permitsUDP, final int permitsTCP) {
        if (permitsUDP > this.maxPermitsUDP) {
            throw new IllegalArgumentException("cannot aquire more UDP connections (" + permitsUDP + ") than maximum " + this.maxPermitsUDP);
        }
        if (permitsTCP > this.maxPermitsTCP) {
            throw new IllegalArgumentException("cannot aquire more TCP connections (" + permitsTCP + ") than maximum " + this.maxPermitsTCP);
        }
        FutureChannelCreator futureChannelCreator = new FutureChannelCreator();
        this.read.lock();
        try {
            if (this.shutdown) {
                FutureChannelCreator futureChannelCreator2 = (FutureChannelCreator)futureChannelCreator.failed("shutting down");
                return futureChannelCreator2;
            }
            FutureDone<Void> futureChannelCreationDone = new FutureDone<Void>();
            futureChannelCreationDone.addListener((BaseFutureListener<BaseFuture>)new BaseFutureAdapter<FutureDone<Void>>(){

                @Override
                public void operationComplete(FutureDone<Void> future) throws Exception {
                    Reservation.this.semaphoreUPD.release(permitsUDP);
                    Reservation.this.semaphoreTCP.release(permitsTCP);
                }
            });
            this.executor.execute(new WaitReservation(futureChannelCreator, futureChannelCreationDone, permitsUDP, permitsTCP));
            FutureChannelCreator futureChannelCreator3 = futureChannelCreator;
            return futureChannelCreator3;
        }
        finally {
            this.read.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FutureChannelCreator createPermanent(final int permitsPermanentTCP) {
        if (permitsPermanentTCP > this.maxPermitsPermanentTCP) {
            throw new IllegalArgumentException("cannot aquire more TCP connections (" + permitsPermanentTCP + ") than maximum " + this.maxPermitsPermanentTCP);
        }
        FutureChannelCreator futureChannelCreator = new FutureChannelCreator();
        this.read.lock();
        try {
            if (this.shutdown) {
                FutureChannelCreator futureChannelCreator2 = (FutureChannelCreator)futureChannelCreator.failed("shutting down");
                return futureChannelCreator2;
            }
            FutureDone futureChannelCreationDone = new FutureDone();
            futureChannelCreationDone.addListener((BaseFutureListener<BaseFuture>)new BaseFutureAdapter<FutureDone<Void>>(){

                @Override
                public void operationComplete(FutureDone<Void> future) throws Exception {
                    Reservation.this.semaphorePermanentTCP.release(permitsPermanentTCP);
                }
            });
            this.executor.execute(new WaitReservationPermanent(futureChannelCreator, futureChannelCreationDone, permitsPermanentTCP));
            FutureChannelCreator futureChannelCreator3 = futureChannelCreator;
            return futureChannelCreator3;
        }
        finally {
            this.read.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FutureDone<Void> shutdown() {
        ArrayList<ChannelCreator> copyChannelCreators;
        this.write.lock();
        try {
            if (this.shutdown) {
                FutureDone futureDone = (FutureDone)this.futureReservationDone.failed("already shutting down");
                return futureDone;
            }
            this.shutdown = true;
        }
        finally {
            this.write.unlock();
        }
        for (Runnable runnable : this.executor.shutdownNow()) {
            Runnable wr;
            if (runnable instanceof WaitReservation) {
                wr = (WaitReservation)runnable;
                ((WaitReservation)wr).futureChannelCreator().failed("shutting down");
                continue;
            }
            wr = (WaitReservationPermanent)runnable;
            ((WaitReservationPermanent)wr).futureChannelCreator().failed("shutting down");
        }
        Collection<ChannelCreator> collection = this.channelCreators;
        synchronized (collection) {
            copyChannelCreators = new ArrayList<ChannelCreator>(this.channelCreators);
        }
        final int n = copyChannelCreators.size();
        if (n == 0) {
            this.futureReservationDone.done();
        } else {
            final AtomicInteger completeCounter = new AtomicInteger(0);
            for (ChannelCreator channelCreator : copyChannelCreators) {
                channelCreator.shutdownFuture().addListener((BaseFutureListener<BaseFuture>)new BaseFutureAdapter<FutureDone<Void>>(){

                    @Override
                    public void operationComplete(FutureDone<Void> future) throws Exception {
                        if (completeCounter.incrementAndGet() == n) {
                            Reservation.this.semaphoreUPD.acquireUninterruptibly(Reservation.this.maxPermitsUDP);
                            Reservation.this.semaphoreTCP.acquireUninterruptibly(Reservation.this.maxPermitsTCP);
                            Reservation.this.semaphorePermanentTCP.acquireUninterruptibly(Reservation.this.maxPermitsPermanentTCP);
                            Reservation.this.futureReservationDone.done();
                        }
                    }
                });
                channelCreator.shutdown();
            }
        }
        return this.futureReservationDone;
    }

    private void addToSet(final ChannelCreator channelCreator) {
        channelCreator.shutdownFuture().addListener((BaseFutureListener<BaseFuture>)new BaseFutureAdapter<FutureDone<Void>>(){

            @Override
            public void operationComplete(FutureDone<Void> future) throws Exception {
                Reservation.this.channelCreators.remove(channelCreator);
            }
        });
        this.channelCreators.add(channelCreator);
    }

    private final class WaitReservationPermanent
    implements Runnable {
        private final FutureChannelCreator futureChannelCreator;
        private final FutureDone<Void> futureChannelCreationShutdown;
        private final int permitsPermanentTCP;

        private WaitReservationPermanent(FutureChannelCreator futureChannelCreator, FutureDone<Void> futureChannelCreationShutdown, int permitsPermanentTCP) {
            this.futureChannelCreator = futureChannelCreator;
            this.futureChannelCreationShutdown = futureChannelCreationShutdown;
            this.permitsPermanentTCP = permitsPermanentTCP;
        }

        @Override
        public void run() {
            ChannelCreator channelCreator;
            Reservation.this.read.lock();
            try {
                if (Reservation.this.shutdown) {
                    this.futureChannelCreator.failed("shutting down");
                    return;
                }
                try {
                    Reservation.this.semaphorePermanentTCP.acquire(this.permitsPermanentTCP);
                }
                catch (InterruptedException e) {
                    this.futureChannelCreator.failed(e);
                    Reservation.this.read.unlock();
                    return;
                }
                channelCreator = new ChannelCreator(Reservation.this.workerGroup, this.futureChannelCreationShutdown, 0, this.permitsPermanentTCP, Reservation.this.channelClientConfiguration);
                Reservation.this.addToSet(channelCreator);
            }
            finally {
                Reservation.this.read.unlock();
            }
            this.futureChannelCreator.reserved(channelCreator);
        }

        private FutureChannelCreator futureChannelCreator() {
            return this.futureChannelCreator;
        }
    }

    private class WaitReservation
    implements Runnable {
        private final FutureChannelCreator futureChannelCreator;
        private final FutureDone<Void> futureChannelCreationShutdown;
        private final int permitsUDP;
        private final int permitsTCP;

        public WaitReservation(FutureChannelCreator futureChannelCreator, FutureDone<Void> futureChannelCreationShutdown, int permitsUDP, int permitsTCP) {
            this.futureChannelCreator = futureChannelCreator;
            this.futureChannelCreationShutdown = futureChannelCreationShutdown;
            this.permitsUDP = permitsUDP;
            this.permitsTCP = permitsTCP;
        }

        @Override
        public void run() {
            ChannelCreator channelCreator;
            Reservation.this.read.lock();
            try {
                if (Reservation.this.shutdown) {
                    this.futureChannelCreator.failed("shutting down");
                    return;
                }
                try {
                    Reservation.this.semaphoreUPD.acquire(this.permitsUDP);
                }
                catch (InterruptedException e) {
                    this.futureChannelCreator.failed(e);
                    Reservation.this.read.unlock();
                    return;
                }
                try {
                    Reservation.this.semaphoreTCP.acquire(this.permitsTCP);
                }
                catch (InterruptedException e) {
                    Reservation.this.semaphoreUPD.release(this.permitsUDP);
                    this.futureChannelCreator.failed(e);
                    Reservation.this.read.unlock();
                    return;
                }
                channelCreator = new ChannelCreator(Reservation.this.workerGroup, this.futureChannelCreationShutdown, this.permitsUDP, this.permitsTCP, Reservation.this.channelClientConfiguration);
                Reservation.this.addToSet(channelCreator);
            }
            finally {
                Reservation.this.read.unlock();
            }
            this.futureChannelCreator.reserved(channelCreator);
        }

        private FutureChannelCreator futureChannelCreator() {
            return this.futureChannelCreator;
        }
    }
}

