/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.connection;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.tomp2p.connection.Bindings;
import net.tomp2p.connection.DiscoverNetworkListener;
import net.tomp2p.connection.DiscoverResults;
import net.tomp2p.futures.FutureDone;

public final class DiscoverNetworks {
    private final Collection<DiscoverNetworkListener> listeners = new ArrayList<DiscoverNetworkListener>(1);
    private final int checkIntervalMillis;
    private final Bindings bindings;
    private final ScheduledExecutorService timer;
    private ScheduledFuture<?> future;
    private boolean stopped = false;
    private volatile DiscoverResults discoverResults = null;

    public DiscoverNetworks(int checkIntervalMillis, Bindings bindings, ScheduledExecutorService timer) {
        this.checkIntervalMillis = checkIntervalMillis;
        this.bindings = bindings;
        this.timer = timer;
    }

    public FutureDone<Void> start() {
        final FutureDone<Void> futureDone = new FutureDone<Void>();
        final CountDownLatch futureExistsLatch = new CountDownLatch(1);
        this.future = this.timer.scheduleWithFixedDelay(new Runnable(){
            private boolean firstRun = true;

            @Override
            public void run() {
                try {
                    DiscoverNetworks.this.discoverResults = DiscoverNetworks.discoverInterfaces(DiscoverNetworks.this.bindings, DiscoverNetworks.this.discoverResults);
                    if (DiscoverNetworks.this.discoverResults.isListenAny()) {
                        futureExistsLatch.await();
                        DiscoverNetworks.this.future.cancel(false);
                        DiscoverNetworks.this.notifyDiscoverNetwork(DiscoverNetworks.this.discoverResults);
                    } else if (!DiscoverNetworks.this.discoverResults.isEmpty()) {
                        DiscoverNetworks.this.notifyDiscoverNetwork(DiscoverNetworks.this.discoverResults);
                    }
                    if (this.firstRun) {
                        futureDone.done();
                        this.firstRun = false;
                    }
                }
                catch (Throwable t) {
                    futureDone.done();
                    DiscoverNetworks.this.notifyFailure(t);
                }
            }
        }, 0L, this.checkIntervalMillis, TimeUnit.MILLISECONDS);
        futureExistsLatch.countDown();
        return futureDone;
    }

    public DiscoverResults currentDiscoverResults() {
        return this.discoverResults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        DiscoverNetworks discoverNetworks = this;
        synchronized (discoverNetworks) {
            this.stopped = true;
            if (this.future != null) {
                this.future.cancel(false);
            }
        }
    }

    public DiscoverNetworks addDiscoverNetworkListener(DiscoverNetworkListener listener) {
        this.listeners.add(listener);
        return this;
    }

    public DiscoverNetworks removeDiscoverNetworkListener(DiscoverNetworkListener listener) {
        this.listeners.remove(listener);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyDiscoverNetwork(DiscoverResults discoverResults) {
        DiscoverNetworks discoverNetworks = this;
        synchronized (discoverNetworks) {
            if (this.stopped) {
                return;
            }
            for (DiscoverNetworkListener listener : this.listeners) {
                listener.discoverNetwork(discoverResults);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyFailure(Throwable throwable) {
        DiscoverNetworks discoverNetworks = this;
        synchronized (discoverNetworks) {
            if (this.stopped) {
                return;
            }
            for (DiscoverNetworkListener listener : this.listeners) {
                listener.exception(throwable);
            }
        }
    }

    public static DiscoverResults discoverInterfaces(Bindings bindings) throws IOException {
        return DiscoverNetworks.discoverInterfaces(bindings, null);
    }

    public static DiscoverResults discoverInterfaces(Bindings bindings, DiscoverResults oldDiscoverResults) throws IOException {
        ArrayList<InetAddress> existingAddresses = new ArrayList<InetAddress>();
        ArrayList<InetAddress> existingBroadcastAddresses = new ArrayList<InetAddress>();
        ArrayList<InetAddress> existingAddressesOld = new ArrayList<InetAddress>();
        ArrayList<InetAddress> existingBroadcastAddressesOld = new ArrayList<InetAddress>();
        if (oldDiscoverResults != null) {
            existingAddresses.addAll(oldDiscoverResults.existingAddresses());
            existingBroadcastAddresses.addAll(oldDiscoverResults.existingBroadcastAddresses());
            existingAddressesOld.addAll(oldDiscoverResults.existingAddresses());
            existingBroadcastAddressesOld.addAll(oldDiscoverResults.existingBroadcastAddresses());
        }
        StringBuilder sb = new StringBuilder("Discover status: ");
        Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
        while (e.hasMoreElements()) {
            Object discoverResults;
            NetworkInterface networkInterface = e.nextElement();
            if (bindings.anyInterfaces()) {
                sb.append(" ++").append(networkInterface.getName());
                discoverResults = DiscoverNetworks.discoverNetwork(networkInterface, existingAddressesOld, existingBroadcastAddressesOld, bindings.isIPv4(), bindings.isIPv6());
                sb.append(((DiscoverResults)discoverResults).status()).append(",");
                DiscoverNetworks.addIfNotPresent(existingAddresses, ((DiscoverResults)discoverResults).existingAddresses());
                DiscoverNetworks.addIfNotPresent(existingBroadcastAddresses, ((DiscoverResults)discoverResults).existingBroadcastAddresses());
                continue;
            }
            if (bindings.containsInterface(networkInterface.getName())) {
                sb.append(" +").append(networkInterface.getName());
                discoverResults = DiscoverNetworks.discoverNetwork(networkInterface, existingAddressesOld, existingBroadcastAddressesOld, bindings.isIPv4(), bindings.isIPv6());
                sb.append(((DiscoverResults)discoverResults).status()).append(",");
                DiscoverNetworks.addIfNotPresent(existingAddresses, ((DiscoverResults)discoverResults).existingAddresses());
                DiscoverNetworks.addIfNotPresent(existingBroadcastAddresses, ((DiscoverResults)discoverResults).existingBroadcastAddresses());
                continue;
            }
            sb.append(" -").append(networkInterface.getName()).append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(".");
        ArrayList<InetAddress> newAddresses = new ArrayList<InetAddress>();
        for (InetAddress inetAddress : existingAddresses) {
            if (existingAddressesOld.contains(inetAddress)) continue;
            newAddresses.add(inetAddress);
        }
        ArrayList<InetAddress> newBroadcastAddresses = new ArrayList<InetAddress>();
        for (InetAddress inetAddress : existingBroadcastAddresses) {
            if (existingBroadcastAddressesOld.contains(inetAddress)) continue;
            newBroadcastAddresses.add(inetAddress);
        }
        ArrayList<InetAddress> arrayList = new ArrayList<InetAddress>();
        for (InetAddress inetAddress : existingAddressesOld) {
            if (existingAddresses.contains(inetAddress)) continue;
            arrayList.add(inetAddress);
        }
        ArrayList<InetAddress> arrayList2 = new ArrayList<InetAddress>();
        for (InetAddress existingBroadcastAddressOld : existingBroadcastAddressesOld) {
            if (existingBroadcastAddresses.contains(existingBroadcastAddressOld)) continue;
            arrayList2.add(existingBroadcastAddressOld);
        }
        DiscoverResults discoverResults = new DiscoverResults(newAddresses, newBroadcastAddresses, arrayList, arrayList2, existingAddresses, existingBroadcastAddresses, bindings.isListenAny(), sb.toString());
        return discoverResults;
    }

    private static void addIfNotPresent(Collection<InetAddress> existingAddresses, Collection<InetAddress> existingAddresses2) {
        for (InetAddress inet : existingAddresses2) {
            if (existingAddresses.contains(inet)) continue;
            existingAddresses.add(inet);
        }
    }

    public static DiscoverResults discoverNetwork(NetworkInterface networkInterface, Collection<InetAddress> foundAddresses, Collection<InetAddress> foundBroadcastAddresses, boolean isIPv4, boolean isIPv6) {
        ArrayList<InetAddress> foundAddresses2 = new ArrayList<InetAddress>(foundAddresses);
        ArrayList<InetAddress> foundBroadcastAddresses2 = new ArrayList<InetAddress>(foundBroadcastAddresses);
        StringBuilder sb = new StringBuilder("( ");
        for (InterfaceAddress iface : networkInterface.getInterfaceAddresses()) {
            if (iface == null) continue;
            InetAddress inet = iface.getAddress();
            InetAddress broadcast = iface.getBroadcast();
            if (broadcast != null && !broadcast.isAnyLocalAddress() && !foundBroadcastAddresses2.contains(broadcast)) {
                foundBroadcastAddresses2.add(broadcast);
            }
            if (inet instanceof Inet4Address && isIPv4) {
                sb.append(inet).append(",");
                if (foundAddresses2.contains(inet)) continue;
                foundAddresses2.add(inet);
                continue;
            }
            if (!(inet instanceof Inet6Address) || !isIPv6) continue;
            sb.append(inet).append(",");
            if (foundAddresses2.contains(inet)) continue;
            foundAddresses2.add(inet);
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(")");
        DiscoverResults discoverResults = new DiscoverResults(null, null, null, null, foundAddresses2, foundBroadcastAddresses2, false, sb.toString());
        return discoverResults;
    }
}

