/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.peers;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.Collection;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.peers.PeerMap;
import net.tomp2p.peers.PeerMapFilter;

public class PeerIPFilter
implements PeerMapFilter {
    final int mask4;
    final int mask6;

    public PeerIPFilter(int mask4, int mask6) {
        this.mask4 = mask4;
        this.mask6 = mask6;
    }

    @Override
    public boolean rejectPeerMap(PeerAddress peerAddress, PeerMap peerMap) {
        return this.rejectPreRouting(peerAddress, peerMap.all());
    }

    @Override
    public boolean rejectPreRouting(PeerAddress peerAddress, Collection<PeerAddress> all) {
        if (peerAddress.inetAddress() instanceof Inet4Address) {
            IPv4 ipv4 = IPv4.fromInetAddress(peerAddress.inetAddress());
            for (PeerAddress inMap : all) {
                if (!(inMap.inetAddress() instanceof Inet4Address)) continue;
                IPv4 ipv4Test = IPv4.fromInetAddress(inMap.inetAddress());
                if (!ipv4.maskWithNetworkMask(this.mask4).equals(ipv4Test.maskWithNetworkMask(this.mask4))) continue;
                return true;
            }
        } else {
            IPv6 ipv6 = IPv6.fromInetAddress(peerAddress.inetAddress());
            for (PeerAddress inMap : all) {
                if (!(inMap.inetAddress() instanceof Inet6Address)) continue;
                IPv6 ipv6Test = IPv6.fromInetAddress(inMap.inetAddress());
                if (!ipv6.maskWithNetworkMask(this.mask6).equals(ipv6Test.maskWithNetworkMask(this.mask6))) continue;
                return true;
            }
        }
        return false;
    }

    private static class IPv6 {
        private final long highBits;
        private final long lowBits;

        private IPv6(long highBits, long lowBits) {
            this.highBits = highBits;
            this.lowBits = lowBits;
        }

        public IPv6 maskWithNetworkMask(int networkMask) {
            if (networkMask == 128) {
                return this;
            }
            if (networkMask == 64) {
                return new IPv6(this.highBits, 0L);
            }
            if (networkMask > 64) {
                int remainingPrefixLength = networkMask - 64;
                return new IPv6(this.highBits, this.lowBits & -1L << 64 - remainingPrefixLength);
            }
            return new IPv6(this.highBits & -1L << 64 - networkMask, 0L);
        }

        public static IPv6 fromInetAddress(InetAddress inetAddress) {
            if (inetAddress == null) {
                throw new IllegalArgumentException("can not construct from [null]");
            }
            if (!(inetAddress instanceof Inet6Address)) {
                throw new IllegalArgumentException("must be IPv6");
            }
            byte[] buf = ((Inet6Address)inetAddress).getAddress();
            long highBits = ((long)buf[0] & 0xFFL) << 56 | ((long)buf[1] & 0xFFL) << 48 | ((long)buf[2] & 0xFFL) << 40 | ((long)buf[3] & 0xFFL) << 32 | ((long)buf[4] & 0xFFL) << 24 | ((long)buf[5] & 0xFFL) << 16 | ((long)buf[6] & 0xFFL) << 8 | ((long)buf[7] & 0xFFL) << 0;
            long lowBits = ((long)buf[8] & 0xFFL) << 56 | ((long)buf[9] & 0xFFL) << 48 | ((long)buf[10] & 0xFFL) << 40 | ((long)buf[11] & 0xFFL) << 32 | ((long)buf[12] & 0xFFL) << 24 | ((long)buf[13] & 0xFFL) << 16 | ((long)buf[14] & 0xFFL) << 8 | ((long)buf[15] & 0xFFL) << 0;
            return new IPv6(highBits, lowBits);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof IPv6)) {
                return false;
            }
            IPv6 o = (IPv6)obj;
            return this.highBits == o.highBits && this.lowBits == o.lowBits;
        }
    }

    private static class IPv4 {
        private final int bits;

        private IPv4(int bits) {
            this.bits = bits;
        }

        public IPv4 maskWithNetworkMask(int networkMask) {
            if (networkMask == 32) {
                return this;
            }
            return new IPv4(this.bits & -1 << 32 - networkMask);
        }

        public static IPv4 fromInetAddress(InetAddress inetAddress) {
            if (inetAddress == null) {
                throw new IllegalArgumentException("can not construct from [null]");
            }
            if (!(inetAddress instanceof Inet4Address)) {
                throw new IllegalArgumentException("must be IPv4");
            }
            byte[] buf = ((Inet4Address)inetAddress).getAddress();
            int ip = (buf[0] & 0xFF) << 24 | (buf[1] & 0xFF) << 16 | (buf[2] & 0xFF) << 8 | (buf[3] & 0xFF) << 0;
            return new IPv4(ip);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof IPv4)) {
                return false;
            }
            IPv4 o = (IPv4)obj;
            return this.bits == o.bits;
        }
    }
}

