/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.p2p.builder;

import java.util.Collection;
import java.util.concurrent.atomic.AtomicReferenceArray;
import net.tomp2p.connection.DefaultConnectionConfiguration;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.futures.FutureRouting;
import net.tomp2p.p2p.PostRoutingFilter;
import net.tomp2p.p2p.RoutingMechanism;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.Number640;
import net.tomp2p.peers.PeerMapFilter;
import net.tomp2p.rpc.NeighborRPC;
import net.tomp2p.rpc.SimpleBloomFilter;

public class RoutingBuilder
extends DefaultConnectionConfiguration {
    private Number160 locationKey;
    private Number160 domainKey;
    private Number160 contentKey;
    private SimpleBloomFilter<Number160> keyBloomFilter;
    private SimpleBloomFilter<Number160> contentBloomFilter;
    private Number640 from;
    private Number640 to;
    private Collection<PeerMapFilter> peerMapFilters;
    private Collection<PostRoutingFilter> postRoutingFilters;
    private int maxDirectHits;
    private int maxNoNewInfo;
    private int maxFailures;
    private int maxSuccess;
    private int parallel;
    private boolean isBootstrap;
    private boolean isForceRoutingOnlyToSelf;
    private boolean isRoutingToOthers;

    public Number160 locationKey() {
        return this.locationKey;
    }

    public Number160 domainKey() {
        return this.domainKey;
    }

    public int maxDirectHits() {
        return this.maxDirectHits;
    }

    public void maxDirectHits(int maxDirectHits) {
        this.maxDirectHits = maxDirectHits;
    }

    public int maxNoNewInfo() {
        return this.maxNoNewInfo;
    }

    public void setMaxNoNewInfo(int maxNoNewInfo) {
        this.maxNoNewInfo = maxNoNewInfo;
    }

    public int maxFailures() {
        return this.maxFailures;
    }

    public void maxFailures(int maxFailures) {
        this.maxFailures = maxFailures;
    }

    public int maxSuccess() {
        return this.maxSuccess;
    }

    public void maxSuccess(int maxSuccess) {
        this.maxSuccess = maxSuccess;
    }

    public int parallel() {
        return this.parallel;
    }

    public void parallel(int parallel) {
        this.parallel = parallel;
    }

    public boolean isBootstrap() {
        return this.isBootstrap;
    }

    public void bootstrap(boolean isBootstrap) {
        this.isBootstrap = isBootstrap;
    }

    public boolean isForceRoutingOnlyToSelf() {
        return this.isForceRoutingOnlyToSelf;
    }

    public void forceRoutingOnlyToSelf(boolean isForceRoutingOnlyToSelf) {
        this.isForceRoutingOnlyToSelf = isForceRoutingOnlyToSelf;
    }

    public void locationKey(Number160 locationKey) {
        this.locationKey = locationKey;
    }

    public void domainKey(Number160 domainKey) {
        this.domainKey = domainKey;
    }

    public RoutingBuilder peerMapFilters(Collection<PeerMapFilter> peerMapFilters) {
        this.peerMapFilters = peerMapFilters;
        return this;
    }

    public Collection<PeerMapFilter> peerMapFilters() {
        return this.peerMapFilters;
    }

    public RoutingBuilder postRoutingFilters(Collection<PostRoutingFilter> postRoutingFilters) {
        this.postRoutingFilters = postRoutingFilters;
        return this;
    }

    public Collection<PostRoutingFilter> postRoutingFilters() {
        return this.postRoutingFilters;
    }

    public NeighborRPC.SearchValues searchValues() {
        if (this.contentKey() != null) {
            return new NeighborRPC.SearchValues(this.locationKey, this.domainKey, this.contentKey());
        }
        if (this.from != null && this.to != null) {
            return new NeighborRPC.SearchValues(this.locationKey, this.domainKey, this.from, this.to);
        }
        if (this.contentBloomFilter() == null && this.keyBloomFilter() != null) {
            return new NeighborRPC.SearchValues(this.locationKey, this.domainKey, this.keyBloomFilter());
        }
        if (this.contentBloomFilter() != null && this.keyBloomFilter() != null) {
            return new NeighborRPC.SearchValues(this.locationKey, this.domainKey, this.keyBloomFilter(), this.contentBloomFilter());
        }
        return new NeighborRPC.SearchValues(this.locationKey, this.domainKey);
    }

    public RoutingBuilder routingOnlyToSelf(boolean isRoutingOnlyToSelf) {
        this.isRoutingToOthers = !isRoutingOnlyToSelf;
        return this;
    }

    public boolean isRoutingToOthers() {
        return this.isRoutingToOthers;
    }

    public Number160 contentKey() {
        return this.contentKey;
    }

    public void contentKey(Number160 contentKey) {
        this.contentKey = contentKey;
    }

    public SimpleBloomFilter<Number160> contentBloomFilter() {
        return this.contentBloomFilter;
    }

    public void contentBloomFilter(SimpleBloomFilter<Number160> contentBloomFilter) {
        this.contentBloomFilter = contentBloomFilter;
    }

    public SimpleBloomFilter<Number160> keyBloomFilter() {
        return this.keyBloomFilter;
    }

    public void keyBloomFilter(SimpleBloomFilter<Number160> keyBloomFilter) {
        this.keyBloomFilter = keyBloomFilter;
    }

    public RoutingMechanism createRoutingMechanism(FutureRouting futureRouting) {
        FutureResponse[] futureResponses = new FutureResponse[this.parallel()];
        RoutingMechanism routingMechanism = new RoutingMechanism(new AtomicReferenceArray<FutureResponse>(futureResponses), futureRouting, this.peerMapFilters);
        routingMechanism.maxDirectHits(this.maxDirectHits());
        routingMechanism.maxFailures(this.maxFailures());
        routingMechanism.maxNoNewInfo(this.maxNoNewInfo());
        routingMechanism.maxSucess(this.maxSuccess());
        return routingMechanism;
    }

    public void range(Number640 from, Number640 to) {
        this.from = from;
        this.to = to;
    }

    public Number640 from() {
        return this.from;
    }

    public Number640 to() {
        return this.to;
    }
}

