/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.p2p.builder;

import java.util.NavigableMap;
import net.tomp2p.connection.DefaultConnectionConfiguration;
import net.tomp2p.message.DataMap;
import net.tomp2p.message.Message;
import net.tomp2p.p2p.Peer;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.Number640;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.storage.Data;

public class BroadcastBuilder
extends DefaultConnectionConfiguration {
    private final Peer peer;
    private final Number160 messageKey;
    private NavigableMap<Number640, Data> dataMap;
    private Boolean isUDP;
    private int hopCounter;

    public BroadcastBuilder(Peer peer, Number160 messageKey) {
        this.peer = peer;
        this.messageKey = messageKey;
    }

    public void start() {
        Message message = new Message();
        if (this.isUDP == null) {
            if (this.dataMap == null) {
                this.udp(true);
            } else {
                this.udp(false);
                message.setDataMap(new DataMap(this.dataMap));
            }
        }
        message.key(this.messageKey);
        message.intValue(0);
        message.udp(this.isUDP());
        this.peer.broadcastRPC().broadcastHandler().receive(message);
    }

    public Number160 messageKey() {
        return this.messageKey;
    }

    public NavigableMap<Number640, Data> dataMap() {
        return this.dataMap;
    }

    public BroadcastBuilder dataMap(NavigableMap<Number640, Data> dataMap) {
        this.dataMap = dataMap;
        return this;
    }

    public boolean isUDP() {
        if (this.isUDP == null) {
            return false;
        }
        return this.isUDP;
    }

    public BroadcastBuilder udp(boolean isUDP) {
        this.isUDP = isUDP;
        return this;
    }

    public int hopCounter() {
        return this.hopCounter;
    }

    public BroadcastBuilder hopCounter(int hopCounter) {
        this.hopCounter = hopCounter;
        return this;
    }

    public PeerAddress remotePeer() {
        return this.peer.peerAddress();
    }
}

