/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.p2p;

import io.netty.channel.ChannelHandler;
import io.netty.util.concurrent.EventExecutorGroup;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.KeyPair;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import net.tomp2p.connection.Bindings;
import net.tomp2p.connection.ChannelClientConfiguration;
import net.tomp2p.connection.ChannelServerConfiguration;
import net.tomp2p.connection.ConnectionBean;
import net.tomp2p.connection.DSASignatureFactory;
import net.tomp2p.connection.DefaultSendBehavior;
import net.tomp2p.connection.PeerBean;
import net.tomp2p.connection.PeerCreator;
import net.tomp2p.connection.PingBuilderFactory;
import net.tomp2p.connection.PipelineFilter;
import net.tomp2p.connection.Ports;
import net.tomp2p.connection.SendBehavior;
import net.tomp2p.p2p.BroadcastHandler;
import net.tomp2p.p2p.DefaultBroadcastHandler;
import net.tomp2p.p2p.DistributedRouting;
import net.tomp2p.p2p.MaintenanceTask;
import net.tomp2p.p2p.Peer;
import net.tomp2p.p2p.PeerInit;
import net.tomp2p.p2p.builder.PingBuilder;
import net.tomp2p.peers.LocalMap;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerMap;
import net.tomp2p.peers.PeerMapConfiguration;
import net.tomp2p.rpc.AnnounceRPC;
import net.tomp2p.rpc.BloomfilterFactory;
import net.tomp2p.rpc.BroadcastRPC;
import net.tomp2p.rpc.DefaultBloomfilterFactory;
import net.tomp2p.rpc.DirectDataRPC;
import net.tomp2p.rpc.NeighborRPC;
import net.tomp2p.rpc.PingRPC;
import net.tomp2p.rpc.QuitRPC;
import net.tomp2p.utils.Pair;
import net.tomp2p.utils.Utils;

public class PeerBuilder {
    public static final PublicKey EMPTY_PUBLIC_KEY;
    private static final KeyPair EMPTY_KEY_PAIR;
    private static final int MAX_PERMITS_PERMANENT_TCP = 250;
    private static final int MAX_PERMITS_UDP = 250;
    private static final int MAX_PERMITS_TCP = 250;
    private final Number160 peerId;
    private KeyPair keyPair = null;
    private int p2pID = -1;
    private int tcpPort = -1;
    private int udpPort = -1;
    private int tcpPortForwarding = -1;
    private int udpPortForwarding = -1;
    private Bindings bindings = null;
    private PeerMap peerMap = null;
    private Peer masterPeer = null;
    private ChannelServerConfiguration channelServerConfiguration = null;
    private ChannelClientConfiguration channelClientConfiguration = null;
    private Boolean behindFirewall = null;
    private BroadcastHandler broadcastHandler;
    private BloomfilterFactory bloomfilterFactory;
    private ScheduledExecutorService scheduledExecutorService = null;
    private MaintenanceTask maintenanceTask = null;
    private Random random = null;
    private List<PeerInit> toInitialize = new ArrayList<PeerInit>(1);
    private SendBehavior sendBehavior;
    private boolean enableHandShakeRPC = true;
    private boolean enableNeighborRPC = true;
    private boolean enableDirectDataRPC = true;
    private boolean enableBroadcast = true;
    private boolean enableRouting = true;
    private boolean enableMaintenance = true;
    private boolean enableQuitRPC = true;
    private boolean enableAnnounceRPC = true;

    public PeerBuilder(Number160 peerId) {
        this.peerId = peerId;
    }

    public PeerBuilder(KeyPair keyPair) {
        this.keyPair = keyPair;
        this.peerId = Utils.makeSHAHash(keyPair.getPublic().getEncoded());
    }

    public Peer start() throws IOException {
        boolean isBehindFirewallSet = false;
        if (this.behindFirewall == null) {
            this.behindFirewall = false;
        } else {
            isBehindFirewallSet = true;
        }
        boolean isTcpPortSet = false;
        if (this.tcpPort == -1) {
            this.tcpPort = 7700;
        } else {
            isTcpPortSet = true;
        }
        boolean isUdpPortSet = false;
        if (this.udpPort == -1) {
            this.udpPort = 7700;
        } else {
            isUdpPortSet = true;
        }
        if (this.channelServerConfiguration == null) {
            this.channelServerConfiguration = PeerBuilder.createDefaultChannelServerConfiguration();
        }
        if (isBehindFirewallSet) {
            this.channelServerConfiguration.behindFirewall(this.behindFirewall);
        }
        if (isTcpPortSet || isUdpPortSet) {
            this.channelServerConfiguration.ports(new Ports(this.tcpPort, this.udpPort));
        }
        this.channelServerConfiguration.portsForwarding(new Ports(this.tcpPortForwarding, this.udpPortForwarding));
        if (this.channelClientConfiguration == null) {
            this.channelClientConfiguration = PeerBuilder.createDefaultChannelClientConfiguration();
        }
        if (this.keyPair == null) {
            this.keyPair = EMPTY_KEY_PAIR;
        }
        if (this.p2pID == -1) {
            this.p2pID = 1;
        }
        if (this.bindings == null) {
            this.bindings = new Bindings();
        } else {
            this.channelServerConfiguration.bindings(this.bindings);
            this.channelClientConfiguration.bindings(this.bindings);
        }
        if (this.peerMap == null) {
            this.peerMap = new PeerMap(new PeerMapConfiguration(this.peerId));
        }
        if (this.masterPeer == null && this.scheduledExecutorService == null) {
            this.scheduledExecutorService = Executors.newScheduledThreadPool(1);
        }
        if (this.sendBehavior == null) {
            this.sendBehavior = new DefaultSendBehavior();
        }
        PeerCreator peerCreator = this.masterPeer != null ? new PeerCreator(this.masterPeer.peerCreator(), this.peerId, this.keyPair) : new PeerCreator(this.p2pID, this.peerId, this.keyPair, this.channelServerConfiguration, this.channelClientConfiguration, this.scheduledExecutorService, this.sendBehavior);
        final Peer peer = new Peer(this.p2pID, this.peerId, peerCreator);
        PeerBean peerBean = peerCreator.peerBean();
        LocalMap localMap = new LocalMap();
        peerBean.localMap(localMap);
        peerBean.addPeerStatusListener(localMap);
        peerBean.addPeerStatusListener(this.peerMap);
        ConnectionBean connectionBean = peerCreator.connectionBean();
        peerBean.peerMap(this.peerMap);
        peerBean.keyPair(this.keyPair);
        if (this.bloomfilterFactory == null) {
            peerBean.bloomfilterFactory(new DefaultBloomfilterFactory());
        }
        if (this.broadcastHandler == null) {
            this.broadcastHandler = new DefaultBroadcastHandler(peer, new Random());
        }
        if (this.isEnableHandShakeRPC()) {
            PingRPC pingRPC = new PingRPC(peerBean, connectionBean);
            peer.pingRPC(pingRPC);
        }
        if (this.isEnableQuitRPC()) {
            QuitRPC quitRPC = new QuitRPC(peerBean, connectionBean);
            quitRPC.addPeerStatusListener(this.peerMap);
            peer.quitRPC(quitRPC);
        }
        if (this.isEnableNeighborRPC()) {
            NeighborRPC neighborRPC = new NeighborRPC(peerBean, connectionBean);
            peer.neighborRPC(neighborRPC);
        }
        if (this.isEnableDirectDataRPC()) {
            DirectDataRPC directDataRPC = new DirectDataRPC(peerBean, connectionBean);
            peer.directDataRPC(directDataRPC);
        }
        if (this.isEnableBroadcast()) {
            BroadcastRPC broadcastRPC = new BroadcastRPC(peerBean, connectionBean, this.broadcastHandler);
            peer.broadcastRPC(broadcastRPC);
        }
        if (this.isEnableAnnounceRPC()) {
            AnnounceRPC announceRPC = new AnnounceRPC(peerBean, connectionBean);
            peer.announceRPC(announceRPC);
        }
        if (this.isEnableRouting() && this.isEnableNeighborRPC()) {
            DistributedRouting routing = new DistributedRouting(peerBean, peer.neighborRPC());
            peer.distributedRouting(routing);
        }
        if (this.maintenanceTask == null && this.isEnableMaintenance()) {
            this.maintenanceTask = new MaintenanceTask();
        }
        if (this.maintenanceTask != null) {
            this.maintenanceTask.init(peer, connectionBean.timer());
            this.maintenanceTask.addMaintainable(this.peerMap);
            this.maintenanceTask.addMaintainable(localMap);
        }
        peerBean.maintenanceTask(this.maintenanceTask);
        connectionBean.sender().pingBuilderFactory(new PingBuilderFactory(){

            @Override
            public PingBuilder create() {
                return peer.ping();
            }
        });
        for (PeerInit peerInit : this.toInitialize) {
            peerInit.init(peer);
        }
        return peer;
    }

    public static ChannelServerConfiguration createDefaultChannelServerConfiguration() {
        ChannelServerConfiguration channelServerConfiguration = new ChannelServerConfiguration();
        channelServerConfiguration.bindings(new Bindings());
        channelServerConfiguration.ports(new Ports(7700, 7700));
        channelServerConfiguration.portsForwarding(new Ports(7700, 7700));
        channelServerConfiguration.behindFirewall(false);
        channelServerConfiguration.pipelineFilter(new DefaultPipelineFilter());
        channelServerConfiguration.signatureFactory(new DSASignatureFactory());
        channelServerConfiguration.byteBufPool(false);
        return channelServerConfiguration;
    }

    public static ChannelClientConfiguration createDefaultChannelClientConfiguration() {
        ChannelClientConfiguration channelClientConfiguration = new ChannelClientConfiguration();
        channelClientConfiguration.bindings(new Bindings());
        channelClientConfiguration.maxPermitsPermanentTCP(250);
        channelClientConfiguration.maxPermitsTCP(250);
        channelClientConfiguration.maxPermitsUDP(250);
        channelClientConfiguration.pipelineFilter(new DefaultPipelineFilter());
        channelClientConfiguration.signatureFactory(new DSASignatureFactory());
        channelClientConfiguration.senderTCP(new InetSocketAddress(0).getAddress());
        channelClientConfiguration.senderUDP(new InetSocketAddress(0).getAddress());
        channelClientConfiguration.byteBufPool(false);
        return channelClientConfiguration;
    }

    public Number160 peerId() {
        return this.peerId;
    }

    public KeyPair keyPair() {
        return this.keyPair;
    }

    public PeerBuilder keyPair(KeyPair keyPair) {
        this.keyPair = keyPair;
        return this;
    }

    public int p2pId() {
        return this.p2pID;
    }

    public PeerBuilder p2pId(int p2pID) {
        this.p2pID = p2pID;
        return this;
    }

    public int tcpPortForwarding() {
        return this.tcpPortForwarding;
    }

    public PeerBuilder tcpPortForwarding(int tcpPortForwarding) {
        this.tcpPortForwarding = tcpPortForwarding;
        return this;
    }

    public int tcpPort() {
        return this.tcpPort;
    }

    public PeerBuilder tcpPort(int tcpPort) {
        this.tcpPort = tcpPort;
        return this;
    }

    public int udpPort() {
        return this.udpPort;
    }

    public PeerBuilder udpPort(int udpPort) {
        this.udpPort = udpPort;
        return this;
    }

    public int udpPortForwarding() {
        return this.udpPortForwarding;
    }

    public PeerBuilder udpPortForwarding(int udpPortForwarding) {
        this.udpPortForwarding = udpPortForwarding;
        return this;
    }

    public PeerBuilder ports(int port) {
        this.udpPort = port;
        this.tcpPort = port;
        return this;
    }

    public PeerBuilder portsExternal(int port) {
        this.udpPortForwarding = port;
        this.tcpPortForwarding = port;
        return this;
    }

    public PeerBuilder bindings(Bindings bindings) {
        this.bindings = bindings;
        return this;
    }

    public Bindings bindings() {
        return this.bindings;
    }

    public PeerMap peerMap() {
        return this.peerMap;
    }

    public PeerBuilder peerMap(PeerMap peerMap) {
        this.peerMap = peerMap;
        return this;
    }

    public Peer masterPeer() {
        return this.masterPeer;
    }

    public PeerBuilder masterPeer(Peer masterPeer) {
        this.masterPeer = masterPeer;
        return this;
    }

    public ChannelServerConfiguration channelServerConfiguration() {
        return this.channelServerConfiguration;
    }

    public PeerBuilder channelServerConfiguration(ChannelServerConfiguration channelServerConfiguration) {
        this.channelServerConfiguration = channelServerConfiguration;
        return this;
    }

    public ChannelClientConfiguration channelClientConfiguration() {
        return this.channelClientConfiguration;
    }

    public PeerBuilder channelClientConfiguration(ChannelClientConfiguration channelClientConfiguration) {
        this.channelClientConfiguration = channelClientConfiguration;
        return this;
    }

    public BroadcastHandler broadcastHandler() {
        return this.broadcastHandler;
    }

    public PeerBuilder broadcastHandler(BroadcastHandler broadcastHandler) {
        this.broadcastHandler = broadcastHandler;
        return this;
    }

    public BloomfilterFactory bloomfilterFactory() {
        return this.bloomfilterFactory;
    }

    public PeerBuilder bloomfilterFactory(BloomfilterFactory bloomfilterFactory) {
        this.bloomfilterFactory = bloomfilterFactory;
        return this;
    }

    public MaintenanceTask maintenanceTask() {
        return this.maintenanceTask;
    }

    public PeerBuilder maintenanceTask(MaintenanceTask maintenanceTask) {
        this.maintenanceTask = maintenanceTask;
        return this;
    }

    public Random random() {
        return this.random;
    }

    public PeerBuilder random(Random random) {
        this.random = random;
        return this;
    }

    public PeerBuilder init(PeerInit init) {
        this.toInitialize.add(init);
        return this;
    }

    public PeerBuilder init(PeerInit ... inits) {
        for (PeerInit init : inits) {
            this.toInitialize.add(init);
        }
        return this;
    }

    public ScheduledExecutorService timer() {
        return this.scheduledExecutorService;
    }

    public PeerBuilder timer(ScheduledExecutorService scheduledExecutorService) {
        this.scheduledExecutorService = scheduledExecutorService;
        return this;
    }

    public boolean isEnableHandShakeRPC() {
        return this.enableHandShakeRPC;
    }

    public PeerBuilder enableHandShakeRPC(boolean enableHandShakeRPC) {
        this.enableHandShakeRPC = enableHandShakeRPC;
        return this;
    }

    public boolean isEnableNeighborRPC() {
        return this.enableNeighborRPC;
    }

    public PeerBuilder enableNeighborRPC(boolean enableNeighborRPC) {
        this.enableNeighborRPC = enableNeighborRPC;
        return this;
    }

    public boolean isEnableDirectDataRPC() {
        return this.enableDirectDataRPC;
    }

    public PeerBuilder enableDirectDataRPC(boolean enableDirectDataRPC) {
        this.enableDirectDataRPC = enableDirectDataRPC;
        return this;
    }

    public boolean isEnableRouting() {
        return this.enableRouting;
    }

    public PeerBuilder enableRouting(boolean enableRouting) {
        this.enableRouting = enableRouting;
        return this;
    }

    public boolean isEnableMaintenance() {
        return this.enableMaintenance;
    }

    public PeerBuilder enableMaintenance(boolean enableMaintenance) {
        this.enableMaintenance = enableMaintenance;
        return this;
    }

    public boolean isEnableQuitRPC() {
        return this.enableQuitRPC;
    }

    public PeerBuilder enableQuitRPC(boolean enableQuitRPC) {
        this.enableQuitRPC = enableQuitRPC;
        return this;
    }

    public boolean isEnableAnnounceRPC() {
        return this.enableAnnounceRPC;
    }

    public PeerBuilder enableAnnounceRPC(boolean enableAnnounceRPC) {
        this.enableAnnounceRPC = enableAnnounceRPC;
        return this;
    }

    public boolean isEnableBroadcast() {
        return this.enableBroadcast;
    }

    public PeerBuilder enableBroadcast(boolean enableBroadcast) {
        this.enableBroadcast = enableBroadcast;
        return this;
    }

    public boolean isBehindFirewall() {
        return this.behindFirewall == null ? false : this.behindFirewall;
    }

    public PeerBuilder behindFirewall(boolean behindFirewall) {
        this.behindFirewall = behindFirewall;
        return this;
    }

    public PeerBuilder behindFirewall() {
        this.behindFirewall = true;
        return this;
    }

    public PeerBuilder sendBehavior(SendBehavior sendBehavior) {
        this.sendBehavior = sendBehavior;
        return this;
    }

    public SendBehavior sendBehavior() {
        return this.sendBehavior;
    }

    static {
        System.setProperty("java.net.preferIPv4Stack", "true");
        EMPTY_PUBLIC_KEY = new PublicKey(){
            private static final long serialVersionUID = 4041565007522454573L;

            @Override
            public String getFormat() {
                return null;
            }

            @Override
            public byte[] getEncoded() {
                return null;
            }

            @Override
            public String getAlgorithm() {
                return null;
            }
        };
        EMPTY_KEY_PAIR = new KeyPair(EMPTY_PUBLIC_KEY, null);
    }

    public static class EventExecutorGroupFilter
    implements PipelineFilter {
        private final EventExecutorGroup eventExecutorGroup;

        public EventExecutorGroupFilter(EventExecutorGroup eventExecutorGroup) {
            this.eventExecutorGroup = eventExecutorGroup;
        }

        @Override
        public Map<String, Pair<EventExecutorGroup, ChannelHandler>> filter(Map<String, Pair<EventExecutorGroup, ChannelHandler>> channelHandlers, boolean tcp, boolean client) {
            this.setExecutor("handler", channelHandlers);
            this.setExecutor("dispatcher", channelHandlers);
            return channelHandlers;
        }

        private void setExecutor(String handlerName, Map<String, Pair<EventExecutorGroup, ChannelHandler>> channelHandlers) {
            Pair<EventExecutorGroup, ChannelHandler> pair = channelHandlers.get(handlerName);
            if (pair != null) {
                channelHandlers.put(handlerName, pair.element0(this.eventExecutorGroup));
            }
        }
    }

    public static class DefaultPipelineFilter
    implements PipelineFilter {
        @Override
        public Map<String, Pair<EventExecutorGroup, ChannelHandler>> filter(Map<String, Pair<EventExecutorGroup, ChannelHandler>> channelHandlers, boolean tcp, boolean client) {
            return channelHandlers;
        }
    }
}

