/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.peers;

public class RTT {
    private long startMeasurementTimestamp = -1L;
    private long rtt = -1L;
    private boolean isUDP = true;
    private boolean isEstimated = false;
    private static final double TCP_SCALE_DOWN_FACTOR = 3.5;

    public RTT() {
    }

    public RTT(long rtt, boolean isUDP) {
        this.rtt = rtt;
        this.startMeasurementTimestamp = System.currentTimeMillis();
        this.isUDP = isUDP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean beginTimeMeasurement(boolean isUDP) {
        if (this.getRtt() == -1L) {
            RTT rTT = this;
            synchronized (rTT) {
                this.startMeasurementTimestamp = System.currentTimeMillis();
                this.isUDP = isUDP;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stopTimeMeasurement() {
        RTT rTT = this;
        synchronized (rTT) {
            if (this.getRtt() == -1L && this.getStartMeasurementTimestamp() > 0L) {
                this.rtt = System.currentTimeMillis() - this.getStartMeasurementTimestamp();
                return true;
            }
        }
        return false;
    }

    public long getStartMeasurementTimestamp() {
        return this.startMeasurementTimestamp;
    }

    public long getRtt() {
        if (this.isUDP) {
            return this.rtt;
        }
        return (int)((double)this.rtt / 3.5);
    }

    public boolean isUDP() {
        return this.isUDP;
    }

    public boolean isEstimated() {
        return this.isEstimated;
    }

    public RTT setEstimated() {
        this.isEstimated = true;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.isUDP) {
            sb.append("(UDP ");
        } else {
            sb.append("TCP ");
        }
        sb.append(this.getRtt());
        sb.append(")");
        return sb.toString();
    }
}

