/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.message;

import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.Number640;
import net.tomp2p.storage.Data;
import net.tomp2p.utils.Utils;

public class DataMap {
    private final NavigableMap<Number640, Data> dataMap;
    private final NavigableMap<Number160, Data> dataMapConvert;
    private final Number160 locationKey;
    private final Number160 domainKey;
    private final Number160 versionKey;
    private final boolean convertMeta;

    public DataMap(NavigableMap<Number640, Data> dataMap) {
        this(dataMap, false);
    }

    public DataMap(NavigableMap<Number640, Data> dataMap, boolean convertMeta) {
        this.dataMap = dataMap;
        this.dataMapConvert = null;
        this.locationKey = null;
        this.domainKey = null;
        this.versionKey = null;
        this.convertMeta = convertMeta;
    }

    public DataMap(Number160 locationKey, Number160 domainKey, Number160 versionKey, NavigableMap<Number160, Data> dataMapConvert) {
        this(locationKey, domainKey, versionKey, dataMapConvert, false);
    }

    public DataMap(Number160 locationKey, Number160 domainKey, Number160 versionKey, NavigableMap<Number160, Data> dataMapConvert, boolean convertMeta) {
        this.dataMap = null;
        this.dataMapConvert = dataMapConvert;
        this.locationKey = locationKey;
        this.domainKey = domainKey;
        this.versionKey = versionKey;
        this.convertMeta = convertMeta;
    }

    public boolean isConvertMeta() {
        return this.convertMeta;
    }

    public NavigableMap<Number640, Data> dataMap() {
        return DataMap.convert(this);
    }

    public Map<Number160, Data> dataMapConvert() {
        return this.dataMapConvert;
    }

    public Number160 locationKey() {
        return this.locationKey;
    }

    public Number160 domainKey() {
        return this.domainKey;
    }

    public Number160 versionKey() {
        return this.versionKey;
    }

    public int size() {
        if (this.dataMap != null) {
            return this.dataMap.size();
        }
        if (this.dataMapConvert != null) {
            return this.dataMapConvert.size();
        }
        return 0;
    }

    public boolean isConvert() {
        return this.dataMapConvert != null;
    }

    public NavigableMap<Number640, Number160> convertToHash() {
        TreeMap<Number640, Number160> retVal;
        block3: {
            block2: {
                retVal = new TreeMap<Number640, Number160>();
                if (this.dataMap == null) break block2;
                for (Map.Entry entry : this.dataMap.entrySet()) {
                    retVal.put((Number640)entry.getKey(), ((Data)entry.getValue()).hash());
                }
                break block3;
            }
            if (this.dataMapConvert == null) break block3;
            for (Map.Entry entry : this.dataMapConvert.entrySet()) {
                retVal.put(new Number640(this.locationKey, this.domainKey, (Number160)entry.getKey(), this.versionKey), ((Data)entry.getValue()).hash());
            }
        }
        return retVal;
    }

    private static NavigableMap<Number640, Data> convert(DataMap d) {
        NavigableMap<Number640, Data> dataMap3;
        if (d.dataMapConvert != null) {
            dataMap3 = new TreeMap<Number640, Data>();
            for (Map.Entry entry : d.dataMapConvert.entrySet()) {
                dataMap3.put(new Number640(d.locationKey, d.domainKey, (Number160)entry.getKey(), d.versionKey), (Data)entry.getValue());
            }
        } else {
            dataMap3 = d.dataMap;
        }
        return dataMap3;
    }

    public int hashCode() {
        int hashCode = 31;
        NavigableMap<Number640, Data> dataMap = DataMap.convert(this);
        for (Map.Entry entry : dataMap.entrySet()) {
            hashCode ^= ((Number640)entry.getKey()).hashCode();
            if (entry.getValue() == null) continue;
            hashCode ^= ((Data)entry.getValue()).hashCode();
        }
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DataMap)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        NavigableMap<Number640, Data> dataMapThis = DataMap.convert(this);
        NavigableMap<Number640, Data> dataMapOther = DataMap.convert((DataMap)obj);
        boolean test1 = Utils.isSameSets(dataMapThis.keySet(), dataMapOther.keySet());
        boolean test2 = Utils.isSameSets(dataMapThis.values(), dataMapOther.values());
        return test1 && test2;
    }
}

