/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.connection;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.Attribute;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.util.List;
import net.tomp2p.connection.IdleStateHandlerTomP2P;
import net.tomp2p.connection.PeerException;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.message.Decoder;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.peers.PeerStatusListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeoutFactory {
    private static final Logger LOG = LoggerFactory.getLogger(TimeoutFactory.class);
    private final FutureResponse futureResponse;
    private final int timeoutSeconds;
    private final List<PeerStatusListener> peerStatusListeners;
    private final String name;

    public TimeoutFactory(FutureResponse futureResponse, int timeoutSeconds, List<PeerStatusListener> peerStatusListeners, String name) {
        this.futureResponse = futureResponse;
        this.timeoutSeconds = timeoutSeconds;
        this.peerStatusListeners = peerStatusListeners;
        this.name = name;
    }

    public ChannelHandler idleStateHandlerTomP2P() {
        return new IdleStateHandlerTomP2P(this.timeoutSeconds);
    }

    public ChannelHandler timeHandler() {
        return new TimeHandler(this.futureResponse, this.peerStatusListeners, this.name);
    }

    public static void removeTimeout(ChannelHandlerContext ctx) {
        if (ctx.channel().pipeline().names().contains("timeout0")) {
            ctx.channel().pipeline().remove("timeout0");
        }
        if (ctx.channel().pipeline().names().contains("timeout1")) {
            ctx.channel().pipeline().remove("timeout1");
        }
    }

    private static class TimeHandler
    extends ChannelDuplexHandler {
        private final FutureResponse futureResponse;
        private final List<PeerStatusListener> peerStatusListeners;
        private final String name;

        public TimeHandler(FutureResponse futureResponse, List<PeerStatusListener> peerStatusListeners, String name) {
            this.futureResponse = futureResponse;
            this.peerStatusListeners = peerStatusListeners;
            this.name = name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void userEventTriggered(ChannelHandlerContext ctx, final Object evt) throws Exception {
            if (evt instanceof IdleStateHandlerTomP2P) {
                PeerAddress recipient;
                LOG.warn("channel timeout for channel {} {}", (Object)this.name, (Object)ctx.channel());
                if (this.futureResponse != null) {
                    LOG.warn("Request status is {}", (Object)this.futureResponse.request());
                    ctx.channel().close().addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(){

                        public void operationComplete(ChannelFuture future) throws Exception {
                            TimeHandler.this.futureResponse.failed("channel is idle " + evt);
                        }
                    });
                    recipient = this.futureResponse.request().recipient();
                } else {
                    ctx.close();
                    Attribute pa = ctx.attr(Decoder.PEER_ADDRESS_KEY);
                    recipient = (PeerAddress)pa.get();
                }
                if (this.peerStatusListeners == null) {
                    return;
                }
                List<PeerStatusListener> list = this.peerStatusListeners;
                synchronized (list) {
                    for (PeerStatusListener peerStatusListener : this.peerStatusListeners) {
                        if (recipient != null) {
                            peerStatusListener.peerFailed(recipient, new PeerException(PeerException.AbortCause.TIMEOUT, "timeout!"));
                            continue;
                        }
                        InetSocketAddress inetSocketAddress = (InetSocketAddress)ctx.channel().remoteAddress();
                        if (inetSocketAddress == null) {
                            Attribute pa = ctx.attr(Decoder.INET_ADDRESS_KEY);
                            inetSocketAddress = (InetSocketAddress)pa.get();
                        }
                        if (inetSocketAddress != null) {
                            peerStatusListener.peerFailed(new PeerAddress(Number160.ZERO, inetSocketAddress.getAddress()), new PeerException(PeerException.AbortCause.TIMEOUT, "timeout!"));
                            continue;
                        }
                        LOG.warn("Cannot determine the address!");
                    }
                }
            }
        }
    }
}

