/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.p2p;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NavigableSet;
import java.util.Random;
import java.util.TreeMap;
import java.util.TreeSet;
import net.tomp2p.connection.ChannelCreator;
import net.tomp2p.connection.PeerBean;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.BaseFutureListener;
import net.tomp2p.futures.FutureDone;
import net.tomp2p.futures.FutureForkJoin;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.futures.FutureRouting;
import net.tomp2p.message.Message;
import net.tomp2p.p2p.PostRoutingFilter;
import net.tomp2p.p2p.RoutingMechanism;
import net.tomp2p.p2p.UpdatableTreeSet;
import net.tomp2p.p2p.builder.RoutingBuilder;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.Number640;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.peers.PeerMap;
import net.tomp2p.peers.PeerStatistic;
import net.tomp2p.rpc.DigestInfo;
import net.tomp2p.rpc.NeighborRPC;
import net.tomp2p.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributedRouting {
    private static final Logger LOG = LoggerFactory.getLogger(DistributedRouting.class);
    private final NeighborRPC neighbors;
    private final PeerBean peerBean;
    private final Random rnd;

    public DistributedRouting(PeerBean peerBean, NeighborRPC neighbors) {
        this.neighbors = neighbors;
        this.peerBean = peerBean;
        this.rnd = new Random(peerBean.serverPeerAddress().peerId().hashCode());
    }

    public FutureDone<Pair<FutureRouting, FutureRouting>> bootstrap(final Collection<PeerAddress> peerAddresses, final RoutingBuilder routingBuilder, final ChannelCreator cc) {
        LOG.debug("broadcast to {}", peerAddresses);
        final FutureDone<Pair<FutureRouting, FutureRouting>> futureDone = new FutureDone<Pair<FutureRouting, FutureRouting>>();
        routingBuilder.bootstrap(true);
        final FutureRouting futureRouting0 = this.routing(this.peerMap().getPeerStatistics(peerAddresses), routingBuilder, Message.Type.REQUEST_1, cc);
        futureRouting0.addListener((BaseFutureListener<BaseFuture>)new BaseFutureAdapter<FutureRouting>(){

            @Override
            public void operationComplete(FutureRouting future) throws Exception {
                if (future.isSuccess()) {
                    routingBuilder.locationKey(null);
                    final FutureRouting futureRouting1 = DistributedRouting.this.routing(DistributedRouting.this.peerMap().getPeerStatistics(peerAddresses), routingBuilder, Message.Type.REQUEST_1, cc);
                    futureRouting1.addListener((BaseFutureListener<BaseFuture>)new BaseFutureAdapter<FutureRouting>(){

                        @Override
                        public void operationComplete(FutureRouting future) throws Exception {
                            Pair<FutureRouting, FutureRouting> pair = new Pair<FutureRouting, FutureRouting>(futureRouting0, futureRouting1);
                            futureDone.done(pair);
                        }
                    });
                } else {
                    futureDone.failed(future);
                }
            }
        });
        return futureDone;
    }

    public FutureRouting quit(RoutingBuilder routingBuilder, ChannelCreator cc) {
        NavigableSet<PeerStatistic> startPeers = this.peerBean.peerMap().closePeers(routingBuilder.locationKey(), routingBuilder.parallel() * 2);
        return this.routing(startPeers, routingBuilder, Message.Type.REQUEST_4, cc);
    }

    public FutureRouting route(RoutingBuilder routingBuilder, Message.Type type, ChannelCreator cc) {
        NavigableSet<PeerStatistic> startPeers = this.peerBean.peerMap().closePeers(routingBuilder.locationKey(), routingBuilder.parallel() * 2);
        return this.routing(startPeers, routingBuilder, type, cc);
    }

    private FutureRouting routing(Collection<PeerStatistic> peerAddresses, RoutingBuilder routingBuilder, Message.Type type, ChannelCreator cc) {
        Object digestInfo;
        Comparator<PeerAddress> addressComparator;
        Comparator<PeerStatistic> statisticComparator;
        boolean randomSearch;
        if (peerAddresses == null) {
            throw new IllegalArgumentException("you need to specify some nodes");
        }
        boolean bl = randomSearch = routingBuilder.locationKey() == null;
        if (randomSearch) {
            statisticComparator = this.peerMap().createStatisticComparator(this.peerMap().self());
            addressComparator = PeerMap.createXORAddressComparator(this.peerMap().self());
        } else {
            statisticComparator = this.peerMap().createStatisticComparator(routingBuilder.locationKey());
            addressComparator = PeerMap.createXORAddressComparator(routingBuilder.locationKey());
        }
        UpdatableTreeSet<PeerStatistic> queueToAsk = new UpdatableTreeSet<PeerStatistic>(statisticComparator);
        TreeSet<PeerAddress> alreadyAsked = new TreeSet<PeerAddress>(addressComparator);
        TreeMap<PeerAddress, DigestInfo> directHits = new TreeMap<PeerAddress, DigestInfo>(addressComparator);
        TreeSet<PeerAddress> potentialHits = new TreeSet<PeerAddress>(addressComparator);
        queueToAsk.addAll(peerAddresses);
        alreadyAsked.add(this.peerBean.serverPeerAddress());
        potentialHits.add(this.peerBean.serverPeerAddress());
        if (type == Message.Type.REQUEST_2 && routingBuilder.domainKey() != null && !randomSearch && this.peerBean.digestStorage() != null) {
            Number640 to;
            Number640 from;
            if (routingBuilder.from() != null && routingBuilder.to() != null) {
                from = routingBuilder.from();
                to = routingBuilder.to();
            } else if (routingBuilder.contentKey() == null) {
                from = new Number640(routingBuilder.locationKey(), routingBuilder.domainKey(), Number160.ZERO, Number160.ZERO);
                to = new Number640(routingBuilder.locationKey(), routingBuilder.domainKey(), Number160.MAX_VALUE, Number160.MAX_VALUE);
            } else {
                from = new Number640(routingBuilder.locationKey(), routingBuilder.domainKey(), routingBuilder.contentKey(), Number160.ZERO);
                to = new Number640(routingBuilder.locationKey(), routingBuilder.domainKey(), routingBuilder.contentKey(), Number160.MAX_VALUE);
            }
            DigestInfo digestBean = this.peerBean.digestStorage().digest(from, to, -1, true);
            if (digestBean.size() > 0) {
                directHits.put(this.peerBean.serverPeerAddress(), digestBean);
            }
        } else if (type == Message.Type.REQUEST_3 && !randomSearch && this.peerBean.digestTracker() != null && ((DigestInfo)(digestInfo = this.peerBean.digestTracker().digest(routingBuilder.locationKey(), routingBuilder.domainKey(), routingBuilder.contentKey()))).size() > 0) {
            directHits.put(this.peerBean.serverPeerAddress(), (DigestInfo)digestInfo);
        }
        if (routingBuilder.postRoutingFilters() != null) {
            for (PostRoutingFilter filter : routingBuilder.postRoutingFilters()) {
                Iterator potentialIter = potentialHits.iterator();
                while (potentialIter.hasNext()) {
                    if (!filter.rejectPotentialHit((PeerAddress)potentialIter.next())) continue;
                    potentialIter.remove();
                }
                Iterator directIter = directHits.keySet().iterator();
                while (directIter.hasNext()) {
                    if (!filter.rejectDirectHit((PeerAddress)directIter.next())) continue;
                    directIter.remove();
                }
            }
        }
        FutureRouting futureRouting = new FutureRouting();
        if (peerAddresses.size() == 0) {
            futureRouting.neighbors(directHits, potentialHits, alreadyAsked, routingBuilder.isBootstrap(), false);
        } else {
            boolean isRoutingOnlyToSelf = peerAddresses.size() == 1 && peerAddresses.iterator().next().peerAddress().equals(this.peerBean.serverPeerAddress());
            RoutingMechanism routingMechanism = routingBuilder.createRoutingMechanism(futureRouting);
            routingMechanism.queueToAsk(queueToAsk);
            routingMechanism.potentialHits(potentialHits);
            routingMechanism.directHits(directHits);
            routingMechanism.alreadyAsked(alreadyAsked);
            routingBuilder.routingOnlyToSelf(isRoutingOnlyToSelf);
            this.routingRec(routingBuilder, routingMechanism, type, cc);
        }
        return futureRouting;
    }

    private void routingRec(final RoutingBuilder routingBuilder, final RoutingMechanism routingMechanism, final Message.Type type, final ChannelCreator channelCreator) {
        boolean randomSearch = routingBuilder.locationKey() == null;
        int active = 0;
        for (int i = 0; i < routingMechanism.parallel(); ++i) {
            if (routingMechanism.futureResponse(i) == null && !routingMechanism.isStopCreatingNewFutures()) {
                PeerAddress next = randomSearch ? routingMechanism.pollRandomInQueueToAsk(this.rnd) : routingMechanism.pollFirstInQueueToAsk();
                if (next == null) continue;
                routingMechanism.addToAlreadyAsked(next);
                ++active;
                Number160 locationKey2 = randomSearch ? next.peerId().xor(Number160.MAX_VALUE) : routingBuilder.locationKey();
                routingBuilder.locationKey(locationKey2);
                if (LOG.isWarnEnabled()) {
                    if (channelCreator.availableUDPPermits() == 0 && !routingBuilder.isForceTCP()) {
                        LOG.warn("sanity check faild UDP: {}, {}", (Object)i, (Object)Thread.currentThread().getName());
                    } else if (channelCreator.availableTCPPermits() == 0 && routingBuilder.isForceTCP()) {
                        LOG.warn("sanity check faild TCP: {}, {}", (Object)i, (Object)Thread.currentThread().getName());
                    }
                }
                routingMechanism.futureResponse(i, this.neighbors.closeNeighbors(next, routingBuilder.searchValues(), type, channelCreator, routingBuilder));
                LOG.debug("get close neighbors: {} on {}", (Object)next, (Object)i);
                continue;
            }
            if (routingMechanism.futureResponse(i) == null) continue;
            LOG.debug("activity on {}", (Object)i);
            ++active;
        }
        if (active == 0) {
            LOG.debug("no activity, closing");
            routingMechanism.neighbors(routingBuilder);
            routingMechanism.cancel();
            return;
        }
        final boolean last = active == 1;
        FutureForkJoin<FutureResponse> fp = new FutureForkJoin<FutureResponse>(1, false, routingMechanism.futureResponses());
        fp.addListener((BaseFutureListener<BaseFuture>)new BaseFutureAdapter<FutureForkJoin<FutureResponse>>(){

            @Override
            public void operationComplete(FutureForkJoin<FutureResponse> future) throws Exception {
                boolean finished;
                if (future.isSuccess()) {
                    Message lastResponse = future.last().responseMessage();
                    PeerAddress remotePeer = lastResponse.sender();
                    routingMechanism.addPotentialHits(remotePeer);
                    Collection<PeerAddress> newNeighbors = lastResponse.neighborsSet(0).neighbors();
                    Collection<PeerStatistic> newNeighborStatistics = DistributedRouting.this.peerMap().getPeerStatistics(newNeighbors);
                    Integer resultSize = lastResponse.intAt(0);
                    Number160 keyDigest = lastResponse.key(0);
                    Number160 contentDigest = lastResponse.key(1);
                    DigestInfo digestBean = new DigestInfo(keyDigest, contentDigest, resultSize == null ? 0 : resultSize);
                    LOG.debug("Peer ({}) {} reported {} in message {}", new Object[]{digestBean.size() > 0 ? "direct" : "none", remotePeer, newNeighbors, lastResponse});
                    finished = routingMechanism.evaluateSuccess(remotePeer, digestBean, newNeighborStatistics, last, routingBuilder.locationKey());
                    LOG.debug("Routing finished {} / {}", (Object)finished, (Object)routingMechanism.isStopCreatingNewFutures());
                } else {
                    LOG.debug("routing error {}", (Object)future.failedReason());
                    finished = routingMechanism.evaluateFailed();
                    routingMechanism.stopCreatingNewFutures(finished);
                }
                if (finished) {
                    LOG.debug("finished routing, direct hits: {} potential: {}", routingMechanism.directHits(), routingMechanism.potentialHits());
                    routingMechanism.neighbors(routingBuilder);
                    routingMechanism.cancel();
                } else {
                    DistributedRouting.this.routingRec(routingBuilder, routingMechanism, type, channelCreator);
                }
            }
        });
    }

    public PeerMap peerMap() {
        return this.peerBean.peerMap();
    }
}

