/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.p2p;

import java.util.Comparator;
import net.tomp2p.p2p.PeerStatisticComparator;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerMap;
import net.tomp2p.peers.PeerStatistic;

public class RTTPeerStatisticComparator
implements PeerStatisticComparator {
    @Override
    public Comparator<PeerStatistic> getComparator(final Number160 location) {
        return new Comparator<PeerStatistic>(){

            @Override
            public int compare(PeerStatistic o1, PeerStatistic o2) {
                if (o1.peerAddress().equals(o2.peerAddress())) {
                    return 0;
                }
                int firstComp = PeerMap.classCloser(location, o1.peerAddress(), o2.peerAddress());
                if (firstComp == 0) {
                    if (o1.getMeanRTT() < 0L && o2.getMeanRTT() >= 0L) {
                        return 1;
                    }
                    if (o1.getMeanRTT() >= 0L && o2.getMeanRTT() < 0L) {
                        return -1;
                    }
                    if (o1.getMeanRTT() >= 0L && o2.getMeanRTT() >= 0L && o1.getMeanRTT() != o2.getMeanRTT()) {
                        Long rtt1 = o1.getMeanRTT();
                        Long rtt2 = o2.getMeanRTT();
                        return rtt1.compareTo(rtt2);
                    }
                    return PeerMap.isKadCloser(location, o1.peerAddress(), o2.peerAddress());
                }
                return firstComp;
            }
        };
    }
}

