/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.message;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.Arrays;
import net.tomp2p.message.SignatureCodec;

public class RSASignatureCodec
implements SignatureCodec {
    public static final int SIGNATURE_SIZE = 128;
    private final byte[] encodedData;

    public RSASignatureCodec(byte[] encodedData) throws IOException {
        if (encodedData.length != this.signatureSize()) {
            throw new IOException("RSA signature has size " + this.signatureSize() + " received: " + encodedData.length);
        }
        this.encodedData = encodedData;
    }

    public RSASignatureCodec(ByteBuf buf) {
        this.encodedData = new byte[this.signatureSize()];
        buf.readBytes(this.encodedData);
    }

    @Override
    public byte[] encode() {
        return this.encodedData;
    }

    @Override
    public SignatureCodec write(ByteBuf buf) {
        buf.writeBytes(this.encodedData);
        return this;
    }

    public int hashCode() {
        return Arrays.hashCode(this.encodedData);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RSASignatureCodec)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        RSASignatureCodec s = (RSASignatureCodec)obj;
        return Arrays.equals(s.encodedData, this.encodedData);
    }

    @Override
    public int signatureSize() {
        return 128;
    }
}

