/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.message;

import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.tomp2p.connection.SignatureFactory;
import net.tomp2p.message.Buffer;
import net.tomp2p.message.DataFilter;
import net.tomp2p.message.DataFilterTTL;
import net.tomp2p.message.DataMap;
import net.tomp2p.message.KeyCollection;
import net.tomp2p.message.KeyMap640Keys;
import net.tomp2p.message.KeyMapByte;
import net.tomp2p.message.Message;
import net.tomp2p.message.MessageContentIndex;
import net.tomp2p.message.MessageHeaderCodec;
import net.tomp2p.message.NeighborSet;
import net.tomp2p.message.SignatureCodec;
import net.tomp2p.message.TrackerData;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.Number640;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.peers.PeerSocketAddress;
import net.tomp2p.rpc.SimpleBloomFilter;
import net.tomp2p.storage.AlternativeCompositeByteBuf;
import net.tomp2p.storage.Data;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Encoder {
    private static final Logger LOG = LoggerFactory.getLogger(Encoder.class);
    private final DataFilter dataFilterTTL = new DataFilterTTL();
    private boolean header = false;
    private boolean resume = false;
    private Message message;
    private final SignatureFactory signatureFactory;

    public Encoder(SignatureFactory signatureFactory) {
        this.signatureFactory = signatureFactory;
    }

    public boolean write(AlternativeCompositeByteBuf buf, Message message, SignatureCodec signatureCodec) throws InvalidKeyException, SignatureException, IOException {
        this.message = message;
        LOG.debug("message for outbound {}", (Object)message);
        if (message.sender().isRelayed() && message.peerSocketAddresses().isEmpty()) {
            message.peerSocketAddresses(message.sender().peerSocketAddresses());
        }
        if (!this.header) {
            MessageHeaderCodec.encodeHeader(buf, message);
            this.header = true;
        } else {
            LOG.debug("send a follow-up message {}", (Object)message);
            this.resume = true;
        }
        boolean done = this.loop(buf);
        LOG.debug("message encoded {}", (Object)message);
        if (buf.isReadable() && done && message.isSign()) {
            if (signatureCodec == null) {
                signatureCodec = this.signatureFactory.sign(message.privateKey(), buf.nioBuffers());
            }
            signatureCodec.write(buf);
        }
        return done;
    }

    private boolean loop(AlternativeCompositeByteBuf buf) throws InvalidKeyException, SignatureException, IOException {
        MessageContentIndex next;
        while ((next = this.message.contentReferences().peek()) != null) {
            int start = buf.writerIndex();
            Message.Content content = next.content();
            switch (content) {
                case KEY: {
                    buf.writeBytes(this.message.key(next.index()).toByteArray());
                    this.message.contentReferences().poll();
                    break;
                }
                case INTEGER: {
                    buf.writeInt(this.message.intAt(next.index()));
                    this.message.contentReferences().poll();
                    break;
                }
                case LONG: {
                    buf.writeLong(this.message.longAt(next.index()));
                    this.message.contentReferences().poll();
                    break;
                }
                case SET_NEIGHBORS: {
                    NeighborSet neighborSet = this.message.neighborsSet(next.index());
                    buf.writeByte(neighborSet.size());
                    for (PeerAddress neighbor : neighborSet.neighbors()) {
                        buf.writeBytes(neighbor.toByteArray());
                    }
                    this.message.contentReferences().poll();
                    break;
                }
                case SET_PEER_SOCKET: {
                    List<PeerSocketAddress> list = this.message.peerSocketAddresses();
                    buf.writeByte(list.size());
                    for (PeerSocketAddress psa : list) {
                        buf.writeByte(psa.isIPv4() ? 0 : 1);
                        buf.writeBytes(psa.toByteArray());
                    }
                    this.message.contentReferences().poll();
                    break;
                }
                case BLOOM_FILTER: {
                    SimpleBloomFilter<Number160> simpleBloomFilter = this.message.bloomFilter(next.index());
                    simpleBloomFilter.toByteBuf(buf);
                    this.message.contentReferences().poll();
                    break;
                }
                case SET_KEY640: {
                    KeyCollection keys = this.message.keyCollection(next.index());
                    buf.writeInt(keys.size());
                    if (keys.isConvert()) {
                        for (Number160 number160 : keys.keysConvert()) {
                            buf.writeBytes(keys.locationKey().toByteArray());
                            buf.writeBytes(keys.domainKey().toByteArray());
                            buf.writeBytes(number160.toByteArray());
                            buf.writeBytes(keys.versionKey().toByteArray());
                        }
                    } else {
                        for (Number640 number640 : keys.keys()) {
                            buf.writeBytes(number640.locationKey().toByteArray());
                            buf.writeBytes(number640.domainKey().toByteArray());
                            buf.writeBytes(number640.contentKey().toByteArray());
                            buf.writeBytes(number640.versionKey().toByteArray());
                        }
                    }
                    this.message.contentReferences().poll();
                    break;
                }
                case MAP_KEY640_DATA: {
                    DataMap dataMap = this.message.dataMap(next.index());
                    buf.writeInt(dataMap.size());
                    if (dataMap.isConvert()) {
                        for (Map.Entry<Number160, Data> entry : dataMap.dataMapConvert().entrySet()) {
                            buf.writeBytes(dataMap.locationKey().toByteArray());
                            buf.writeBytes(dataMap.domainKey().toByteArray());
                            buf.writeBytes(entry.getKey().toByteArray());
                            buf.writeBytes(dataMap.versionKey().toByteArray());
                            this.encodeData(buf, entry.getValue(), dataMap.isConvertMeta(), !this.message.isRequest());
                        }
                    } else {
                        for (Map.Entry entry : dataMap.dataMap().entrySet()) {
                            buf.writeBytes(((Number640)entry.getKey()).locationKey().toByteArray());
                            buf.writeBytes(((Number640)entry.getKey()).domainKey().toByteArray());
                            buf.writeBytes(((Number640)entry.getKey()).contentKey().toByteArray());
                            buf.writeBytes(((Number640)entry.getKey()).versionKey().toByteArray());
                            this.encodeData(buf, (Data)entry.getValue(), dataMap.isConvertMeta(), !this.message.isRequest());
                        }
                    }
                    this.message.contentReferences().poll();
                    break;
                }
                case MAP_KEY640_KEYS: {
                    KeyMap640Keys keyMap640Keys = this.message.keyMap640Keys(next.index());
                    buf.writeInt(keyMap640Keys.size());
                    for (Map.Entry entry : keyMap640Keys.keysMap().entrySet()) {
                        buf.writeBytes(((Number640)entry.getKey()).locationKey().toByteArray());
                        buf.writeBytes(((Number640)entry.getKey()).domainKey().toByteArray());
                        buf.writeBytes(((Number640)entry.getKey()).contentKey().toByteArray());
                        buf.writeBytes(((Number640)entry.getKey()).versionKey().toByteArray());
                        buf.writeByte(((Collection)entry.getValue()).size());
                        for (Number160 basedOnKey : (Collection)entry.getValue()) {
                            buf.writeBytes(basedOnKey.toByteArray());
                        }
                    }
                    this.message.contentReferences().poll();
                    break;
                }
                case MAP_KEY640_BYTE: {
                    KeyMapByte keyMapByte = this.message.keyMapByte(next.index());
                    buf.writeInt(keyMapByte.size());
                    for (Map.Entry<Number640, Byte> entry : keyMapByte.keysMap().entrySet()) {
                        buf.writeBytes(entry.getKey().locationKey().toByteArray());
                        buf.writeBytes(entry.getKey().domainKey().toByteArray());
                        buf.writeBytes(entry.getKey().contentKey().toByteArray());
                        buf.writeBytes(entry.getKey().versionKey().toByteArray());
                        buf.writeByte(entry.getValue().byteValue());
                    }
                    this.message.contentReferences().poll();
                    break;
                }
                case BYTE_BUFFER: {
                    Buffer buffer = this.message.buffer(next.index());
                    if (!this.resume) {
                        buf.writeInt(buffer.length());
                    }
                    int readable = buffer.readable();
                    buf.writeBytes(buffer.buffer(), readable);
                    if (buffer.incRead(readable) == buffer.length()) {
                        this.message.contentReferences().poll();
                        break;
                    }
                    if (this.message.isStreaming()) {
                        LOG.debug("Partial message of lengt {} sent.", (Object)readable);
                        return false;
                    }
                    String description = "Larger buffer has been announced, but not in message streaming mode. This is wrong.";
                    LOG.error("Larger buffer has been announced, but not in message streaming mode. This is wrong.");
                    throw new RuntimeException("Larger buffer has been announced, but not in message streaming mode. This is wrong.");
                }
                case SET_TRACKER_DATA: {
                    TrackerData trackerData = this.message.trackerData(next.index());
                    buf.writeByte(trackerData.peerAddresses().size());
                    for (Map.Entry<PeerAddress, Data> entry : trackerData.peerAddresses().entrySet()) {
                        byte[] me = entry.getKey().toByteArray();
                        buf.writeBytes(me);
                        Data data = entry.getValue().duplicate();
                        this.encodeData(buf, data, false, !this.message.isRequest());
                    }
                    this.message.contentReferences().poll();
                    break;
                }
                case PUBLIC_KEY_SIGNATURE: {
                    this.message.setHintSign();
                }
                case PUBLIC_KEY: {
                    PublicKey publicKey = this.message.publicKey(next.index());
                    this.signatureFactory.encodePublicKey(publicKey, buf);
                    this.message.contentReferences().poll();
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown type: " + (Object)((Object)next.content()));
                }
            }
            LOG.debug("wrote in encoder for {} {}", (Object)content, (Object)(buf.writerIndex() - start));
        }
        return true;
    }

    private void encodeData(AlternativeCompositeByteBuf buf, Data data, boolean isConvertMeta, boolean isReply) throws InvalidKeyException, SignatureException, IOException {
        Data copyData = this.dataFilterTTL.filter(data, isConvertMeta, isReply);
        copyData.encodeHeader(buf, this.signatureFactory);
        copyData.encodeBuffer(buf);
        copyData.encodeDone(buf, this.signatureFactory, this.message.privateKey());
    }

    public Message message() {
        return this.message;
    }

    public void reset() {
        this.header = false;
        this.resume = false;
    }
}

