/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.storage;

import java.util.HashMap;
import java.util.concurrent.locks.ReentrantLock;

public class KeyLock<K> {
    private final ReentrantLock lockInternal = new ReentrantLock();
    private final HashMap<K, RefCounterLock> cache = new HashMap();

    public RefCounterLock lock(K key) {
        RefCounterLock cur;
        this.lockInternal.lock();
        try {
            if (!this.cache.containsKey(key)) {
                cur = new RefCounterLock(key, this);
                this.cache.put(key, cur);
            } else {
                cur = this.cache.get(key);
            }
            cur.counter++;
        }
        finally {
            this.lockInternal.unlock();
        }
        cur.sem.lock();
        return cur;
    }

    public void unlock(RefCounterLock lock) {
        RefCounterLock cur = null;
        this.lockInternal.lock();
        try {
            if (this.cache.containsKey(lock.key)) {
                cur = this.cache.get(lock.key);
                if (lock != cur) {
                    throw new IllegalArgumentException("lock does not matches the stored lock");
                }
                cur.counter--;
                cur.sem.unlock();
                if (cur.counter == 0) {
                    this.cache.remove(lock.key);
                }
            }
        }
        finally {
            this.lockInternal.unlock();
        }
    }

    public int cacheSize() {
        this.lockInternal.lock();
        try {
            int n = this.cache.size();
            return n;
        }
        finally {
            this.lockInternal.unlock();
        }
    }

    public class RefCounterLock {
        private final K key;
        public final ReentrantLock sem = new ReentrantLock();
        private final KeyLock<K> keyLock;
        private int counter = 0;

        public RefCounterLock(K key, KeyLock<K> keyLock) {
            this.key = key;
            this.keyLock = keyLock;
        }

        public void unlock() {
            this.keyLock.unlock(this);
        }
    }
}

