/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.rpc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableSet;
import net.tomp2p.connection.ChannelCreator;
import net.tomp2p.connection.ConnectionBean;
import net.tomp2p.connection.ConnectionConfiguration;
import net.tomp2p.connection.PeerBean;
import net.tomp2p.connection.PeerConnection;
import net.tomp2p.connection.PeerException;
import net.tomp2p.connection.RequestHandler;
import net.tomp2p.connection.Responder;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.BaseFutureListener;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.message.KeyCollection;
import net.tomp2p.message.Message;
import net.tomp2p.message.NeighborSet;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.Number320;
import net.tomp2p.peers.Number640;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.peers.PeerStatistic;
import net.tomp2p.peers.PeerStatusListener;
import net.tomp2p.rpc.DigestInfo;
import net.tomp2p.rpc.DispatchHandler;
import net.tomp2p.rpc.RPC;
import net.tomp2p.rpc.SimpleBloomFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NeighborRPC
extends DispatchHandler {
    private static final Logger LOG = LoggerFactory.getLogger(NeighborRPC.class);
    public static final int NEIGHBOR_SIZE = 30;
    public static final int NEIGHBOR_LIMIT = 1000;

    public NeighborRPC(PeerBean peerBean, ConnectionBean connectionBean) {
        this(peerBean, connectionBean, true);
    }

    public NeighborRPC(PeerBean peerBean, ConnectionBean connectionBean, boolean register) {
        super(peerBean, connectionBean);
        if (register) {
            this.register(RPC.Commands.NEIGHBOR.getNr());
        }
    }

    public FutureResponse closeNeighbors(PeerAddress remotePeer, SearchValues searchValues, Message.Type type, ChannelCreator channelCreator, ConnectionConfiguration configuration) {
        Message message = this.createMessage(remotePeer, RPC.Commands.NEIGHBOR.getNr(), type);
        if (!message.isRequest()) {
            throw new IllegalArgumentException("The type must be a request");
        }
        message.key(searchValues.locationKey());
        message.key(searchValues.domainKey() == null ? Number160.ZERO : searchValues.domainKey());
        if (searchValues.from() != null && searchValues.to() != null) {
            ArrayList<Number640> collection = new ArrayList<Number640>(2);
            collection.add(searchValues.from());
            collection.add(searchValues.to());
            KeyCollection keyCollection = new KeyCollection(collection);
            message.keyCollection(keyCollection);
        } else {
            if (searchValues.contentKey() != null) {
                message.key(searchValues.contentKey());
            }
            if (searchValues.keyBloomFilter() != null) {
                message.bloomFilter(searchValues.keyBloomFilter());
            }
            if (searchValues.contentBloomFilter() != null) {
                message.bloomFilter(searchValues.contentBloomFilter());
            }
        }
        return this.send(message, configuration, channelCreator);
    }

    private FutureResponse send(Message message, ConnectionConfiguration configuration, ChannelCreator channelCreator) {
        final FutureResponse futureResponse = new FutureResponse(message);
        futureResponse.addListener((BaseFutureListener<BaseFuture>)new BaseFutureAdapter<FutureResponse>(){

            @Override
            public void operationComplete(FutureResponse future) throws Exception {
                NeighborSet ns;
                Message response;
                if (future.isSuccess() && (response = future.responseMessage()) != null && (ns = response.neighborsSet(0)) != null) {
                    for (PeerAddress neighbor : ns.neighbors()) {
                        NeighborRPC.this.peerBean().notifyPeerFound(neighbor, response.sender(), null, futureResponse.getRoundTripTime().setEstimated());
                    }
                }
            }
        });
        RequestHandler<FutureResponse> request = new RequestHandler<FutureResponse>(futureResponse, this.peerBean(), this.connectionBean(), configuration);
        if (!configuration.isForceTCP()) {
            return request.sendUDP(channelCreator);
        }
        return request.sendTCP(channelCreator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleResponse(Message message, PeerConnection peerConnection, boolean sign, Responder responder) throws IOException {
        boolean isDigest;
        if (message.keyList().size() < 2) {
            throw new IllegalArgumentException("We need the location and domain key at least");
        }
        if (message.type() != Message.Type.REQUEST_1 && message.type() != Message.Type.REQUEST_2 && message.type() != Message.Type.REQUEST_3 && message.type() != Message.Type.REQUEST_4 && message.command() == RPC.Commands.NEIGHBOR.getNr()) {
            throw new IllegalArgumentException("Message content is wrong");
        }
        Number160 locationKey = message.key(0);
        Number160 domainKey = message.key(1);
        List<PeerAddress> neighbors = this.getNeighbors(locationKey, 30);
        if (neighbors == null) {
            Message response = this.createResponseMessage(message, Message.Type.NOT_FOUND);
            response.neighborsSet(new NeighborSet(-1, Collections.emptyList()));
            responder.response(response);
            return;
        }
        Message responseMessage = this.createResponseMessage(message, Message.Type.OK);
        LOG.debug("found the following neighbors {}", neighbors);
        NeighborSet neighborSet = new NeighborSet(1000, neighbors);
        responseMessage.neighborsSet(neighborSet);
        Number160 contentKey = message.key(2);
        SimpleBloomFilter<Number160> keyBloomFilter = message.bloomFilter(0);
        SimpleBloomFilter<Number160> contentBloomFilter = message.bloomFilter(1);
        KeyCollection keyCollection = message.keyCollection(0);
        boolean bl = isDigest = message.type() != Message.Type.REQUEST_1;
        if (isDigest) {
            if (message.type() == Message.Type.REQUEST_2) {
                DigestInfo digestInfo;
                if (this.peerBean().digestStorage() == null) {
                    digestInfo = new DigestInfo();
                } else if (contentKey != null && locationKey != null && domainKey != null) {
                    Number320 locationAndDomainKey = new Number320(locationKey, domainKey);
                    Number640 from = new Number640(locationAndDomainKey, contentKey, Number160.ZERO);
                    Number640 to = new Number640(locationAndDomainKey, contentKey, Number160.MAX_VALUE);
                    digestInfo = this.peerBean().digestStorage().digest(from, to, -1, true);
                } else if ((keyBloomFilter != null || contentBloomFilter != null) && locationKey != null && domainKey != null) {
                    Number320 locationAndDomainKey = new Number320(locationKey, domainKey);
                    digestInfo = this.peerBean().digestStorage().digest(locationAndDomainKey, keyBloomFilter, contentBloomFilter, -1, true, true);
                } else if (keyCollection != null && keyCollection.keys().size() == 2) {
                    Iterator<Number640> iterator = keyCollection.keys().iterator();
                    Number640 from = iterator.next();
                    Number640 to = iterator.next();
                    digestInfo = this.peerBean().digestStorage().digest(from, to, -1, true);
                } else if (locationKey != null && domainKey != null) {
                    Number320 locationAndDomainKey = new Number320(locationKey, domainKey);
                    Number640 from = new Number640(locationAndDomainKey, Number160.ZERO, Number160.ZERO);
                    Number640 to = new Number640(locationAndDomainKey, Number160.MAX_VALUE, Number160.MAX_VALUE);
                    digestInfo = this.peerBean().digestStorage().digest(from, to, -1, true);
                } else {
                    LOG.warn("did not search for anything");
                    digestInfo = new DigestInfo();
                }
                responseMessage.intValue(digestInfo.size());
                responseMessage.key(digestInfo.keyDigest());
                responseMessage.key(digestInfo.contentDigest());
            } else if (message.type() == Message.Type.REQUEST_3) {
                DigestInfo digestInfo;
                if (this.peerBean().digestTracker() == null) {
                    digestInfo = new DigestInfo();
                } else {
                    digestInfo = this.peerBean().digestTracker().digest(locationKey, domainKey, contentKey);
                    if (digestInfo.size() == 0) {
                        LOG.debug("No entry found on peer {}", (Object)message.recipient());
                    }
                }
                responseMessage.intValue(digestInfo.size());
            } else if (message.type() == Message.Type.REQUEST_4) {
                List<PeerStatusListener> list = this.peerBean().peerStatusListeners();
                synchronized (list) {
                    for (PeerStatusListener peerStatusListener : this.peerBean().peerStatusListeners()) {
                        peerStatusListener.peerFailed(message.sender(), new PeerException(PeerException.AbortCause.SHUTDOWN, "shutdown"));
                    }
                }
            }
        }
        responder.response(responseMessage);
    }

    protected List<PeerAddress> getNeighbors(Number160 id, int atLeast) {
        NavigableSet<PeerStatistic> closePeers = this.peerBean().peerMap().closePeers(id, atLeast);
        ArrayList<PeerAddress> result = new ArrayList<PeerAddress>();
        for (PeerStatistic ps : closePeers) {
            result.add(ps.peerAddress());
        }
        return result;
    }

    public static class SearchValues {
        private final SimpleBloomFilter<Number160> keyBloomFilter;
        private final SimpleBloomFilter<Number160> contentBloomFilter;
        private final Number160 locationKey;
        private final Number160 domainKey;
        private final Number160 contentKey;
        private final Number640 from;
        private final Number640 to;

        public SearchValues(Number160 locationKey, Number160 domainKey) {
            this.locationKey = locationKey;
            this.domainKey = domainKey;
            this.keyBloomFilter = null;
            this.contentBloomFilter = null;
            this.contentKey = null;
            this.from = null;
            this.to = null;
        }

        public SearchValues(Number160 locationKey, Number160 domainKey, Number160 contentKey) {
            this.locationKey = locationKey;
            this.domainKey = domainKey;
            this.keyBloomFilter = null;
            this.contentBloomFilter = null;
            this.contentKey = contentKey;
            this.from = null;
            this.to = null;
        }

        public SearchValues(Number160 locationKey, Number160 domainKey, Number640 from, Number640 to) {
            this.locationKey = locationKey;
            this.domainKey = domainKey;
            this.keyBloomFilter = null;
            this.contentBloomFilter = null;
            this.contentKey = null;
            this.from = from;
            this.to = to;
        }

        public SearchValues(Number160 locationKey, Number160 domainKey, SimpleBloomFilter<Number160> keyBloomFilter) {
            this.locationKey = locationKey;
            this.domainKey = domainKey;
            this.keyBloomFilter = keyBloomFilter;
            this.contentBloomFilter = null;
            this.contentKey = null;
            this.from = null;
            this.to = null;
        }

        public SearchValues(Number160 locationKey, Number160 domainKey, SimpleBloomFilter<Number160> keyBloomFilter, SimpleBloomFilter<Number160> contentBloomFilter) {
            this.locationKey = locationKey;
            this.domainKey = domainKey;
            this.keyBloomFilter = keyBloomFilter;
            this.contentBloomFilter = contentBloomFilter;
            this.contentKey = null;
            this.from = null;
            this.to = null;
        }

        public Number160 locationKey() {
            return this.locationKey;
        }

        public Number160 domainKey() {
            return this.domainKey;
        }

        public SimpleBloomFilter<Number160> keyBloomFilter() {
            return this.keyBloomFilter;
        }

        public SimpleBloomFilter<Number160> contentBloomFilter() {
            return this.contentBloomFilter;
        }

        public Number160 contentKey() {
            return this.contentKey;
        }

        public Number640 from() {
            return this.from;
        }

        public Number640 to() {
            return this.to;
        }
    }
}

