/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.peers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.SortedSet;
import java.util.TreeSet;
import net.tomp2p.connection.PeerConnection;
import net.tomp2p.connection.PeerException;
import net.tomp2p.p2p.PeerStatisticComparator;
import net.tomp2p.peers.Maintainable;
import net.tomp2p.peers.Maintenance;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.peers.PeerFilter;
import net.tomp2p.peers.PeerMapChangeListener;
import net.tomp2p.peers.PeerMapConfiguration;
import net.tomp2p.peers.PeerStatistic;
import net.tomp2p.peers.PeerStatusListener;
import net.tomp2p.peers.RTT;
import net.tomp2p.utils.CacheMap;
import net.tomp2p.utils.ConcurrentCacheMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeerMap
implements PeerStatusListener,
Maintainable {
    private static final Logger LOG = LoggerFactory.getLogger(PeerMap.class);
    private final int[] bagSizesVerified;
    private final int[] bagSizesOverflow;
    private final Number160 self;
    private final List<Map<Number160, PeerStatistic>> peerMapVerified;
    private final List<Map<Number160, PeerStatistic>> peerMapOverflow;
    private final ConcurrentCacheMap<Number160, PeerAddress> offlineMap;
    private final ConcurrentCacheMap<Number160, PeerAddress> shutdownMap;
    private final ConcurrentCacheMap<Number160, PeerAddress> exceptionMap;
    private final List<PeerMapChangeListener> peerMapChangeListeners = new ArrayList<PeerMapChangeListener>();
    private final Collection<PeerFilter> peerFilters;
    private final int offlineCount;
    private final Maintenance maintenance;
    private final boolean peerVerification;
    private PeerStatisticComparator peerStatisticComparator;

    public PeerMap(PeerMapConfiguration peerMapConfiguration) {
        this.self = peerMapConfiguration.self();
        if (this.self == null || this.self.isZero()) {
            throw new IllegalArgumentException("Zero or null are not a valid IDs");
        }
        this.bagSizesVerified = peerMapConfiguration.getVerifiedBagSizes();
        this.bagSizesOverflow = peerMapConfiguration.getOverflowBagSizes();
        this.offlineCount = peerMapConfiguration.offlineCount();
        this.peerFilters = peerMapConfiguration.peerFilters();
        this.peerMapVerified = this.initMap(this.bagSizesVerified, false);
        this.peerMapOverflow = this.initMap(this.bagSizesOverflow, true);
        this.offlineMap = new ConcurrentCacheMap(peerMapConfiguration.offlineTimeout(), this.totalNumberOfVerifiedBags());
        this.shutdownMap = new ConcurrentCacheMap(peerMapConfiguration.shutdownTimeout(), this.totalNumberOfVerifiedBags());
        this.exceptionMap = new ConcurrentCacheMap(peerMapConfiguration.exceptionTimeout(), this.totalNumberOfVerifiedBags());
        this.maintenance = peerMapConfiguration.maintenance().init(this.peerMapVerified, this.peerMapOverflow, this.offlineMap, this.shutdownMap, this.exceptionMap);
        this.peerVerification = peerMapConfiguration.isPeerVerification();
        this.peerStatisticComparator = peerMapConfiguration.getPeerStatisticComparator();
    }

    private int totalNumberOfVerifiedBags() {
        int sum = 0;
        for (int i = 0; i < 160; ++i) {
            sum += this.bagSizesVerified[i];
        }
        return sum;
    }

    private List<Map<Number160, PeerStatistic>> initMap(int[] bagSizes, boolean caching) {
        ArrayList tmp = new ArrayList();
        for (int i = 0; i < 160; ++i) {
            if (caching) {
                tmp.add(new CacheMap(bagSizes[i], true));
                continue;
            }
            int memAlloc = Math.max(0, bagSizes[i] / 8 - 1);
            tmp.add(new HashMap(memAlloc));
        }
        return Collections.unmodifiableList(tmp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPeerMapChangeListener(PeerMapChangeListener peerMapChangeListener) {
        List<PeerMapChangeListener> list = this.peerMapChangeListeners;
        synchronized (list) {
            this.peerMapChangeListeners.add(peerMapChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePeerMapChangeListener(PeerMapChangeListener peerMapChangeListener) {
        List<PeerMapChangeListener> list = this.peerMapChangeListeners;
        synchronized (list) {
            this.peerMapChangeListeners.add(peerMapChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyInsert(PeerAddress peerAddress, boolean verified) {
        List<PeerMapChangeListener> list = this.peerMapChangeListeners;
        synchronized (list) {
            for (PeerMapChangeListener listener : this.peerMapChangeListeners) {
                listener.peerInserted(peerAddress, verified);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyRemove(PeerAddress peerAddress, PeerStatistic storedPeerAddress) {
        List<PeerMapChangeListener> list = this.peerMapChangeListeners;
        synchronized (list) {
            for (PeerMapChangeListener listener : this.peerMapChangeListeners) {
                listener.peerRemoved(peerAddress, storedPeerAddress);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyUpdate(PeerAddress peerAddress, PeerStatistic storedPeerAddress) {
        List<PeerMapChangeListener> list = this.peerMapChangeListeners;
        synchronized (list) {
            for (PeerMapChangeListener listener : this.peerMapChangeListeners) {
                listener.peerUpdated(peerAddress, storedPeerAddress);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        int size = 0;
        Iterator<Map<Number160, PeerStatistic>> iterator = this.peerMapVerified.iterator();
        while (iterator.hasNext()) {
            Map<Number160, PeerStatistic> map;
            Map<Number160, PeerStatistic> map2 = map = iterator.next();
            synchronized (map2) {
                size += map.size();
            }
        }
        return size;
    }

    public Number160 self() {
        return this.self;
    }

    private boolean reject(PeerAddress peerAddress) {
        if (this.peerFilters == null || this.peerFilters.size() == 0) {
            return false;
        }
        List<PeerAddress> all = this.all();
        for (PeerFilter peerFilter : this.peerFilters) {
            if (!peerFilter.reject(peerAddress, all, this.self)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean peerFound(PeerAddress remotePeer, PeerAddress referrer, PeerConnection peerConnection, RTT roundTripTime) {
        Map<Number160, PeerStatistic> mapOverflow;
        boolean probablyDead;
        boolean thirdHand;
        LOG.debug("peer {} is online reporter was {}", (Object)remotePeer, (Object)referrer);
        boolean firstHand = referrer == null;
        boolean secondHand = remotePeer.equals(referrer);
        boolean bl = thirdHand = !firstHand && !secondHand;
        if (firstHand) {
            this.offlineMap.remove(remotePeer.peerId());
            this.shutdownMap.remove(remotePeer.peerId());
        }
        if (secondHand && !this.peerVerification) {
            this.offlineMap.remove(remotePeer.peerId());
            this.shutdownMap.remove(remotePeer.peerId());
        }
        if (remotePeer.peerId().isZero() || this.self().equals(remotePeer.peerId()) || this.reject(remotePeer)) {
            return false;
        }
        if (remotePeer.isFirewalledTCP() || remotePeer.isFirewalledUDP()) {
            return false;
        }
        if (remotePeer.isRelayed() && remotePeer.peerSocketAddresses().isEmpty()) {
            return false;
        }
        boolean bl2 = probablyDead = this.offlineMap.containsKey(remotePeer.peerId()) || this.shutdownMap.containsKey(remotePeer.peerId()) || this.exceptionMap.containsKey(remotePeer.peerId());
        if (thirdHand && probablyDead) {
            LOG.debug("don't add {}", (Object)remotePeer.peerId());
            return false;
        }
        int classMember = this.classMember(remotePeer.peerId());
        PeerStatistic oldPeerStatistic = PeerMap.updateExistingVerifiedPeerAddress(this.peerMapVerified.get(classMember), remotePeer, firstHand, roundTripTime);
        if (oldPeerStatistic != null) {
            this.notifyUpdate(remotePeer, oldPeerStatistic);
            return true;
        }
        if (firstHand || secondHand && !this.peerVerification) {
            Map<Number160, PeerStatistic> map = this.peerMapVerified.get(classMember);
            boolean insterted = false;
            Map<Number160, PeerStatistic> map2 = map;
            synchronized (map2) {
                if (map.containsKey(remotePeer.peerId())) {
                    return this.peerFound(remotePeer, referrer, peerConnection, roundTripTime);
                }
                if (map.size() < this.bagSizesVerified[classMember]) {
                    PeerStatistic peerStatistic = new PeerStatistic(remotePeer);
                    peerStatistic.successfullyChecked();
                    peerStatistic.addRTT(roundTripTime);
                    map.put(remotePeer.peerId(), peerStatistic);
                    insterted = true;
                }
            }
            if (insterted) {
                Map<Number160, PeerStatistic> mapOverflow2;
                Map<Number160, PeerStatistic> map3 = mapOverflow2 = this.peerMapOverflow.get(classMember);
                synchronized (map3) {
                    mapOverflow2.remove(remotePeer.peerId());
                }
                this.notifyInsert(remotePeer, true);
                return true;
            }
        }
        Map<Number160, PeerStatistic> map = mapOverflow = this.peerMapOverflow.get(classMember);
        synchronized (map) {
            PeerStatistic peerStatistic = mapOverflow.get(remotePeer.peerId());
            if (peerStatistic == null) {
                peerStatistic = new PeerStatistic(remotePeer);
            }
            if (firstHand) {
                peerStatistic.successfullyChecked();
                peerStatistic.addRTT(roundTripTime);
            }
            if (thirdHand && roundTripTime != null) {
                peerStatistic.addRTT(roundTripTime.setEstimated());
            }
            mapOverflow.put(remotePeer.peerId(), peerStatistic);
        }
        this.notifyInsert(remotePeer, false);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean peerFailed(PeerAddress remotePeer, PeerException peerException) {
        LOG.debug("peer {} is offline with reason {}", (Object)remotePeer, (Object)peerException);
        if (remotePeer.peerId().isZero() || this.self().equals(remotePeer.peerId())) {
            return false;
        }
        int classMember = this.classMember(remotePeer.peerId());
        PeerException.AbortCause reason = peerException.abortCause();
        if (reason != PeerException.AbortCause.TIMEOUT) {
            if (reason == PeerException.AbortCause.PROBABLY_OFFLINE) {
                this.offlineMap.put(remotePeer.peerId(), remotePeer);
            } else if (reason == PeerException.AbortCause.SHUTDOWN) {
                this.shutdownMap.put(remotePeer.peerId(), remotePeer);
            } else {
                this.exceptionMap.put(remotePeer.peerId(), remotePeer);
            }
            Map<Number160, PeerStatistic> tmp = this.peerMapOverflow.get(classMember);
            if (tmp != null) {
                Map<Number160, PeerStatistic> map = tmp;
                synchronized (map) {
                    tmp.remove(remotePeer.peerId());
                }
            }
            if ((tmp = this.peerMapVerified.get(classMember)) != null) {
                PeerStatistic peerStatistic;
                boolean removed = false;
                Map<Number160, PeerStatistic> map = tmp;
                synchronized (map) {
                    peerStatistic = tmp.remove(remotePeer.peerId());
                    if (peerStatistic != null) {
                        removed = true;
                    }
                }
                if (removed) {
                    this.notifyRemove(remotePeer, peerStatistic);
                    return true;
                }
            }
            return false;
        }
        if (PeerMap.updatePeerStatistic(remotePeer, this.peerMapVerified.get(classMember), this.offlineCount)) {
            return this.peerFailed(remotePeer, new PeerException(PeerException.AbortCause.PROBABLY_OFFLINE, "peer failed in verified map"));
        }
        if (PeerMap.updatePeerStatistic(remotePeer, this.peerMapOverflow.get(classMember), this.offlineCount)) {
            return this.peerFailed(remotePeer, new PeerException(PeerException.AbortCause.PROBABLY_OFFLINE, "peer failed in overflow map"));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(PeerAddress peerAddress) {
        Map<Number160, PeerStatistic> tmp;
        int classMember = this.classMember(peerAddress.peerId());
        if (classMember == -1) {
            return false;
        }
        Map<Number160, PeerStatistic> map = tmp = this.peerMapVerified.get(classMember);
        synchronized (map) {
            return tmp.containsKey(peerAddress.peerId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsOverflow(PeerAddress peerAddress) {
        Map<Number160, PeerStatistic> tmp;
        int classMember = this.classMember(peerAddress.peerId());
        if (classMember == -1) {
            return false;
        }
        Map<Number160, PeerStatistic> map = tmp = this.peerMapOverflow.get(classMember);
        synchronized (map) {
            return tmp.containsKey(peerAddress.peerId());
        }
    }

    public PeerStatistic getPeerStatistic(PeerAddress peerAddress) {
        int classMember = this.classMember(peerAddress.peerId());
        if (classMember == -1) {
            return null;
        }
        PeerStatistic peerStatistic = this.peerMapVerified().get(classMember).get(peerAddress.peerId());
        if (peerStatistic == null) {
            peerStatistic = this.peerMapOverflow().get(classMember).get(peerAddress.peerId());
        }
        return peerStatistic;
    }

    public NavigableSet<PeerStatistic> closePeers(int atLeast) {
        return this.closePeers(this.self, atLeast);
    }

    public NavigableSet<PeerStatistic> closePeers(Number160 id, int atLeast) {
        return PeerMap.closePeers(this.self(), id, atLeast, this.peerMapVerified, this.peerStatisticComparator.getComparator(id));
    }

    public static NavigableSet<PeerStatistic> closePeers(Number160 self, Number160 other, int atLeast, List<Map<Number160, PeerStatistic>> peerMap, Comparator<PeerStatistic> comparator) {
        int i;
        if (comparator == null) {
            comparator = PeerMap.createXORStatisticComparator(other);
        }
        TreeSet<PeerStatistic> set = new TreeSet<PeerStatistic>(comparator);
        int classMember = PeerMap.classMember(self, other);
        if (classMember == -1) {
            for (int j = 0; j < 160; ++j) {
                Map<Number160, PeerStatistic> tmp = peerMap.get(j);
                if (!PeerMap.fillSet(atLeast, set, tmp)) continue;
                return set;
            }
            return set;
        }
        Map<Number160, PeerStatistic> tmp = peerMap.get(classMember);
        if (PeerMap.fillSet(atLeast, set, tmp)) {
            return set;
        }
        boolean last = false;
        for (i = 0; i < classMember; ++i) {
            tmp = peerMap.get(i);
            last = PeerMap.fillSet(atLeast, set, tmp);
        }
        if (last) {
            return set;
        }
        for (i = classMember + 1; i < 160; ++i) {
            tmp = peerMap.get(i);
            PeerMap.fillSet(atLeast, set, tmp);
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder sb = new StringBuilder("I'm node ");
        sb.append(this.self()).append("\n");
        for (int i = 0; i < 160; ++i) {
            Map<Number160, PeerStatistic> tmp;
            Map<Number160, PeerStatistic> map = tmp = this.peerMapVerified.get(i);
            synchronized (map) {
                if (tmp.size() > 0) {
                    sb.append("class:").append(i).append("->\n");
                    for (PeerStatistic node : tmp.values()) {
                        sb.append("node:").append(node.peerAddress()).append(",");
                    }
                }
                continue;
            }
        }
        return sb.toString();
    }

    public Comparator<PeerAddress> createXORAddressComparator() {
        return PeerMap.createXORAddressComparator(this.self);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PeerAddress> all() {
        ArrayList<PeerAddress> all = new ArrayList<PeerAddress>();
        Iterator<Map<Number160, PeerStatistic>> iterator = this.peerMapVerified.iterator();
        while (iterator.hasNext()) {
            Map<Number160, PeerStatistic> map;
            Map<Number160, PeerStatistic> map2 = map = iterator.next();
            synchronized (map2) {
                for (PeerStatistic peerStatistic : map.values()) {
                    all.add(peerStatistic.peerAddress());
                }
            }
        }
        return all;
    }

    public List<Map<Number160, PeerStatistic>> peerMapVerified() {
        return this.peerMapVerified;
    }

    public List<Map<Number160, PeerStatistic>> peerMapOverflow() {
        return this.peerMapOverflow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PeerAddress> allOverflow() {
        ArrayList<PeerAddress> all = new ArrayList<PeerAddress>();
        Iterator<Map<Number160, PeerStatistic>> iterator = this.peerMapOverflow.iterator();
        while (iterator.hasNext()) {
            Map<Number160, PeerStatistic> map;
            Map<Number160, PeerStatistic> map2 = map = iterator.next();
            synchronized (map2) {
                for (PeerStatistic peerStatistic : map.values()) {
                    all.add(peerStatistic.peerAddress());
                }
            }
        }
        return all;
    }

    public boolean isPeerRemovedTemporarly(PeerAddress peerAddress) {
        return this.offlineMap.containsKey(peerAddress.peerId()) || this.shutdownMap.containsKey(peerAddress.peerId()) || this.exceptionMap.containsKey(peerAddress.peerId());
    }

    @Override
    public PeerStatistic nextForMaintenance(Collection<PeerAddress> notInterestedAddresses) {
        return this.maintenance.nextForMaintenance(notInterestedAddresses);
    }

    private int classMember(Number160 remoteID) {
        return PeerMap.classMember(this.self(), remoteID);
    }

    public static int isCloser(Number160 id, PeerAddress rn, PeerAddress rn2) {
        return PeerMap.isKadCloser(id, rn, rn2);
    }

    public static int isCloser(Number160 id, Number160 rn, Number160 rn2) {
        return PeerMap.distance(id, rn).compareTo(PeerMap.distance(id, rn2));
    }

    public static int isKadCloser(Number160 id, PeerAddress rn, PeerAddress rn2) {
        return PeerMap.distance(id, rn.peerId()).compareTo(PeerMap.distance(id, rn2.peerId()));
    }

    public static int classCloser(Number160 ln, PeerAddress rn, PeerAddress rn2) {
        Integer d1 = PeerMap.classMember(ln, rn.peerId());
        Integer d2 = PeerMap.classMember(ln, rn2.peerId());
        return d1.compareTo(d2);
    }

    public static Comparator<PeerAddress> createXORAddressComparator(final Number160 location) {
        return new Comparator<PeerAddress>(){

            @Override
            public int compare(PeerAddress remotePeer, PeerAddress remotePeer2) {
                return PeerMap.isKadCloser(location, remotePeer, remotePeer2);
            }
        };
    }

    public static Comparator<PeerStatistic> createXORStatisticComparator(final Number160 location) {
        return new Comparator<PeerStatistic>(){

            @Override
            public int compare(PeerStatistic o1, PeerStatistic o2) {
                if (o1.peerAddress() != null && o2.peerAddress() != null) {
                    return PeerMap.isKadCloser(location, o1.peerAddress(), o2.peerAddress());
                }
                return 0;
            }
        };
    }

    public Comparator<PeerStatistic> createStatisticComparator(Number160 location) {
        return this.peerStatisticComparator.getComparator(location);
    }

    public Collection<PeerStatistic> getPeerStatistics(Collection<PeerAddress> peerAddresses) {
        HashSet<PeerStatistic> result = new HashSet<PeerStatistic>();
        for (PeerAddress peerAddress : peerAddresses) {
            PeerStatistic peerStatistic = this.getPeerStatistic(peerAddress);
            if (peerStatistic == null) {
                peerStatistic = new PeerStatistic(peerAddress);
            }
            result.add(peerStatistic);
        }
        return result;
    }

    public static Comparator<Number160> createComparator2(final Number160 id) {
        return new Comparator<Number160>(){

            @Override
            public int compare(Number160 remotePeer, Number160 remotePeer2) {
                return PeerMap.isCloser(id, remotePeer, remotePeer2);
            }
        };
    }

    public static int classMember(Number160 id1, Number160 id2) {
        return PeerMap.distance(id1, id2).bitLength() - 1;
    }

    static Number160 distance(Number160 id1, Number160 id2) {
        return id1.xor(id2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean updatePeerStatistic(PeerAddress remotePeer, Map<Number160, PeerStatistic> tmp, int maxFail) {
        if (tmp != null) {
            Map<Number160, PeerStatistic> map = tmp;
            synchronized (map) {
                PeerStatistic peerStatistic = tmp.get(remotePeer.peerId());
                if (peerStatistic != null && peerStatistic.failed() >= maxFail) {
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PeerStatistic updateExistingVerifiedPeerAddress(Map<Number160, PeerStatistic> tmp, PeerAddress peerAddress, boolean firstHand, RTT roundTripTime) {
        Map<Number160, PeerStatistic> map = tmp;
        synchronized (map) {
            PeerStatistic old = tmp.get(peerAddress.peerId());
            if (old != null) {
                old.peerAddress(peerAddress);
                old.addRTT(roundTripTime);
                if (firstHand) {
                    old.successfullyChecked();
                    old.increaseNumberOfResponses();
                }
                return old;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean fillSet(int atLeast, SortedSet<PeerStatistic> set, Map<Number160, PeerStatistic> tmp) {
        Map<Number160, PeerStatistic> map = tmp;
        synchronized (map) {
            for (PeerStatistic peerStatistic : tmp.values()) {
                set.add(peerStatistic);
            }
        }
        return set.size() >= atLeast;
    }

    public int bagSizeVerified(int bag) {
        return this.bagSizesVerified[bag];
    }

    public int bagSizeOverflow(int bag) {
        return this.bagSizesOverflow[bag];
    }

    public PeerAddress find(Number160 peerId) {
        int classMember = PeerMap.classMember(this.self, peerId);
        if (classMember < 0) {
            return null;
        }
        Map<Number160, PeerStatistic> tmp = this.peerMapVerified.get(classMember);
        PeerStatistic peerStatistic = tmp.get(peerId);
        if (peerStatistic != null) {
            return peerStatistic.peerAddress();
        }
        return null;
    }
}

