/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.connection;

import net.tomp2p.connection.SendBehavior;
import net.tomp2p.message.Message;
import net.tomp2p.rpc.RPC;

public class DefaultSendBehavior
implements SendBehavior {
    @Override
    public SendBehavior.SendMethod tcpSendBehavior(Message message) {
        if (message.recipient().equals(message.sender())) {
            return SendBehavior.SendMethod.SELF;
        }
        if (message.recipient().isRelayed()) {
            if (message.sender().isRelayed()) {
                return SendBehavior.SendMethod.RELAY;
            }
            if (message.recipient().isSlow()) {
                return SendBehavior.SendMethod.RELAY;
            }
            return SendBehavior.SendMethod.RCON;
        }
        return SendBehavior.SendMethod.DIRECT;
    }

    @Override
    public SendBehavior.SendMethod udpSendBehavior(Message message) throws UnsupportedOperationException {
        if (message.recipient().equals(message.sender())) {
            return SendBehavior.SendMethod.SELF;
        }
        if (message.recipient().isRelayed()) {
            if (message.command() == RPC.Commands.NEIGHBOR.getNr() || message.command() == RPC.Commands.PING.getNr()) {
                return SendBehavior.SendMethod.RELAY;
            }
            throw new UnsupportedOperationException("Tried to send UDP message to unreachable peers. Only TCP messages can be sent to unreachable peers");
        }
        return SendBehavior.SendMethod.DIRECT;
    }
}

