/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.utils;

import io.netty.buffer.ByteBuf;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.SequenceInputStream;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import net.tomp2p.connection.ChannelCreator;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.BaseFutureListener;
import net.tomp2p.futures.FutureChannelCreator;
import net.tomp2p.message.TrackerData;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.Number480;
import net.tomp2p.peers.Number640;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.storage.DataBuffer;
import net.tomp2p.utils.MultiByteBufferInputStream;

public class Utils {
    private static final Random random = new Random();
    public static final int IPV4_BYTES = 4;
    public static final int IPV6_BYTES = 16;
    public static final int BYTE_BITS = 8;
    public static final int MASK_0F = 15;
    public static final int MASK_80 = 128;
    public static final int MASK_FF = 255;
    public static final int BYTE_BYTE_SIZE = 1;
    public static final int SHORT_BYTE_SIZE = 2;
    public static final int INTEGER_BYTE_SIZE = 4;
    public static final int LONG_BYTE_SIZE = 8;
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuffer loadFile(File file) throws IOException {
        MappedByteBuffer mappedByteBuffer;
        FileInputStream fis = null;
        FileChannel channel = null;
        try {
            fis = new FileInputStream(file);
            channel = fis.getChannel();
            mappedByteBuffer = channel.map(FileChannel.MapMode.READ_ONLY, 0L, channel.size());
        }
        catch (Throwable throwable) {
            Utils.bestEffortclose(channel, fis);
            throw throwable;
        }
        Utils.bestEffortclose(channel, fis);
        return mappedByteBuffer;
    }

    /*
     * Exception decompiling
     */
    public static Number160 makeSHAHash(File file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Number160 makeSHAHash(String strInput) {
        byte[] buffer = strInput.getBytes();
        return Utils.makeSHAHash(buffer);
    }

    public static Number160 makeSHAHash(ByteBuffer buffer) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            md.update(buffer);
            byte[] digest = md.digest();
            return new Number160(digest);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return new Number160();
        }
    }

    public static Number160 makeSHAHash(ByteBuf buf) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            ByteBuffer[] byteBuffers = buf.nioBuffers();
            int len = byteBuffers.length;
            for (int i = 0; i < len; ++i) {
                md.update(byteBuffers[i]);
            }
            byte[] digest = md.digest();
            return new Number160(digest);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return new Number160();
        }
    }

    public static Number160 makeSHAHash(DataBuffer buffer) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            DataBuffer copy = buffer.shallowCopy();
            for (ByteBuffer byteBuffer : copy.bufferList()) {
                md.update(byteBuffer);
            }
            byte[] digest = md.digest();
            return new Number160(digest);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return new Number160();
        }
    }

    public static Number160 makeSHAHash(byte[] buffer) {
        return Utils.makeSHAHash(ByteBuffer.wrap(buffer));
    }

    public static Number160 makeSHAHash(byte[] buffer, int offset, int length) {
        return Utils.makeSHAHash(ByteBuffer.wrap(buffer, offset, length));
    }

    public static byte[] makeMD5Hash(byte[] buffer) {
        return Utils.makeMD5Hash(buffer, 0, buffer.length);
    }

    public static byte[] makeMD5Hash(byte[] buffer, int offset, int length) {
        MessageDigest m;
        try {
            m = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return new byte[0];
        }
        m.update(buffer, offset, length);
        return m.digest();
    }

    public static Number160 createRandomNodeID() {
        byte[] me = new byte[20];
        random.nextBytes(me);
        Number160 id = new Number160(me);
        return id;
    }

    public static byte[] compress(byte[] input) {
        Deflater compressor = new Deflater();
        compressor.setLevel(1);
        compressor.setInput(input);
        compressor.finish();
        ByteArrayOutputStream bos = new ByteArrayOutputStream(input.length);
        byte[] buf = new byte[1024];
        while (!compressor.finished()) {
            int count = compressor.deflate(buf);
            bos.write(buf, 0, count);
        }
        try {
            bos.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        return bos.toByteArray();
    }

    public static byte[] uncompress(byte[] compressedData, int offset, int length) {
        Inflater decompressor = new Inflater();
        decompressor.setInput(compressedData, offset, length);
        ByteArrayOutputStream bos = new ByteArrayOutputStream(length);
        byte[] buf = new byte[1024];
        while (!decompressor.finished()) {
            try {
                int count = decompressor.inflate(buf);
                bos.write(buf, 0, count);
            }
            catch (DataFormatException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        try {
            bos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return bos.toByteArray();
    }

    public static byte[] uncompress(byte[] compressedData) {
        return Utils.uncompress(compressedData, 0, compressedData.length);
    }

    public static byte[] encodeJavaObject(Object attachement) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(attachement);
        byte[] data = bos.toByteArray();
        return data;
    }

    public static Object decodeJavaObject(ByteBuf channelBuffer) throws ClassNotFoundException, IOException {
        MultiByteBufferInputStream is = new MultiByteBufferInputStream(channelBuffer);
        ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(is));
        Object obj = ois.readObject();
        ois.close();
        return obj;
    }

    public static synchronized Object decodeJavaObject(DataBuffer dataBuffer) throws ClassNotFoundException, IOException {
        List<ByteBuffer> buffers = dataBuffer.shallowCopy().bufferList();
        int count = buffers.size();
        Vector<InputStream> is = new Vector<InputStream>(count);
        for (ByteBuffer byteBuffer : buffers) {
            is.add(Utils.createInputStream(byteBuffer));
        }
        SequenceInputStream sis = new SequenceInputStream(is.elements());
        ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(sis));
        Object obj = ois.readObject();
        ois.close();
        return obj;
    }

    public static InputStream createInputStream(final ByteBuffer buf) {
        return new InputStream(){

            @Override
            public int read() throws IOException {
                if (!buf.hasRemaining()) {
                    return -1;
                }
                return buf.get() & 0xFF;
            }

            @Override
            public int read(byte[] bytes, int off, int len) throws IOException {
                if (!buf.hasRemaining()) {
                    return -1;
                }
                len = Math.min(len, buf.remaining());
                buf.get(bytes, off, len);
                return len;
            }
        };
    }

    public static Object decodeJavaObject(byte[] me, int offset, int length) throws ClassNotFoundException, IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(me, offset, length);
        ObjectInputStream ois = new ObjectInputStream(bais);
        Object obj = ois.readObject();
        return obj;
    }

    public static <K> Collection<K> difference(Collection<K> collection1, Collection<K> result, Collection<K> collection2) {
        for (K item : collection1) {
            if (collection2.contains(item)) continue;
            result.add(item);
        }
        return result;
    }

    @SafeVarargs
    public static <K> Collection<K> difference(Collection<K> collection1, Collection<K> result, Collection<K> ... collections2) {
        for (K item : collection1) {
            int size = collections2.length;
            boolean found = false;
            for (int i = 0; i < size; ++i) {
                if (!collections2[i].contains(item)) continue;
                found = true;
                break;
            }
            if (found) continue;
            result.add(item);
        }
        return result;
    }

    public static void bestEffortclose(Closeable ... closables) {
        for (Closeable closable : closables) {
            if (closable == null) continue;
            try {
                closable.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static final byte[] intToByteArray(int value) {
        return new byte[]{(byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)value};
    }

    public static final int byteArrayToInt(byte[] b) {
        return (b[0] << 24) + ((b[1] & 0xFF) << 16) + ((b[2] & 0xFF) << 8) + (b[3] & 0xFF);
    }

    public static <K> K pollRandom(Collection<K> collection, Random rnd) {
        int size = collection.size();
        if (size == 0) {
            return null;
        }
        int index = rnd.nextInt(size);
        ArrayList<K> values = new ArrayList<K>(collection);
        Object retVal = values.get(index);
        collection.remove(retVal);
        return (K)retVal;
    }

    public static <K> K peekRandom(Collection<K> collection, Random rnd) {
        int size = collection.size();
        if (size == 0) {
            return null;
        }
        int index = rnd.nextInt(size);
        ArrayList<K> values = new ArrayList<K>(collection);
        return (K)values.get(index);
    }

    public static <K, V> Map.Entry<K, V> pollRandomKey(Map<K, V> queueToAsk, Random rnd) {
        int size = queueToAsk.size();
        if (size == 0) {
            return null;
        }
        ArrayList<K> keys = new ArrayList<K>();
        keys.addAll(queueToAsk.keySet());
        int index = rnd.nextInt(size);
        final Object key = keys.get(index);
        final V value = queueToAsk.remove(key);
        return new Map.Entry<K, V>(){

            @Override
            public K getKey() {
                return key;
            }

            @Override
            public V getValue() {
                return value;
            }

            @Override
            public V setValue(V value2) {
                return null;
            }
        };
    }

    public static <K> Collection<K> subtract(Collection<K> a, Collection<K> b) {
        ArrayList<K> list = new ArrayList<K>(a);
        Iterator<K> it = b.iterator();
        while (it.hasNext()) {
            list.remove(it.next());
        }
        return list;
    }

    public static <K, V> Map<K, V> subtract(Map<K, V> a, Collection<K> b) {
        HashMap<K, V> map = new HashMap<K, V>(a);
        Iterator<K> it = b.iterator();
        while (it.hasNext()) {
            map.remove(it.next());
        }
        return map;
    }

    public static <K, V> Map<K, V> disjunction(Map<K, V> a, Collection<K> b) {
        HashMap<K, V> map = new HashMap<K, V>();
        for (Map.Entry<K, V> entry : a.entrySet()) {
            if (b.contains(entry.getKey())) continue;
            map.put(entry.getKey(), entry.getValue());
        }
        return map;
    }

    public static <K> Collection<K> limit(Collection<K> a, int size) {
        ArrayList<K> list = new ArrayList<K>();
        int i = 0;
        Iterator<K> it = a.iterator();
        while (it.hasNext() && i < size) {
            list.add(it.next());
        }
        return list;
    }

    public static <K, V> Map<K, V> limit(Map<K, V> a, int i) {
        HashMap<K, V> map = new HashMap<K, V>(a);
        Iterator<K> it = a.keySet().iterator();
        for (int remove = a.size() - i; it.hasNext() && remove >= 0; --remove) {
            map.remove(it.next());
        }
        return map;
    }

    public static String debugArray(byte[] array, int offset, int length) {
        String digits = "0123456789abcdef";
        StringBuilder sb = new StringBuilder(length * 2);
        for (int i = 0; i < length; ++i) {
            int bi = array[offset + i] & 0xFF;
            sb.append(digits.charAt(bi >> 4));
            sb.append(digits.charAt(bi & 0xF));
        }
        return sb.toString();
    }

    public static String debugArray(byte[] array) {
        return Utils.debugArray(array, 0, array.length);
    }

    public static TrackerData limitRandom(TrackerData activePeers, int trackerSize) {
        return activePeers;
    }

    public static <K> K getLast(List<K> list) {
        if (!list.isEmpty()) {
            return list.get(list.size() - 1);
        }
        return null;
    }

    public static Inet4Address fromInteger(int address) {
        return Utils.getInet4Address(Utils.toByteArray(address));
    }

    private static byte[] toByteArray(int value) {
        return new byte[]{(byte)(value >> 24), (byte)(value >> 16), (byte)(value >> 8), (byte)value};
    }

    private static Inet4Address getInet4Address(byte[] bytes) {
        if (bytes.length != 4) {
            throw new IllegalArgumentException("Byte array has invalid length for an IPv4 address");
        }
        try {
            InetAddress ipv4 = InetAddress.getByAddress(bytes);
            if (!(ipv4 instanceof Inet4Address)) {
                throw new UnknownHostException(String.format("'%s' is not an IPv4 address.", ipv4.getHostAddress()));
            }
            return (Inet4Address)ipv4;
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(String.format("Host address '%s' is not a valid IPv4 address.", Arrays.toString(bytes)), e);
        }
    }

    public static File createTempDir() throws IOException {
        File temp = File.createTempFile("temp", Long.toString(System.nanoTime()));
        if (!temp.delete()) {
            throw new IOException("Could not delete temp file: " + temp.getAbsolutePath());
        }
        if (!temp.mkdir()) {
            throw new IOException("Could not create temp directory: " + temp.getAbsolutePath());
        }
        return temp;
    }

    public static void nullCheck(Object ... objects) {
        int counter = 0;
        for (Object object : objects) {
            if (object == null) {
                throw new IllegalArgumentException("Null not allowed in paramenetr nr. " + counter);
            }
            ++counter;
        }
    }

    public static boolean nullCheckRetVal(Object ... objects) {
        for (Object object : objects) {
            if (object != null) continue;
            return true;
        }
        return false;
    }

    public static Collection<Number160> extractContentKeys(Collection<Number480> collection) {
        ArrayList<Number160> result = new ArrayList<Number160>(collection.size());
        for (Number480 number480 : collection) {
            result.add(number480.contentKey());
        }
        return result;
    }

    public static InetAddress inet4FromBytes(byte[] src, int offset) {
        byte[] tmp2 = new byte[4];
        System.arraycopy(src, offset, tmp2, 0, 4);
        try {
            return Inet4Address.getByAddress(tmp2);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(String.format("Host address '%s' is not a valid IPv4 address.", Arrays.toString(tmp2)), e);
        }
    }

    public static InetAddress inet6FromBytes(byte[] me, int offset) {
        byte[] tmp2 = new byte[16];
        System.arraycopy(me, offset, tmp2, 0, 16);
        try {
            return Inet6Address.getByAddress(tmp2);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(String.format("Host address '%s' is not a valid IPv4 address.", Arrays.toString(tmp2)), e);
        }
    }

    public static BitSet createBitSet(byte b) {
        BitSet bitSet = new BitSet(8);
        for (int i = 0; i < 8; ++i) {
            bitSet.set(i, (b & 1 << i) != 0);
        }
        return bitSet;
    }

    public static byte createByte(BitSet bitSet) {
        byte b = 0;
        for (int i = 0; i < 8; ++i) {
            if (!bitSet.get(i)) continue;
            b = (byte)(b | 1 << i);
        }
        return b;
    }

    public static void addReleaseListener(final ChannelCreator channelCreator, BaseFuture ... baseFutures) {
        if (baseFutures == null) {
            channelCreator.shutdown();
            return;
        }
        final int count = baseFutures.length;
        final AtomicInteger finished = new AtomicInteger(0);
        for (BaseFuture baseFuture : baseFutures) {
            baseFuture.addListener((BaseFutureListener<? extends BaseFuture>)new BaseFutureAdapter<BaseFuture>(){

                @Override
                public void operationComplete(BaseFuture future) throws Exception {
                    if (finished.incrementAndGet() == count) {
                        channelCreator.shutdown();
                    }
                }
            });
        }
    }

    public static void addReleaseListener(final FutureChannelCreator fcc, BaseFuture baseFuture) {
        baseFuture.addListener((BaseFutureListener<? extends BaseFuture>)new BaseFutureAdapter<BaseFuture>(){

            @Override
            public void operationComplete(BaseFuture future) throws Exception {
                fcc.addListener((BaseFutureListener<BaseFuture>)new BaseFutureAdapter<FutureChannelCreator>(){

                    @Override
                    public void operationComplete(FutureChannelCreator future) throws Exception {
                        if (future.channelCreator() != null) {
                            future.channelCreator().shutdown();
                        }
                    }
                });
            }
        });
    }

    public static <T> boolean isSameSets(Collection<T> set1, Collection<T> set2) {
        if (set1 == null ^ set2 == null) {
            return false;
        }
        if (set1 == null && set2 == null) {
            return true;
        }
        if (set1.size() != set2.size()) {
            return false;
        }
        for (T obj : set1) {
            if (set2.contains(obj)) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    public static String hash(PublicKey publicKey) {
        if (publicKey == null) {
            return "null";
        }
        return String.valueOf(publicKey.hashCode());
    }

    public static Map<Number640, Byte> setMapError(Map<Number640, ?> dataMap, byte reason) {
        HashMap<Number640, Byte> retVal = new HashMap<Number640, Byte>();
        for (Number640 key : dataMap.keySet()) {
            retVal.put(key, reason);
        }
        return retVal;
    }

    public static int randomPositiveInt(int upperBound) {
        int randomInt = random.nextInt() % upperBound;
        if (randomInt < 0) {
            randomInt *= -1;
        }
        return randomInt;
    }

    public static InetSocketAddress natReflection(InetSocketAddress recipient, boolean udp, PeerAddress self) {
        if (self.isPortForwarding() && recipient.getAddress().equals(self.inetAddress()) && self.internalPeerSocketAddress() != null) {
            if (udp && recipient.getPort() == self.udpPort()) {
                try {
                    return new InetSocketAddress(InetAddress.getLocalHost(), self.internalPeerSocketAddress().udpPort());
                }
                catch (UnknownHostException e) {
                    e.printStackTrace();
                    return recipient;
                }
            }
            if (!udp && recipient.getPort() == self.tcpPort()) {
                try {
                    return new InetSocketAddress(InetAddress.getLocalHost(), self.internalPeerSocketAddress().tcpPort());
                }
                catch (UnknownHostException e) {
                    e.printStackTrace();
                    return recipient;
                }
            }
        }
        return recipient;
    }
}

