/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.message;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.peers.PeerStatistic;
import net.tomp2p.storage.Data;
import net.tomp2p.utils.Pair;

public class TrackerData {
    private static final Data EMTPY_DATA = new Data(0, 0);
    private final Map<PeerAddress, Data> peerAddresses;
    private final boolean couldProvideMoreData;

    public TrackerData(Map<PeerAddress, Data> peerAddresses) {
        this(peerAddresses, false);
    }

    public TrackerData(Map<PeerAddress, Data> peerAddresses, boolean couldProvideMoreData) {
        this.peerAddresses = peerAddresses;
        this.couldProvideMoreData = couldProvideMoreData;
    }

    public TrackerData(Collection<Pair<PeerStatistic, Data>> value) {
        this.peerAddresses = new HashMap<PeerAddress, Data>(value.size());
        for (Pair<PeerStatistic, Data> pair : value) {
            this.peerAddresses.put(pair.element0().peerAddress(), pair.element1());
        }
        this.couldProvideMoreData = false;
    }

    public Map<PeerAddress, Data> peerAddresses() {
        if (this.peerAddresses == null) {
            return Collections.emptyMap();
        }
        return this.peerAddresses;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("tdata:");
        if (this.peerAddresses != null) {
            sb.append("p:").append(this.peerAddresses);
        }
        return sb.toString();
    }

    public boolean couldProvideMoreData() {
        return this.couldProvideMoreData;
    }

    public int size() {
        return this.peerAddresses.size();
    }

    public void put(PeerAddress remotePeer, Data attachement) {
        this.peerAddresses.put(remotePeer, attachement == null ? EMTPY_DATA : attachement);
    }

    public Map.Entry<PeerAddress, Data> remove(Number160 remotePeerId) {
        Iterator<Map.Entry<PeerAddress, Data>> iterator = this.peerAddresses.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<PeerAddress, Data> entry = iterator.next();
            if (!entry.getKey().peerId().equals(remotePeerId)) continue;
            iterator.remove();
            return entry;
        }
        return null;
    }

    public boolean containsKey(Number160 tmpKey) {
        for (Map.Entry<PeerAddress, Data> entry : this.peerAddresses.entrySet()) {
            if (!entry.getKey().peerId().equals(tmpKey)) continue;
            return true;
        }
        return false;
    }

    public Map.Entry<PeerAddress, Data> get(Number160 tmpKey) {
        for (Map.Entry<PeerAddress, Data> entry : this.peerAddresses.entrySet()) {
            if (!entry.getKey().peerId().equals(tmpKey)) continue;
            return entry;
        }
        return null;
    }

    public boolean isEmpty() {
        return this.peerAddresses.isEmpty();
    }
}

