/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.p2p.builder;

import java.security.KeyPair;
import java.util.ArrayList;
import java.util.Collection;
import net.tomp2p.connection.ConnectionConfiguration;
import net.tomp2p.connection.DefaultConnectionConfiguration;
import net.tomp2p.futures.FutureChannelCreator;
import net.tomp2p.p2p.Peer;
import net.tomp2p.p2p.RequestP2PConfiguration;
import net.tomp2p.p2p.RoutingConfiguration;
import net.tomp2p.p2p.builder.BasicBuilder;
import net.tomp2p.p2p.builder.RoutingBuilder;
import net.tomp2p.p2p.builder.SignatureBuilder;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerFilter;

public abstract class DHTBuilder<K extends DHTBuilder<K>>
extends DefaultConnectionConfiguration
implements BasicBuilder<K>,
ConnectionConfiguration,
SignatureBuilder<K> {
    protected final Peer peer;
    protected final Number160 locationKey;
    protected Number160 domainKey;
    protected Number160 versionKey;
    protected RoutingConfiguration routingConfiguration;
    protected RequestP2PConfiguration requestP2PConfiguration;
    protected FutureChannelCreator futureChannelCreator;
    private boolean protectDomain = false;
    private KeyPair keyPair = null;
    private boolean streaming = false;
    private Collection<PeerFilter> peerFilters;
    private K self;

    public DHTBuilder(Peer peer, Number160 locationKey) {
        this.peer = peer;
        this.locationKey = locationKey;
    }

    public void self(K self) {
        this.self = self;
    }

    @Override
    public Number160 getLocationKey() {
        return this.locationKey;
    }

    @Override
    public Number160 getDomainKey() {
        return this.domainKey;
    }

    @Override
    public K setDomainKey(Number160 domainKey) {
        this.domainKey = domainKey;
        return this.self;
    }

    public Number160 getVersionKey() {
        return this.versionKey;
    }

    public K setVersionKey(Number160 versionKey) {
        this.versionKey = versionKey;
        return this.self;
    }

    @Override
    public RoutingConfiguration getRoutingConfiguration() {
        return this.routingConfiguration;
    }

    @Override
    public K setRoutingConfiguration(RoutingConfiguration routingConfiguration) {
        this.routingConfiguration = routingConfiguration;
        return this.self;
    }

    @Override
    public RequestP2PConfiguration getRequestP2PConfiguration() {
        return this.requestP2PConfiguration;
    }

    @Override
    public K setRequestP2PConfiguration(RequestP2PConfiguration requestP2PConfiguration) {
        this.requestP2PConfiguration = requestP2PConfiguration;
        return this.self;
    }

    public FutureChannelCreator getFutureChannelCreator() {
        return this.futureChannelCreator;
    }

    public K setFutureChannelCreator(FutureChannelCreator futureChannelCreator) {
        this.futureChannelCreator = futureChannelCreator;
        return this.self;
    }

    public boolean isProtectDomain() {
        return this.protectDomain;
    }

    public K setProtectDomain(boolean protectDomain) {
        this.protectDomain = protectDomain;
        return this.self;
    }

    public K setProtectDomain() {
        this.protectDomain = true;
        if (this.keyPair == null) {
            this.setSign();
        }
        return this.self;
    }

    @Override
    public boolean isSign() {
        return this.keyPair != null;
    }

    @Override
    public K sign(boolean signMessage) {
        if (signMessage) {
            this.setSign();
        } else {
            this.keyPair = null;
        }
        return this.self;
    }

    @Override
    public K setSign() {
        this.keyPair = this.peer.getPeerBean().keyPair();
        return this.self;
    }

    @Override
    public K keyPair(KeyPair keyPair) {
        this.keyPair = keyPair;
        return this.self;
    }

    @Override
    public KeyPair keyPair() {
        return this.keyPair;
    }

    public boolean isStreaming() {
        return this.streaming;
    }

    public K setStreaming(boolean streaming) {
        this.streaming = streaming;
        return this.self;
    }

    public K setStreaming() {
        this.streaming = true;
        return this.self;
    }

    public K addPeerFilter(PeerFilter peerFilter) {
        if (this.peerFilters == null) {
            this.peerFilters = new ArrayList<PeerFilter>(2);
        }
        this.peerFilters.add(peerFilter);
        return this.self;
    }

    @Override
    public Collection<PeerFilter> peerFilters() {
        return this.peerFilters;
    }

    protected void preBuild(String name) {
        if (this.domainKey == null) {
            this.domainKey = Number160.ZERO;
        }
        if (this.versionKey == null) {
            this.versionKey = Number160.ZERO;
        }
        if (this.routingConfiguration == null) {
            this.routingConfiguration = new RoutingConfiguration(5, 10, 2);
        }
        if (this.requestP2PConfiguration == null) {
            this.requestP2PConfiguration = new RequestP2PConfiguration(3, 5, 3);
        }
        int size = this.peer.getPeerBean().peerMap().size() + 1;
        this.requestP2PConfiguration = this.requestP2PConfiguration.adjustMinimumResult(size);
        if (this.futureChannelCreator == null || this.futureChannelCreator.getChannelCreator() != null && this.futureChannelCreator.getChannelCreator().isShutdown()) {
            this.futureChannelCreator = this.peer.getConnectionBean().reservation().create(this.routingConfiguration, this.requestP2PConfiguration, this);
        }
    }

    @Override
    public RoutingBuilder createBuilder(RequestP2PConfiguration requestP2PConfiguration, RoutingConfiguration routingConfiguration) {
        RoutingBuilder routingBuilder = new RoutingBuilder();
        routingBuilder.setParallel(routingConfiguration.getParallel());
        routingBuilder.setMaxNoNewInfo(routingConfiguration.getMaxNoNewInfo(requestP2PConfiguration.getMinimumResults()));
        routingBuilder.setMaxDirectHits(routingConfiguration.getMaxDirectHits());
        routingBuilder.setMaxFailures(routingConfiguration.getMaxFailures());
        routingBuilder.setMaxSuccess(routingConfiguration.getMaxSuccess());
        return routingBuilder;
    }
}

