/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.p2p;

public class RequestP2PConfiguration {
    private final int minimumResults;
    private final int maxFailure;
    private final int parallelDiff;
    private final boolean forceUPD;
    private final boolean forceTCP;

    public RequestP2PConfiguration(int minimumResults, int maxFailure, int parallelDiff) {
        this(minimumResults, maxFailure, parallelDiff, false, false);
    }

    public RequestP2PConfiguration(int minimumResults, int maxFailure, int parallelDiff, boolean forceUPD, boolean forceTCP) {
        if (minimumResults < 0 || maxFailure < 0 || parallelDiff < 0) {
            throw new IllegalArgumentException("need to be larger or equals zero");
        }
        this.minimumResults = minimumResults;
        this.maxFailure = maxFailure;
        this.parallelDiff = parallelDiff;
        this.forceUPD = forceUPD;
        this.forceTCP = forceTCP;
    }

    public RequestP2PConfiguration adjustMinimumResult(int minimumResultsLow) {
        return new RequestP2PConfiguration(Math.min(minimumResultsLow, this.minimumResults), this.maxFailure, this.parallelDiff, this.forceUPD, this.forceTCP);
    }

    public int getMinimumResults() {
        return this.minimumResults;
    }

    public int getMaxFailure() {
        return this.maxFailure;
    }

    public int getParallelDiff() {
        return this.parallelDiff;
    }

    public int getParallel() {
        return this.minimumResults + this.parallelDiff;
    }

    public boolean isForceUPD() {
        return this.forceUPD;
    }

    public boolean isForceTCP() {
        return this.forceTCP;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("minRes=");
        sb.append(this.minimumResults);
        sb.append("maxFail=");
        sb.append(this.maxFailure);
        sb.append("pDiff=");
        sb.append(this.parallelDiff);
        return sb.toString();
    }
}

