/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.message;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.DatagramPacket;
import net.tomp2p.connection.SignatureFactory;
import net.tomp2p.message.CompByteBufAllocator;
import net.tomp2p.message.Encoder;
import net.tomp2p.message.Message;
import net.tomp2p.storage.AlternativeCompositeByteBuf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TomP2POutbound
extends ChannelOutboundHandlerAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(TomP2POutbound.class);
    private final boolean preferDirect;
    private final Encoder encoder;
    private final CompByteBufAllocator alloc;

    public TomP2POutbound(boolean preferDirect, SignatureFactory signatureFactory) {
        this(preferDirect, signatureFactory, new CompByteBufAllocator());
    }

    public TomP2POutbound(boolean preferDirect, SignatureFactory signatureFactory, CompByteBufAllocator alloc) {
        this.preferDirect = preferDirect;
        this.encoder = new Encoder(signatureFactory);
        this.alloc = alloc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        AlternativeCompositeByteBuf buf = null;
        try {
            boolean done = false;
            if (!(msg instanceof Message)) {
                ctx.write(msg, promise);
                return;
            }
            Message message = (Message)msg;
            buf = this.preferDirect ? this.alloc.compDirectBuffer() : this.alloc.compBuffer();
            done = this.encoder.write(buf, message);
            message = this.encoder.message();
            if (buf.isReadable()) {
                if (ctx.channel() instanceof DatagramChannel) {
                    if (message.senderSocket() == null) {
                        message.senderSocket(message.getRecipient().createSocketUDP());
                    }
                    DatagramPacket d = new DatagramPacket((ByteBuf)buf, message.senderSocket(), message.recipientSocket());
                    LOG.debug("Send UPD message {}, datagram: {}", (Object)message, (Object)d);
                    ctx.writeAndFlush((Object)d, promise);
                } else {
                    LOG.debug("Send TCP message {} to {}", (Object)message, (Object)message.senderSocket());
                    ctx.writeAndFlush((Object)buf, promise);
                }
                if (done) {
                    message.done(true);
                    this.encoder.reset();
                }
            } else {
                buf.release();
                ctx.write((Object)Unpooled.EMPTY_BUFFER, promise);
            }
            buf = null;
        }
        catch (Throwable t) {
            ctx.fireExceptionCaught(t);
        }
        finally {
            if (buf != null) {
                buf.release();
            }
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (this.encoder.message() == null) {
            LOG.error("exception in encoding, starting", cause);
            cause.printStackTrace();
        } else if (this.encoder.message() != null && !this.encoder.message().isDone()) {
            LOG.error("exception in encoding, started", cause);
            cause.printStackTrace();
        }
    }
}

