/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.connection;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import net.tomp2p.connection.ChannelCreator;
import net.tomp2p.connection.ConnectionBean;
import net.tomp2p.connection.ConnectionConfiguration;
import net.tomp2p.connection.PeerBean;
import net.tomp2p.connection.PeerConnection;
import net.tomp2p.connection.PeerException;
import net.tomp2p.futures.BaseFutureImpl;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.message.Message;
import net.tomp2p.message.MessageID;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.peers.PeerStatusListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestHandler<K extends FutureResponse>
extends SimpleChannelInboundHandler<Message> {
    private static final Logger LOG = LoggerFactory.getLogger(RequestHandler.class);
    private final K futureResponse;
    private final PeerBean peerBean;
    private final ConnectionBean connectionBean;
    private final Message message;
    private final MessageID sendMessageID;
    private final int idleTCPSeconds;
    private final int idleUDPSeconds;
    private final int connectionTimeoutTCPMillis;

    public RequestHandler(K futureResponse, PeerBean peerBean, ConnectionBean connectionBean, ConnectionConfiguration configuration) {
        this.peerBean = peerBean;
        this.connectionBean = connectionBean;
        this.futureResponse = futureResponse;
        this.message = ((FutureResponse)futureResponse).getRequest();
        this.sendMessageID = new MessageID(this.message);
        this.idleTCPSeconds = configuration.idleTCPSeconds();
        this.idleUDPSeconds = configuration.idleUDPSeconds();
        this.connectionTimeoutTCPMillis = configuration.connectionTimeoutTCPMillis();
    }

    public K futureResponse() {
        return this.futureResponse;
    }

    public PeerBean peerBean() {
        return this.peerBean;
    }

    public ConnectionBean connectionBean() {
        return this.connectionBean;
    }

    public int idleTCPSeconds() {
        return this.idleTCPSeconds;
    }

    public int idleUDPSeconds() {
        return this.idleUDPSeconds;
    }

    public int connectionTimeoutTCPMillis() {
        return this.connectionTimeoutTCPMillis;
    }

    public K sendUDP(ChannelCreator channelCreator) {
        this.connectionBean.sender().sendUDP(this, (FutureResponse)this.futureResponse, this.message, channelCreator, this.idleUDPSeconds, false);
        return this.futureResponse;
    }

    public K fireAndForgetUDP(ChannelCreator channelCreator) {
        this.connectionBean.sender().sendUDP(null, (FutureResponse)this.futureResponse, this.message, channelCreator, 0, false);
        return this.futureResponse;
    }

    public K sendBroadcastUDP(ChannelCreator channelCreator) {
        this.connectionBean.sender().sendUDP(this, (FutureResponse)this.futureResponse, this.message, channelCreator, this.idleUDPSeconds, true);
        return this.futureResponse;
    }

    public K sendTCP(ChannelCreator channelCreator) {
        this.connectionBean.sender().sendTCP(this, (FutureResponse)this.futureResponse, this.message, channelCreator, this.idleTCPSeconds, this.connectionTimeoutTCPMillis, null);
        return this.futureResponse;
    }

    public K sendTCP(PeerConnection peerConnection) {
        this.connectionBean.sender().sendTCP(this, (FutureResponse)this.futureResponse, this.message, null, this.idleTCPSeconds, this.connectionTimeoutTCPMillis, peerConnection);
        return this.futureResponse;
    }

    public K sendTCP(ChannelCreator channelCreator, PeerConnection peerConnection) {
        this.connectionBean.sender().sendTCP(this, (FutureResponse)this.futureResponse, this.message, channelCreator, this.idleTCPSeconds, this.connectionTimeoutTCPMillis, peerConnection);
        return this.futureResponse;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        LOG.debug("Error originating from: {}, cause {}", (Object)((FutureResponse)this.futureResponse).getRequest(), (Object)cause);
        if (((BaseFutureImpl)this.futureResponse).isCompleted()) {
            LOG.warn("Got exception, but ignored (future response completed): {}", (Object)((BaseFutureImpl)this.futureResponse).getFailedReason());
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("exception caugth, but handled properly: " + cause.toString());
            }
            if (cause instanceof PeerException) {
                PeerException pe = (PeerException)cause;
                if (pe.getAbortCause() != PeerException.AbortCause.USER_ABORT) {
                    PeerStatusListener.FailReason reason = pe.getAbortCause() == PeerException.AbortCause.TIMEOUT ? PeerStatusListener.FailReason.Timeout : PeerStatusListener.FailReason.Exception;
                    boolean added = this.peerBean.peerMap().peerFailed(((FutureResponse)this.futureResponse).getRequest().getRecipient(), reason);
                    if (added) {
                        if (LOG.isWarnEnabled()) {
                            LOG.warn("removed from map, cause: " + pe.toString() + " msg: " + this.message);
                        }
                    } else if (LOG.isDebugEnabled()) {
                        LOG.debug(pe.toString() + " msg: " + this.message);
                    }
                } else if (LOG.isWarnEnabled()) {
                    LOG.warn("error in request", cause);
                }
            } else {
                this.peerBean.peerMap().peerFailed(((FutureResponse)this.futureResponse).getRequest().getRecipient(), PeerStatusListener.FailReason.Exception);
            }
        }
        LOG.debug("report failure", cause);
        ((FutureResponse)this.futureResponse).setFailedLater(cause);
        ctx.close();
    }

    protected void channelRead0(ChannelHandlerContext ctx, Message responseMessage) throws Exception {
        MessageID recvMessageID = new MessageID(responseMessage);
        if (responseMessage.getType() == Message.Type.UNKNOWN_ID) {
            String msg = "Message was not delivered successfully, unknow id (peer may be offline): " + this.message;
            this.exceptionCaught(ctx, new PeerException(PeerException.AbortCause.PEER_ABORT, msg));
            return;
        }
        if (responseMessage.getType() == Message.Type.EXCEPTION) {
            String msg = "Message caused an exception on the other side, handle as peer_abort: " + this.message;
            this.exceptionCaught(ctx, new PeerException(PeerException.AbortCause.PEER_ABORT, msg));
            return;
        }
        if (responseMessage.isRequest()) {
            ctx.fireChannelRead((Object)responseMessage);
            return;
        }
        if (!this.sendMessageID.equals(recvMessageID)) {
            String msg = "Message [" + responseMessage + "] sent to the node is not the same as we expect. We sent [" + this.message + "]";
            this.exceptionCaught(ctx, new PeerException(PeerException.AbortCause.PEER_ABORT, msg));
            return;
        }
        if (responseMessage.isOk() || responseMessage.isNotOk()) {
            this.peerBean.peerMap().peerFound(responseMessage.getSender(), null);
        }
        ((FutureResponse)this.futureResponse).progress(responseMessage);
        if (!responseMessage.isDone()) {
            LOG.debug("message is streaming {}", (Object)responseMessage);
            return;
        }
        LOG.debug("perfect: {}", (Object)responseMessage);
        if (this.message.getSender().isRelayed()) {
            PeerAddress sender = this.message.getSender().changePeerSocketAddresses(this.message.getPeerSocketAddresses());
            this.message.setSender(sender);
        }
        if (!this.message.isKeepAlive()) {
            ((FutureResponse)this.futureResponse).setResponseLater(responseMessage);
            ctx.close();
        } else {
            ((FutureResponse)this.futureResponse).setResponse(responseMessage);
        }
    }
}

