/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.p2p;

import net.tomp2p.connection.DefaultConnectionConfiguration;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.BaseFutureListener;
import net.tomp2p.futures.FutureChannelCreator;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.p2p.Peer;
import net.tomp2p.p2p.ResponsibilityListener;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.rpc.PeerExchangeRPC;
import net.tomp2p.storage.TrackerStorage;
import net.tomp2p.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrackerStorageReplication
implements ResponsibilityListener {
    private static final Logger LOG = LoggerFactory.getLogger(TrackerStorageReplication.class);
    private final PeerExchangeRPC peerExchangeRPC;
    private final TrackerStorage trackerStorage;
    private final Peer peer;

    public TrackerStorageReplication(Peer peer, PeerExchangeRPC peerExchangeRPC, TrackerStorage trackerStorage) {
        this.peer = peer;
        this.peerExchangeRPC = peerExchangeRPC;
        this.trackerStorage = trackerStorage;
    }

    @Override
    public void meResponsible(Number160 locationKey) {
    }

    @Override
    public void otherResponsible(Number160 locationKey, PeerAddress other, boolean delayed) {
        LOG.debug("other peer became responsibel and we thought we were responsible, so move the data to this peer");
        this.peerExchange(locationKey, other);
    }

    @Override
    public void meResponsible(Number160 locationKey, PeerAddress newPeer) {
        LOG.debug("I'm responsible and a new peer joined");
        this.peerExchange(locationKey, newPeer);
    }

    private void peerExchange(final Number160 locationKey, final PeerAddress newPeer) {
        for (final Number160 domainKey : this.trackerStorage.responsibleDomains(locationKey)) {
            FutureChannelCreator futureChannelCreator = this.peer.getConnectionBean().reservation().create(1, 0);
            futureChannelCreator.addListener((BaseFutureListener<BaseFuture>)new BaseFutureAdapter<FutureChannelCreator>(){

                @Override
                public void operationComplete(FutureChannelCreator future) throws Exception {
                    if (future.isSuccess()) {
                        FutureResponse futureResponse = TrackerStorageReplication.this.peerExchangeRPC.peerExchange(newPeer, locationKey, domainKey, true, future.getChannelCreator(), new DefaultConnectionConfiguration());
                        Utils.addReleaseListener(future.getChannelCreator(), futureResponse);
                        TrackerStorageReplication.this.peer.notifyAutomaticFutures(futureResponse);
                    } else {
                        LOG.error("otherResponsible failed {}", (Object)future.getFailedReason());
                    }
                }
            });
        }
    }
}

