/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.futures;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.concurrent.CountDownLatch;
import net.tomp2p.connection.ProgresHandler;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureImpl;
import net.tomp2p.futures.FutureSuccessEvaluator;
import net.tomp2p.futures.FutureSuccessEvaluatorCommunication;
import net.tomp2p.futures.ProgressListener;
import net.tomp2p.message.Message;

public class FutureResponse
extends BaseFutureImpl<FutureResponse> {
    private final Message requestMessage;
    private final FutureSuccessEvaluator futureSuccessEvaluator;
    private Message responseMessage;
    private ProgresHandler progressHandler;
    private final ProgressListener progressListener;
    private final CountDownLatch firstProgressHandler = new CountDownLatch(1);
    private final CountDownLatch secondProgressHandler = new CountDownLatch(1);
    private boolean reponseLater = false;

    public FutureResponse(Message requestMessage) {
        this(requestMessage, new FutureSuccessEvaluatorCommunication());
    }

    public FutureResponse(Message requestMessage, FutureSuccessEvaluator futureSuccessEvaluator) {
        this(requestMessage, futureSuccessEvaluator, null);
    }

    public FutureResponse(Message requestMessage, ProgressListener progressListener) {
        this(requestMessage, new FutureSuccessEvaluatorCommunication(), progressListener);
    }

    public FutureResponse(Message requestMessage, FutureSuccessEvaluator futureSuccessEvaluator, ProgressListener progressListener) {
        this.requestMessage = requestMessage;
        this.futureSuccessEvaluator = futureSuccessEvaluator;
        this.progressListener = progressListener;
        this.self(this);
    }

    public FutureResponse setResponse() {
        return this.setResponse(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FutureResponse setResponse(Message responseMessage) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.setCompletedAndNotify()) {
                return this;
            }
            if (responseMessage != null) {
                this.responseMessage = responseMessage;
                this.type = this.futureSuccessEvaluator.evaluate(this.requestMessage, responseMessage);
                this.reason = responseMessage.getType().toString();
            } else {
                this.type = BaseFuture.FutureType.OK;
                this.reason = "Nothing to deliver...";
            }
        }
        this.notifyListeners();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setResponseLater(Message responseMessage) {
        Object object = this.lock;
        synchronized (object) {
            if (this.completed) {
                return false;
            }
            this.reponseLater = true;
            if (responseMessage != null) {
                this.responseMessage = responseMessage;
                this.type = this.futureSuccessEvaluator.evaluate(this.requestMessage, responseMessage);
                this.reason = responseMessage.getType().toString();
            } else {
                this.type = BaseFuture.FutureType.OK;
                this.reason = "Nothing to deliver...";
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setFailedLater(Throwable cause) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        cause.printStackTrace(printWriter);
        Object object = this.lock;
        synchronized (object) {
            if (this.completed) {
                return false;
            }
            this.reponseLater = true;
            this.reason = stringWriter.toString();
            this.type = BaseFuture.FutureType.FAILED;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FutureResponse setResponseNow() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.reponseLater && !this.completed) {
                this.setFailed("No future set beforehand, probably an early shutdown, or use setFailedLater() or setResponseLater()");
                return this;
            }
            if (!super.setCompletedAndNotify()) {
                return this;
            }
        }
        this.notifyListeners();
        return this;
    }

    @Override
    protected boolean setCompletedAndNotify() {
        if (this.reponseLater) {
            return false;
        }
        return super.setCompletedAndNotify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message getResponse() {
        Object object = this.lock;
        synchronized (object) {
            return this.responseMessage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message getRequest() {
        Object object = this.lock;
        synchronized (object) {
            return this.requestMessage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FutureResponse setProgressHandler(ProgresHandler progressHandler) {
        Object object = this.lock;
        synchronized (object) {
            this.progressHandler = progressHandler;
        }
        this.firstProgressHandler.countDown();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FutureResponse progressFirst() throws InterruptedException {
        this.firstProgressHandler.await();
        Object object = this.lock;
        synchronized (object) {
            this.progressHandler.progres();
        }
        this.secondProgressHandler.countDown();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FutureResponse progress() throws InterruptedException {
        this.secondProgressHandler.await();
        Object object = this.lock;
        synchronized (object) {
            this.progressHandler.progres();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void progress(Message interMediateMessage) {
        Object object = this.lock;
        synchronized (object) {
            if (this.progressListener != null) {
                this.progressListener.progress(interMediateMessage);
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("future response state:");
        sb.append(",type:").append(this.type.name()).append(",msg:").append(this.requestMessage.getCommand()).append(",reason:").append(this.reason);
        return sb.toString();
    }
}

