/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.p2p;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Random;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReferenceArray;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.futures.FutureRouting;
import net.tomp2p.p2p.builder.RoutingBuilder;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.peers.PeerFilter;
import net.tomp2p.rpc.DigestInfo;
import net.tomp2p.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoutingMechanism {
    private static final Logger LOG = LoggerFactory.getLogger(RoutingMechanism.class);
    private final AtomicReferenceArray<FutureResponse> futureResponses;
    private final FutureRouting futureRoutingResponse;
    private final Collection<PeerFilter> peerFilters;
    private NavigableSet<PeerAddress> queueToAsk;
    private SortedSet<PeerAddress> alreadyAsked;
    private SortedMap<PeerAddress, DigestInfo> directHits;
    private NavigableSet<PeerAddress> potentialHits;
    private int nrNoNewInfo = 0;
    private int nrFailures = 0;
    private int nrSuccess = 0;
    private int maxDirectHits;
    private int maxNoNewInfo;
    private int maxFailures;
    private int maxSucess;
    private boolean stopCreatingNewFutures;

    public RoutingMechanism(AtomicReferenceArray<FutureResponse> futureResponses, FutureRouting futureRoutingResponse, Collection<PeerFilter> peerFilters) {
        this.futureResponses = futureResponses;
        this.futureRoutingResponse = futureRoutingResponse;
        this.peerFilters = peerFilters;
    }

    public FutureRouting futureRoutingResponse() {
        return this.futureRoutingResponse;
    }

    public int parallel() {
        return this.futureResponses.length();
    }

    public boolean isStopCreatingNewFutures() {
        return this.stopCreatingNewFutures;
    }

    public FutureResponse futureResponse(int i) {
        return this.futureResponses.get(i);
    }

    public FutureResponse futureResponse(int i, FutureResponse futureResponse) {
        return this.futureResponses.getAndSet(i, futureResponse);
    }

    public RoutingMechanism queueToAsk(NavigableSet<PeerAddress> queueToAsk) {
        this.queueToAsk = queueToAsk;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NavigableSet<PeerAddress> queueToAsk() {
        RoutingMechanism routingMechanism = this;
        synchronized (routingMechanism) {
            return this.queueToAsk;
        }
    }

    public RoutingMechanism alreadyAsked(SortedSet<PeerAddress> alreadyAsked) {
        this.alreadyAsked = alreadyAsked;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedSet<PeerAddress> alreadyAsked() {
        RoutingMechanism routingMechanism = this;
        synchronized (routingMechanism) {
            return this.alreadyAsked;
        }
    }

    public RoutingMechanism potentialHits(NavigableSet<PeerAddress> potentialHits) {
        this.potentialHits = potentialHits;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NavigableSet<PeerAddress> potentialHits() {
        RoutingMechanism routingMechanism = this;
        synchronized (routingMechanism) {
            return this.potentialHits;
        }
    }

    public RoutingMechanism directHits(SortedMap<PeerAddress, DigestInfo> directHits) {
        this.directHits = directHits;
        return this;
    }

    public SortedMap<PeerAddress, DigestInfo> directHits() {
        return this.directHits;
    }

    public int getMaxDirectHits() {
        return this.maxDirectHits;
    }

    public void setMaxDirectHits(int maxDirectHits) {
        this.maxDirectHits = maxDirectHits;
    }

    public int getMaxNoNewInfo() {
        return this.maxNoNewInfo;
    }

    public void setMaxNoNewInfo(int maxNoNewInfo) {
        this.maxNoNewInfo = maxNoNewInfo;
    }

    public int getMaxFailures() {
        return this.maxFailures;
    }

    public void setMaxFailures(int maxFailures) {
        this.maxFailures = maxFailures;
    }

    public int getMaxSucess() {
        return this.maxSucess;
    }

    public void setMaxSucess(int maxSucess) {
        this.maxSucess = maxSucess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PeerAddress pollFirstInQueueToAsk() {
        RoutingMechanism routingMechanism = this;
        synchronized (routingMechanism) {
            return this.queueToAsk.pollFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PeerAddress pollRandomInQueueToAsk(Random rnd) {
        RoutingMechanism routingMechanism = this;
        synchronized (routingMechanism) {
            return Utils.pollRandom(this.queueToAsk(), rnd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToAlreadyAsked(PeerAddress next) {
        RoutingMechanism routingMechanism = this;
        synchronized (routingMechanism) {
            this.alreadyAsked.add(next);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNeighbors(RoutingBuilder builder) {
        RoutingMechanism routingMechanism = this;
        synchronized (routingMechanism) {
            this.futureRoutingResponse.setNeighbors(this.directHits, this.potentialHits, this.alreadyAsked, builder.isBootstrap(), builder.isRoutingToOthers());
        }
    }

    public void cancel() {
        int len = this.futureResponses.length();
        for (int i = 0; i < len; ++i) {
            BaseFuture baseFuture = this.futureResponses.get(i);
            if (baseFuture == null) continue;
            baseFuture.cancel();
        }
    }

    public AtomicReferenceArray<FutureResponse> futureResponses() {
        return this.futureResponses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPotentialHits(PeerAddress remotePeer) {
        RoutingMechanism routingMechanism = this;
        synchronized (routingMechanism) {
            this.potentialHits.add(remotePeer);
        }
    }

    public void stopCreatingNewFutures(boolean stopCreatingNewFutures) {
        this.stopCreatingNewFutures = stopCreatingNewFutures;
    }

    public boolean evaluateFailed() {
        return ++this.nrFailures > this.getMaxFailures();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean evaluateSuccess(PeerAddress remotePeer, DigestInfo digestBean, Collection<PeerAddress> newNeighbors, boolean last, Number160 locationkey) {
        boolean finished;
        RoutingMechanism routingMechanism = this;
        synchronized (routingMechanism) {
            this.filterPeers(newNeighbors, this.alreadyAsked, this.queueToAsk, locationkey);
            if (RoutingMechanism.evaluateDirectHits(remotePeer, this.directHits, digestBean, this.getMaxDirectHits())) {
                LOG.debug("we have enough direct hits {}", this.directHits);
                finished = true;
                this.stopCreatingNewFutures = true;
            } else if (++this.nrSuccess > this.getMaxSucess()) {
                LOG.debug("we have reached max success {}", (Object)this.nrSuccess);
                finished = last;
                this.stopCreatingNewFutures = true;
            } else if (this.evaluateInformation(newNeighbors, this.queueToAsk, this.alreadyAsked, this.getMaxNoNewInfo())) {
                LOG.debug("we have no new information for the {} time", (Object)this.getMaxNoNewInfo());
                finished = last;
                this.stopCreatingNewFutures = true;
            } else {
                finished = false;
                this.stopCreatingNewFutures = false;
            }
        }
        return finished;
    }

    private void filterPeers(Collection<PeerAddress> newNeighbors, SortedSet<PeerAddress> alreadyAsked, NavigableSet<PeerAddress> queueToAsk, Number160 locationkey) {
        if (this.peerFilters == null || this.peerFilters.size() == 0) {
            return;
        }
        ArrayList<PeerAddress> all = new ArrayList<PeerAddress>();
        all.addAll(alreadyAsked);
        all.addAll(queueToAsk);
        Iterator<PeerAddress> iterator = newNeighbors.iterator();
        while (iterator.hasNext()) {
            PeerAddress newNeighbor = iterator.next();
            for (PeerFilter peerFilter : this.peerFilters) {
                if (!peerFilter.reject(newNeighbor, all, locationkey)) continue;
                iterator.remove();
            }
        }
    }

    static boolean evaluateDirectHits(PeerAddress remotePeer, Map<PeerAddress, DigestInfo> directHits, DigestInfo digestBean, int maxDirectHits) {
        if (digestBean.getSize() > 0) {
            directHits.put(remotePeer, digestBean);
            if (directHits.size() >= maxDirectHits) {
                return true;
            }
        }
        return false;
    }

    boolean evaluateInformation(Collection<PeerAddress> newNeighbors, SortedSet<PeerAddress> queueToAsk, Set<PeerAddress> alreadyAsked, int maxNoNewInfo) {
        boolean newInformation = RoutingMechanism.merge(queueToAsk, newNeighbors, alreadyAsked);
        if (newInformation) {
            this.nrNoNewInfo = 0;
            return false;
        }
        return ++this.nrNoNewInfo >= maxNoNewInfo;
    }

    static boolean merge(SortedSet<PeerAddress> queueToAsk, Collection<PeerAddress> newPeers, Collection<PeerAddress> alreadyAsked) {
        TreeSet<PeerAddress> result = new TreeSet<PeerAddress>(queueToAsk.comparator());
        Utils.difference(newPeers, result, alreadyAsked);
        if (result.size() == 0) {
            return false;
        }
        PeerAddress first = (PeerAddress)result.first();
        boolean newInfo = RoutingMechanism.isNew(queueToAsk, first);
        queueToAsk.addAll(result);
        return newInfo;
    }

    private static boolean isNew(SortedSet<PeerAddress> queueToAsk, PeerAddress item) {
        if (queueToAsk.contains(item)) {
            return false;
        }
        SortedSet<PeerAddress> tmp = queueToAsk.headSet(item);
        return tmp.size() == 0;
    }

    public int nrNoNewInfo() {
        return this.nrNoNewInfo;
    }
}

