/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.connection;

import java.util.Random;

public class Ports {
    public static final int MAX_PORT = 65535;
    public static final int MIN_DYN_PORT = 49152;
    public static final int DEFAULT_PORT = 7700;
    private static final int RANGE = 16383;
    private static final Random RND = new Random();
    private final int externalTCPPort;
    private final int externalUDPPort;
    private final boolean randomPorts;

    public Ports() {
        this(0, 0);
    }

    public Ports(int externalTCPPort, int externalUDPPort) {
        if (externalTCPPort < 0 || externalUDPPort < 0) {
            throw new IllegalArgumentException("port needs to be >= 0");
        }
        this.externalTCPPort = externalTCPPort == 0 ? RND.nextInt(16383) + 49152 : externalTCPPort;
        this.externalUDPPort = externalUDPPort == 0 ? RND.nextInt(16383) + 49152 : externalUDPPort;
        this.randomPorts = externalTCPPort == 0 && externalUDPPort == 0;
    }

    public int externalTCPPort() {
        return this.externalTCPPort;
    }

    public int externalUDPPort() {
        return this.externalUDPPort;
    }

    public boolean isSetExternalPortsManually() {
        return !this.randomPorts;
    }
}

