/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.storage;

import java.security.PublicKey;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.Number320;
import net.tomp2p.peers.Number480;
import net.tomp2p.peers.Number640;
import net.tomp2p.rpc.DigestInfo;
import net.tomp2p.rpc.SimpleBloomFilter;
import net.tomp2p.storage.Data;
import net.tomp2p.storage.KeyLock;
import net.tomp2p.storage.Storage;
import net.tomp2p.utils.Pair;
import net.tomp2p.utils.Timings;
import net.tomp2p.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageLayer {
    private static final Logger LOG = LoggerFactory.getLogger(StorageLayer.class);
    private ProtectionMode protectionDomainMode = ProtectionMode.MASTER_PUBLIC_KEY;
    private ProtectionEnable protectionDomainEnable = ProtectionEnable.ALL;
    private ProtectionMode protectionEntryMode = ProtectionMode.MASTER_PUBLIC_KEY;
    private ProtectionEnable protectionEntryEnable = ProtectionEnable.ALL;
    private final Collection<Number160> removedDomains = new HashSet<Number160>();
    private final KeyLock<Storage> dataLock = new KeyLock();
    private final KeyLock<Number160> dataLock160 = new KeyLock();
    private final KeyLock<Number320> dataLock320 = new KeyLock();
    private final KeyLock<Number480> dataLock480 = new KeyLock();
    private final KeyLock<Number640> dataLock640 = new KeyLock();
    private final Storage backend;

    public StorageLayer(Storage backend) {
        this.backend = backend;
    }

    public void setProtection(ProtectionEnable protectionDomainEnable, ProtectionMode protectionDomainMode, ProtectionEnable protectionEntryEnable, ProtectionMode protectionEntryMode) {
        this.setProtectionDomainEnable(protectionDomainEnable);
        this.setProtectionDomainMode(protectionDomainMode);
        this.setProtectionEntryEnable(protectionEntryEnable);
        this.setProtectionEntryMode(protectionEntryMode);
    }

    public void setProtectionDomainMode(ProtectionMode protectionDomainMode) {
        this.protectionDomainMode = protectionDomainMode;
    }

    public ProtectionMode getProtectionDomainMode() {
        return this.protectionDomainMode;
    }

    public void setProtectionDomainEnable(ProtectionEnable protectionDomainEnable) {
        this.protectionDomainEnable = protectionDomainEnable;
    }

    public ProtectionEnable getProtectionDomainEnable() {
        return this.protectionDomainEnable;
    }

    public void setProtectionEntryMode(ProtectionMode protectionEntryMode) {
        this.protectionEntryMode = protectionEntryMode;
    }

    public ProtectionMode getProtectionEntryMode() {
        return this.protectionEntryMode;
    }

    public void setProtectionEntryEnable(ProtectionEnable protectionEntryEnable) {
        this.protectionEntryEnable = protectionEntryEnable;
    }

    public ProtectionEnable getProtectionEntryEnable() {
        return this.protectionEntryEnable;
    }

    public void removeDomainProtection(Number160 removeDomain) {
        this.removedDomains.add(removeDomain);
    }

    boolean isDomainRemoved(Number160 domain) {
        return this.removedDomains.contains(domain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enum<?> put(Number640 key, Data newData, PublicKey publicKey, boolean putIfAbsent, boolean domainProtection) {
        boolean retVal = false;
        KeyLock.RefCounterLock lock = this.dataLock640.lock(key);
        try {
            if (!this.securityDomainCheck(key.locationAndDomainKey(), publicKey, publicKey, domainProtection)) {
                PutStatus putStatus = PutStatus.FAILED_SECURITY;
                return putStatus;
            }
            if (!this.securityEntryCheck(key.locationDomainAndContentKey(), publicKey, newData.publicKey(), newData.isProtectedEntry())) {
                PutStatus putStatus = PutStatus.FAILED_SECURITY;
                return putStatus;
            }
            boolean contains = this.backend.contains(key);
            if (putIfAbsent && contains) {
                PutStatus putStatus = PutStatus.FAILED_NOT_ABSENT;
                return putStatus;
            }
            retVal = this.backend.put(key, newData);
            if (retVal) {
                long expiration = newData.expirationMillis();
                this.backend.addTimeout(key, expiration);
            }
        }
        finally {
            this.dataLock640.unlock(lock);
        }
        return retVal ? PutStatus.OK : PutStatus.FAILED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<Data, Enum<?>> remove(Number640 key, PublicKey publicKey, boolean returnData) {
        KeyLock.RefCounterLock lock = this.dataLock640.lock(key);
        try {
            if (!this.canClaimDomain(key.locationAndDomainKey(), publicKey)) {
                Pair<Object, PutStatus> pair = new Pair<Object, PutStatus>(null, PutStatus.FAILED_SECURITY);
                return pair;
            }
            if (!this.canClaimEntry(key.locationDomainAndContentKey(), publicKey)) {
                Pair<Object, PutStatus> pair = new Pair<Object, PutStatus>(null, PutStatus.FAILED_SECURITY);
                return pair;
            }
            if (!this.backend.contains(key)) {
                Pair<Object, PutStatus> pair = new Pair<Object, PutStatus>(null, PutStatus.NOT_FOUND);
                return pair;
            }
            this.backend.removeTimeout(key);
            this.backend.removeResponsibility(key.getLocationKey());
            Pair pair = new Pair(this.backend.remove(key, returnData), PutStatus.OK);
            return pair;
        }
        finally {
            this.dataLock640.unlock(lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Data get(Number640 key) {
        KeyLock.RefCounterLock lock = this.dataLock640.lock(key);
        try {
            Data data = this.getInternal(key);
            return data;
        }
        finally {
            this.dataLock640.unlock(lock);
        }
    }

    private Data getInternal(Number640 key) {
        return this.backend.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NavigableMap<Number640, Data> get(Number640 from, Number640 to, int limit, boolean ascending) {
        KeyLock.RefCounterLock lock = this.findAndLock(from, to);
        try {
            NavigableMap<Number640, Data> navigableMap = this.backend.subMap(from, to, limit, ascending);
            return navigableMap;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NavigableMap<Number640, Data> get() {
        KeyLock.RefCounterLock lock = this.dataLock.lock(this.backend);
        try {
            NavigableMap<Number640, Data> navigableMap = this.backend.map();
            return navigableMap;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Number640 key) {
        KeyLock.RefCounterLock lock = this.dataLock640.lock(key);
        try {
            boolean bl = this.backend.contains(key);
            return bl;
        }
        finally {
            this.dataLock640.unlock(lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Number640, Data> get(Number640 from, Number640 to, SimpleBloomFilter<Number160> contentBloomFilter, SimpleBloomFilter<Number160> versionBloomFilter, int limit, boolean ascending, boolean isBloomFilterAnd) {
        KeyLock.RefCounterLock lock = this.findAndLock(from, to);
        try {
            NavigableMap<Number640, Data> tmp = this.backend.subMap(from, to, limit, ascending);
            Iterator iterator = tmp.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (isBloomFilterAnd) {
                    if (contentBloomFilter != null && !contentBloomFilter.contains(((Number640)entry.getKey()).getContentKey())) {
                        iterator.remove();
                        continue;
                    }
                    if (versionBloomFilter == null || versionBloomFilter.contains(((Data)entry.getValue()).hash())) continue;
                    iterator.remove();
                    continue;
                }
                if (contentBloomFilter != null && contentBloomFilter.contains(((Number640)entry.getKey()).getContentKey())) {
                    iterator.remove();
                    continue;
                }
                if (versionBloomFilter == null || !versionBloomFilter.contains(((Data)entry.getValue()).hash())) continue;
                iterator.remove();
            }
            NavigableMap<Number640, Data> navigableMap = tmp;
            return navigableMap;
        }
        finally {
            lock.unlock();
        }
    }

    private KeyLock.RefCounterLock findAndLock(Number640 from, Number640 to) {
        if (!from.getLocationKey().equals(to.getLocationKey())) {
            KeyLock.RefCounterLock lock = this.dataLock.lock(this.backend);
            return lock;
        }
        if (!from.getDomainKey().equals(to.getDomainKey())) {
            KeyLock.RefCounterLock lock = this.dataLock160.lock(from.getLocationKey());
            return lock;
        }
        if (!from.getContentKey().equals(to.getContentKey())) {
            KeyLock.RefCounterLock lock = this.dataLock320.lock(from.locationAndDomainKey());
            return lock;
        }
        if (!from.getVersionKey().equals(to.getVersionKey())) {
            KeyLock.RefCounterLock lock = this.dataLock480.lock(from.locationDomainAndContentKey());
            return lock;
        }
        KeyLock.RefCounterLock lock = this.dataLock640.lock(from);
        return lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedMap<Number640, Data> removeReturnData(Number640 from, Number640 to, PublicKey publicKey) {
        KeyLock.RefCounterLock lock = this.findAndLock(from, to);
        try {
            NavigableMap<Number640, Data> tmp = this.backend.subMap(from, to, -1, true);
            for (Number640 key : tmp.keySet()) {
                if (!this.canClaimDomain(key.locationAndDomainKey(), publicKey)) {
                    SortedMap<Number640, Data> sortedMap = null;
                    return sortedMap;
                }
                if (this.canClaimEntry(key.locationDomainAndContentKey(), publicKey)) continue;
                SortedMap<Number640, Data> sortedMap = null;
                return sortedMap;
            }
            NavigableMap<Number640, Data> result = this.backend.remove(from, to, true);
            for (Map.Entry entry : result.entrySet()) {
                Data data = (Data)entry.getValue();
                if (data.publicKey() != null && !data.publicKey().equals(publicKey)) continue;
                this.backend.removeTimeout((Number640)entry.getKey());
                this.backend.removeResponsibility(((Number640)entry.getKey()).getLocationKey());
            }
            NavigableMap<Number640, Data> navigableMap = result;
            return navigableMap;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedMap<Number640, Byte> removeReturnStatus(Number640 from, Number640 to, PublicKey publicKey) {
        KeyLock.RefCounterLock lock = this.findAndLock(from, to);
        try {
            NavigableMap<Number640, Data> tmp = this.backend.subMap(from, to, -1, true);
            TreeMap<Number640, Byte> result = new TreeMap<Number640, Byte>();
            for (Number640 key : tmp.keySet()) {
                Pair<Data, Enum<?>> pair = this.remove(key, publicKey, false);
                result.put(key, (byte)pair.element1().ordinal());
            }
            TreeMap<Number640, Byte> treeMap = result;
            return treeMap;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkTimeout() {
        long time = Timings.currentTimeMillis();
        Collection<Number640> toRemove = this.backend.subMapTimeout(time);
        if (toRemove.size() > 0) {
            for (Number640 key : toRemove) {
                KeyLock.RefCounterLock lock = this.dataLock640.lock(key);
                try {
                    this.backend.remove(key, false);
                    this.backend.removeTimeout(key);
                }
                finally {
                    lock.unlock();
                }
                Number160 locationKey = key.getLocationKey();
                KeyLock.RefCounterLock lock1 = this.dataLock160.lock(locationKey);
                try {
                    if (!this.isEmpty(locationKey)) continue;
                    this.backend.removeResponsibility(locationKey);
                }
                finally {
                    lock1.unlock();
                }
            }
        }
    }

    private boolean isEmpty(Number160 locationKey) {
        Number640 from = new Number640(locationKey, Number160.ZERO, Number160.ZERO, Number160.ZERO);
        Number640 to = new Number640(locationKey, Number160.MAX_VALUE, Number160.MAX_VALUE, Number160.MAX_VALUE);
        NavigableMap<Number640, Data> tmp = this.backend.subMap(from, to, 1, false);
        return tmp.size() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DigestInfo digest(Number640 from, Number640 to, int limit, boolean ascending) {
        DigestInfo digestInfo = new DigestInfo();
        KeyLock.RefCounterLock lock = this.findAndLock(from, to);
        try {
            NavigableMap<Number640, Data> tmp = this.backend.subMap(from, to, limit, ascending);
            for (Map.Entry entry : tmp.entrySet()) {
                Number160 basedOn = ((Data)entry.getValue()).basedOn();
                digestInfo.put((Number640)entry.getKey(), basedOn == null ? Number160.ZERO : basedOn);
            }
            DigestInfo digestInfo2 = digestInfo;
            return digestInfo2;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DigestInfo digest(Number320 locationAndDomainKey, SimpleBloomFilter<Number160> keyBloomFilter, SimpleBloomFilter<Number160> contentBloomFilter, int limit, boolean ascending, boolean isBloomFilterAnd) {
        DigestInfo digestInfo = new DigestInfo();
        KeyLock.RefCounterLock lock = this.dataLock320.lock(locationAndDomainKey);
        try {
            Number640 from = new Number640(locationAndDomainKey, Number160.ZERO, Number160.ZERO);
            Number640 to = new Number640(locationAndDomainKey, Number160.MAX_VALUE, Number160.MAX_VALUE);
            NavigableMap<Number640, Data> tmp = this.backend.subMap(from, to, limit, ascending);
            for (Map.Entry entry : tmp.entrySet()) {
                Number160 basedOn;
                if (isBloomFilterAnd) {
                    if (keyBloomFilter != null && !keyBloomFilter.contains(((Number640)entry.getKey()).getContentKey()) || contentBloomFilter != null && !contentBloomFilter.contains(((Data)entry.getValue()).hash())) continue;
                    basedOn = ((Data)entry.getValue()).basedOn();
                    digestInfo.put((Number640)entry.getKey(), basedOn == null ? Number160.ZERO : basedOn);
                    continue;
                }
                if (keyBloomFilter != null && keyBloomFilter.contains(((Number640)entry.getKey()).getContentKey()) || contentBloomFilter != null && contentBloomFilter.contains(((Data)entry.getValue()).hash())) continue;
                basedOn = ((Data)entry.getValue()).basedOn();
                digestInfo.put((Number640)entry.getKey(), basedOn == null ? Number160.ZERO : basedOn);
            }
            DigestInfo digestInfo2 = digestInfo;
            return digestInfo2;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DigestInfo digest(Collection<Number640> number640s) {
        DigestInfo digestInfo = new DigestInfo();
        for (Number640 number640 : number640s) {
            KeyLock.RefCounterLock lock = this.dataLock640.lock(number640);
            try {
                if (!this.backend.contains(number640)) continue;
                Data data = this.getInternal(number640);
                Number160 basedOn = data.basedOn();
                digestInfo.put(number640, basedOn == null ? Number160.ZERO : basedOn);
            }
            finally {
                lock.unlock();
            }
        }
        return digestInfo;
    }

    private boolean securityDomainCheck(Number320 key, PublicKey publicKey, PublicKey newPublicKey, boolean domainProtection) {
        boolean domainProtectedByOthers = this.backend.isDomainProtectedByOthers(key, publicKey);
        if (!domainProtection) {
            LOG.debug("no domain protection requested {} for domain {}", (Object)Utils.hash(newPublicKey), (Object)key);
            return !domainProtectedByOthers;
        }
        LOG.debug("domain protection requested {} for domain {}", (Object)Utils.hash(newPublicKey), (Object)key);
        if (this.canClaimDomain(key, publicKey)) {
            if (this.canProtectDomain(key.getDomainKey(), publicKey)) {
                LOG.debug("set domain protection");
                return this.backend.protectDomain(key, newPublicKey);
            }
            return true;
        }
        return false;
    }

    private boolean securityEntryCheck(Number480 key, PublicKey publicKeyMessage, PublicKey publicKeyData, boolean entryProtection) {
        boolean entryProtectedByOthers = this.backend.isEntryProtectedByOthers(key, publicKeyMessage);
        if (!entryProtection) {
            return !entryProtectedByOthers;
        }
        if (this.canClaimEntry(key, publicKeyMessage)) {
            if (this.canProtectEntry(key.getDomainKey(), publicKeyMessage)) {
                return this.backend.protectEntry(key, publicKeyData);
            }
            return true;
        }
        return false;
    }

    private boolean foreceOverrideDomain(Number160 domainKey, PublicKey publicKey) {
        if (this.getProtectionDomainMode() == ProtectionMode.MASTER_PUBLIC_KEY && publicKey != null) {
            return StorageLayer.isMine(domainKey, publicKey);
        }
        return false;
    }

    private boolean foreceOverrideEntry(Number160 entryKey, PublicKey publicKey) {
        if (this.getProtectionEntryMode() == ProtectionMode.MASTER_PUBLIC_KEY && publicKey != null && publicKey.getEncoded() != null) {
            return StorageLayer.isMine(entryKey, publicKey);
        }
        return false;
    }

    private boolean canClaimDomain(Number320 key, PublicKey publicKey) {
        boolean domainProtectedByOthers = this.backend.isDomainProtectedByOthers(key, publicKey);
        boolean domainOverridableByMe = this.foreceOverrideDomain(key.getDomainKey(), publicKey);
        return !domainProtectedByOthers || domainOverridableByMe;
    }

    private boolean canClaimEntry(Number480 key, PublicKey publicKey) {
        boolean entryProtectedByOthers = this.backend.isEntryProtectedByOthers(key, publicKey);
        boolean entryOverridableByMe = this.foreceOverrideEntry(key.getContentKey(), publicKey);
        return !entryProtectedByOthers || entryOverridableByMe;
    }

    private boolean canProtectDomain(Number160 domainKey, PublicKey publicKey) {
        if (this.isDomainRemoved(domainKey)) {
            return false;
        }
        if (this.getProtectionDomainEnable() == ProtectionEnable.ALL) {
            return true;
        }
        if (this.getProtectionDomainEnable() == ProtectionEnable.NONE) {
            return this.foreceOverrideDomain(domainKey, publicKey);
        }
        return false;
    }

    private boolean canProtectEntry(Number160 contentKey, PublicKey publicKey) {
        if (this.getProtectionEntryEnable() == ProtectionEnable.ALL) {
            return true;
        }
        if (this.getProtectionEntryEnable() == ProtectionEnable.NONE) {
            return this.foreceOverrideEntry(contentKey, publicKey);
        }
        return false;
    }

    private static boolean isMine(Number160 key, PublicKey publicKey) {
        return key.equals(Utils.makeSHAHash(publicKey.getEncoded()));
    }

    public KeyLock<Storage> getLockStorage() {
        return this.dataLock;
    }

    public KeyLock<Number160> getLockNumber160() {
        return this.dataLock160;
    }

    public KeyLock<Number320> getLockNumber320() {
        return this.dataLock320;
    }

    public KeyLock<Number480> getLockNumber480() {
        return this.dataLock480;
    }

    public Collection<Number160> findContentForResponsiblePeerID(Number160 peerID) {
        return this.backend.findContentForResponsiblePeerID(peerID);
    }

    public void init(ScheduledExecutorService timer, int storageIntervalMillis) {
        timer.scheduleAtFixedRate(new StorageMaintenanceTask(), storageIntervalMillis, storageIntervalMillis, TimeUnit.MILLISECONDS);
    }

    public Enum<?> updateMeta(Number320 locationAndDomainKey, PublicKey publicKey, PublicKey newPublicKey) {
        if (!this.securityDomainCheck(locationAndDomainKey, publicKey, newPublicKey, true)) {
            return PutStatus.FAILED_SECURITY;
        }
        return PutStatus.OK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enum<?> updateMeta(PublicKey publicKey, Number640 key, Data newData) {
        boolean found = false;
        KeyLock.RefCounterLock lock = this.dataLock640.lock(key);
        try {
            if (!this.securityEntryCheck(key.locationDomainAndContentKey(), publicKey, newData.publicKey(), newData.isProtectedEntry())) {
                PutStatus putStatus = PutStatus.FAILED_SECURITY;
                return putStatus;
            }
            Data data = this.backend.get(key);
            boolean changed = false;
            if (data != null && newData.publicKey() != null) {
                data.publicKey(newData.publicKey());
                changed = true;
            }
            if (data != null && newData.isSigned()) {
                data.signature(newData.signature());
                changed = true;
            }
            if (data != null) {
                data.validFromMillis(newData.validFromMillis());
                data.ttlSeconds(newData.ttlSeconds());
                changed = true;
            }
            if (changed) {
                long expiration = data.expirationMillis();
                this.backend.addTimeout(key, expiration);
                found = this.backend.put(key, data);
            }
        }
        finally {
            this.dataLock640.unlock(lock);
        }
        return found ? PutStatus.OK : PutStatus.NOT_FOUND;
    }

    private class StorageMaintenanceTask
    implements Runnable {
        private StorageMaintenanceTask() {
        }

        @Override
        public void run() {
            StorageLayer.this.checkTimeout();
        }
    }

    public static enum PutStatus {
        OK,
        FAILED_NOT_ABSENT,
        FAILED_SECURITY,
        FAILED,
        VERSION_CONFLICT,
        NOT_FOUND;

    }

    public static enum ProtectionMode {
        NO_MASTER,
        MASTER_PUBLIC_KEY;

    }

    public static enum ProtectionEnable {
        ALL,
        NONE;

    }
}

