/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.rpc;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.tomp2p.connection.ChannelCreator;
import net.tomp2p.connection.ConnectionBean;
import net.tomp2p.connection.ConnectionConfiguration;
import net.tomp2p.connection.PeerBean;
import net.tomp2p.connection.PeerConnection;
import net.tomp2p.connection.RequestHandler;
import net.tomp2p.connection.Responder;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.BaseFutureListener;
import net.tomp2p.futures.FutureChannelCreator;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.message.Message;
import net.tomp2p.message.NeighborSet;
import net.tomp2p.p2p.PeerReachable;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.rpc.DispatchHandler;
import net.tomp2p.rpc.RPC;
import net.tomp2p.utils.Timings;
import net.tomp2p.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PingRPC
extends DispatchHandler {
    private static final Logger LOG = LoggerFactory.getLogger(PingRPC.class);
    public static final int WAIT_TIME = 10000;
    private final List<PeerReachable> listeners = new CopyOnWriteArrayList<PeerReachable>();
    private final boolean enable;
    private final boolean wait;

    public PingRPC(PeerBean peerBean, ConnectionBean connectionBean) {
        this(peerBean, connectionBean, true, true, false);
    }

    PingRPC(PeerBean peerBean, ConnectionBean connectionBean, boolean enable, boolean register, boolean wait) {
        super(peerBean, connectionBean);
        this.enable = enable;
        this.wait = wait;
        if (register) {
            connectionBean.dispatcher().registerIoHandler(peerBean.serverPeerAddress().getPeerId(), this, RPC.Commands.PING.getNr());
        }
    }

    public RequestHandler<FutureResponse> ping(PeerAddress remotePeer, ConnectionConfiguration configuration) {
        return this.createHandler(remotePeer, Message.Type.REQUEST_1, configuration);
    }

    public FutureResponse pingUDP(PeerAddress remotePeer, ChannelCreator channelCreator, ConnectionConfiguration configuration) {
        return this.ping(remotePeer, configuration).sendUDP(channelCreator);
    }

    public FutureResponse pingBroadcastUDP(PeerAddress remotePeer, ChannelCreator channelCreator, ConnectionConfiguration configuration) {
        return this.ping(remotePeer, configuration).sendBroadcastUDP(channelCreator);
    }

    public FutureResponse pingTCP(PeerAddress remotePeer, ChannelCreator channelCreator, ConnectionConfiguration configuration) {
        return this.ping(remotePeer, configuration).sendTCP(channelCreator);
    }

    public FutureResponse fireUDP(PeerAddress remotePeer, ChannelCreator channelCreator, ConnectionConfiguration configuration) {
        return this.createHandler(remotePeer, Message.Type.REQUEST_FF_1, configuration).fireAndForgetUDP(channelCreator);
    }

    public FutureResponse fireTCP(PeerAddress remotePeer, ChannelCreator channelCreator, ConnectionConfiguration configuration) {
        return this.createHandler(remotePeer, Message.Type.REQUEST_FF_1, configuration).sendTCP(channelCreator);
    }

    public FutureResponse pingUDPDiscover(PeerAddress remotePeer, ChannelCreator channelCreator, ConnectionConfiguration configuration) {
        FutureResponse futureResponse = this.createDiscoverHandler(remotePeer);
        return new RequestHandler<FutureResponse>(futureResponse, this.peerBean(), this.connectionBean(), configuration).sendUDP(channelCreator);
    }

    public FutureResponse pingTCPDiscover(PeerAddress remotePeer, ChannelCreator channelCreator, ConnectionConfiguration configuration) {
        FutureResponse futureResponse = this.createDiscoverHandler(remotePeer);
        return new RequestHandler<FutureResponse>(futureResponse, this.peerBean(), this.connectionBean(), configuration).sendTCP(channelCreator);
    }

    public FutureResponse pingUDPProbe(PeerAddress remotePeer, ChannelCreator channelCreator, ConnectionConfiguration configuration) {
        Message message = this.createMessage(remotePeer, RPC.Commands.PING.getNr(), Message.Type.REQUEST_3);
        FutureResponse futureResponse = new FutureResponse(message);
        return new RequestHandler<FutureResponse>(futureResponse, this.peerBean(), this.connectionBean(), configuration).sendUDP(channelCreator);
    }

    public FutureResponse pingTCPProbe(PeerAddress remotePeer, ChannelCreator channelCreator, ConnectionConfiguration configuration) {
        Message message = this.createMessage(remotePeer, RPC.Commands.PING.getNr(), Message.Type.REQUEST_3);
        FutureResponse futureResponse = new FutureResponse(message);
        return new RequestHandler<FutureResponse>(futureResponse, this.peerBean(), this.connectionBean(), configuration).sendTCP(channelCreator);
    }

    private RequestHandler<FutureResponse> createHandler(PeerAddress remotePeer, Message.Type type, ConnectionConfiguration configuration) {
        Message message = this.createMessage(remotePeer, RPC.Commands.PING.getNr(), type);
        FutureResponse futureResponse = new FutureResponse(message);
        return new RequestHandler<FutureResponse>(futureResponse, this.peerBean(), this.connectionBean(), configuration);
    }

    private FutureResponse createDiscoverHandler(PeerAddress remotePeer) {
        Message message = this.createMessage(remotePeer, RPC.Commands.PING.getNr(), Message.Type.REQUEST_2);
        message.setNeighborsSet(this.createNeighborSet(this.peerBean().serverPeerAddress()));
        return new FutureResponse(message);
    }

    private NeighborSet createNeighborSet(PeerAddress self) {
        ArrayList<PeerAddress> tmp = new ArrayList<PeerAddress>();
        tmp.add(self);
        return new NeighborSet(-1, tmp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleResponse(final Message message, PeerConnection peerConnection, boolean sign, Responder responder) throws Exception {
        Message responseMessage;
        if (message.getType() != Message.Type.REQUEST_FF_1 && message.getType() != Message.Type.REQUEST_1 && message.getType() != Message.Type.REQUEST_2 && message.getType() != Message.Type.REQUEST_3 || message.getCommand() != RPC.Commands.PING.getNr()) {
            throw new IllegalArgumentException("Message content is wrong");
        }
        if (message.getType() == Message.Type.REQUEST_3) {
            LOG.debug("reply to probing, fire message to {}", (Object)message.getSender());
            responseMessage = this.createResponseMessage(message, Message.Type.OK);
            if (message.isUdp()) {
                this.connectionBean().reservation().create(1, 0).addListener((BaseFutureListener<BaseFuture>)new BaseFutureAdapter<FutureChannelCreator>(){

                    @Override
                    public void operationComplete(FutureChannelCreator future) throws Exception {
                        if (future.isSuccess()) {
                            FutureResponse futureResponse = PingRPC.this.fireUDP(message.getSender(), future.getChannelCreator(), PingRPC.this.connectionBean().channelServer().channelServerConfiguration());
                            Utils.addReleaseListener(future.getChannelCreator(), futureResponse);
                        } else {
                            LOG.warn("handleResponse for REQUEST_3 failed (UDP) {}", (Object)future.getFailedReason());
                        }
                    }
                });
            } else {
                this.connectionBean().reservation().create(0, 1).addListener((BaseFutureListener<BaseFuture>)new BaseFutureAdapter<FutureChannelCreator>(){

                    @Override
                    public void operationComplete(FutureChannelCreator future) throws Exception {
                        if (future.isSuccess()) {
                            FutureResponse futureResponse = PingRPC.this.fireTCP(message.getSender(), future.getChannelCreator(), PingRPC.this.connectionBean().channelServer().channelServerConfiguration());
                            Utils.addReleaseListener(future.getChannelCreator(), futureResponse);
                        } else {
                            LOG.warn("handleResponse for REQUEST_3 failed (TCP) {}", (Object)future.getFailedReason());
                        }
                    }
                });
            }
        } else if (message.getType() == Message.Type.REQUEST_2) {
            LOG.debug("reply to discover, found {}", (Object)message.getSender());
            responseMessage = this.createResponseMessage(message, Message.Type.OK);
            responseMessage.setNeighborsSet(this.createNeighborSet(message.getSender()));
        } else if (message.getType() == Message.Type.REQUEST_1) {
            LOG.debug("reply to regular ping {}", (Object)message.getSender());
            if (message.isUdp() && message.getSender().getPeerId().equals(this.peerBean().serverPeerAddress().getPeerId()) && message.getRecipient().getPeerId().equals(Number160.ZERO)) {
                LOG.warn("don't reply, we are on the same peer, you should not make this call");
                responder.responseFireAndForget();
            }
            if (this.enable) {
                responseMessage = this.createResponseMessage(message, Message.Type.OK);
                if (this.wait) {
                    Timings.sleepUninterruptibly(10000);
                }
            } else {
                responseMessage = null;
                LOG.debug("do not reply");
                if (this.wait) {
                    Timings.sleepUninterruptibly(10000);
                }
            }
        } else {
            PeerAddress serverAddress = this.peerBean().serverPeerAddress();
            if (message.isUdp()) {
                PeerAddress newServerAddress = serverAddress.changeFirewalledUDP(false);
                this.peerBean().serverPeerAddress(newServerAddress);
                List<PeerReachable> list = this.listeners;
                synchronized (list) {
                    for (PeerReachable listener : this.listeners) {
                        listener.peerWellConnected(newServerAddress, message.getSender(), false);
                    }
                }
                responseMessage = message;
            } else {
                PeerAddress newServerAddress = serverAddress.changeFirewalledTCP(false);
                this.peerBean().serverPeerAddress(newServerAddress);
                List<PeerReachable> list = this.listeners;
                synchronized (list) {
                    for (PeerReachable listener : this.listeners) {
                        listener.peerWellConnected(newServerAddress, message.getSender(), true);
                    }
                }
                responseMessage = this.createResponseMessage(message, Message.Type.OK);
            }
        }
        responder.response(responseMessage);
    }

    public void addPeerReachableListener(PeerReachable peerReachable) {
        this.listeners.add(peerReachable);
    }

    public void removePeerReachableListener(PeerReachable peerReachable) {
        this.listeners.remove(peerReachable);
    }
}

