/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.natpmp;

import java.net.InetAddress;
import net.tomp2p.natpmp.Message;
import net.tomp2p.natpmp.MessageQueue;
import net.tomp2p.natpmp.NatPmpException;

public class NatPmpDevice {
    private boolean isShutdown = false;
    private final Object shutdownLock = new Object();
    private MessageQueue messageQueue;

    public NatPmpDevice(InetAddress gateway) throws NatPmpException {
        if (gateway == null) {
            throw new NatPmpException("The network gateway cannot be located.");
        }
        if (!gateway.isSiteLocalAddress()) {
            throw new NatPmpException("The network gateway address is not RFC1918 compliant.");
        }
        this.messageQueue = MessageQueue.createMessageQueue(gateway);
    }

    public void enqueueMessage(Message message) {
        this.messageQueue.enqueueMessage(message);
    }

    public void clearQueue() {
        this.messageQueue.clearQueue();
    }

    public void waitUntilQueueEmpty() {
        this.messageQueue.waitUntilQueueEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.shutdownLock;
        synchronized (object) {
            this.messageQueue.shutdown();
            this.isShutdown = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isShutdown() {
        Object object = this.shutdownLock;
        synchronized (object) {
            return this.isShutdown;
        }
    }
}

