/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.connection;

import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.net.InetAddress;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import net.tomp2p.connection.ChannelClientConfiguration;
import net.tomp2p.connection.ChannelServer;
import net.tomp2p.connection.ChannelServerConficuration;
import net.tomp2p.connection.ConnectionBean;
import net.tomp2p.connection.DiscoverNetworks;
import net.tomp2p.connection.Dispatcher;
import net.tomp2p.connection.NATUtils;
import net.tomp2p.connection.PeerBean;
import net.tomp2p.connection.Reservation;
import net.tomp2p.connection.Sender;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.BaseFutureListener;
import net.tomp2p.futures.FutureDone;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.peers.PeerSocketAddress;
import net.tomp2p.peers.PeerStatusListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeerCreator {
    private static final Logger LOG = LoggerFactory.getLogger(PeerCreator.class);
    private final ConnectionBean connectionBean;
    private final PeerBean peerBean;
    private final List<PeerCreator> childConnections = new ArrayList<PeerCreator>();
    private final EventLoopGroup workerGroup;
    private final EventLoopGroup bossGroup;
    private final boolean master;
    private final FutureDone<Void> futureServerDone = new FutureDone();

    public PeerCreator(int p2pId, Number160 peerId, KeyPair keyPair, ChannelServerConficuration channelServerConficuration, ChannelClientConfiguration channelClientConfiguration, PeerStatusListener[] peerStatusListeners, ScheduledExecutorService timer) throws IOException {
        this.peerBean = new PeerBean(keyPair);
        this.peerBean.peerStatusListeners(peerStatusListeners);
        PeerAddress self = PeerCreator.findPeerAddress(peerId, channelClientConfiguration, channelServerConficuration);
        this.peerBean.serverPeerAddress(self);
        LOG.info("Visible address to other peers: {}", (Object)self);
        this.workerGroup = new NioEventLoopGroup(0, (ThreadFactory)new DefaultThreadFactory("NETTY-TOMP2P - worker-client/server - "));
        this.bossGroup = new NioEventLoopGroup(2, (ThreadFactory)new DefaultThreadFactory("NETTY-TOMP2P - boss - "));
        Dispatcher dispatcher = new Dispatcher(p2pId, this.peerBean, channelServerConficuration.heartBeatMillis());
        ChannelServer channelServer = new ChannelServer(this.bossGroup, this.workerGroup, channelServerConficuration, dispatcher, peerStatusListeners);
        if (!channelServer.startup()) {
            this.shutdownNetty();
            throw new IOException("Cannot bind to TCP or UDP port.");
        }
        Sender sender = new Sender(peerId, peerStatusListeners, channelClientConfiguration, dispatcher);
        NATUtils natUtils = new NATUtils();
        Reservation reservation = new Reservation(this.workerGroup, channelClientConfiguration);
        this.connectionBean = new ConnectionBean(p2pId, dispatcher, sender, channelServer, reservation, channelClientConfiguration, natUtils, timer);
        this.master = true;
    }

    public PeerCreator(PeerCreator parent, Number160 peerId, KeyPair keyPair) {
        parent.childConnections.add(this);
        this.workerGroup = parent.workerGroup;
        this.bossGroup = parent.bossGroup;
        this.connectionBean = parent.connectionBean;
        this.peerBean = new PeerBean(keyPair);
        PeerAddress self = parent.peerBean().serverPeerAddress().changePeerId(peerId);
        this.peerBean.serverPeerAddress(self);
        this.master = false;
    }

    public FutureDone<Void> shutdown() {
        if (this.master) {
            LOG.debug("shutdown in progress...");
        }
        this.connectionBean.dispatcher().removeIoHandler(this.peerBean().serverPeerAddress().getPeerId());
        if (this.peerBean.maintenanceTask() != null) {
            this.peerBean.maintenanceTask().shutdown();
        }
        if (this.peerBean.replicationExecutor() != null) {
            this.peerBean.replicationExecutor().shutdown();
        }
        if (!this.master) {
            for (PeerCreator peerCreator : this.childConnections) {
                peerCreator.shutdown();
            }
            return this.shutdownFuture().setDone();
        }
        this.connectionBean.timer().shutdown();
        LOG.debug("starting shutdown done in client...");
        this.connectionBean.reservation().shutdown().addListener((BaseFutureListener<BaseFuture>)new BaseFutureAdapter<FutureDone<Void>>(){

            @Override
            public void operationComplete(FutureDone<Void> future) throws Exception {
                PeerCreator.this.connectionBean.channelServer().shutdown().addListener((BaseFutureListener<BaseFuture>)new BaseFutureAdapter<FutureDone<Void>>(){

                    @Override
                    public void operationComplete(FutureDone<Void> future) throws Exception {
                        PeerCreator.this.shutdownNetty();
                    }
                });
            }
        });
        this.connectionBean.natUtils().shutdown();
        return this.shutdownFuture();
    }

    private void shutdownNetty() {
        this.workerGroup.shutdownGracefully(0L, 0L, TimeUnit.SECONDS).addListener(new GenericFutureListener(){

            public void operationComplete(Future future) throws Exception {
                LOG.debug("shutdown done in client / workerGroup...");
                PeerCreator.this.bossGroup.shutdownGracefully(0L, 0L, TimeUnit.SECONDS).addListener(new GenericFutureListener(){

                    public void operationComplete(Future future) throws Exception {
                        LOG.debug("shutdown done in client / bossGroup...");
                        PeerCreator.this.shutdownFuture().setDone();
                    }
                });
            }
        });
    }

    public FutureDone<Void> shutdownFuture() {
        return this.futureServerDone;
    }

    public PeerBean peerBean() {
        return this.peerBean;
    }

    public ConnectionBean connectionBean() {
        return this.connectionBean;
    }

    private static PeerAddress findPeerAddress(Number160 peerId, ChannelClientConfiguration channelClientConfiguration, ChannelServerConficuration channelServerConficuration) throws IOException {
        String status = DiscoverNetworks.discoverInterfaces(channelClientConfiguration.externalBindings());
        if (LOG.isInfoEnabled()) {
            LOG.info("Status of external search: " + status);
        }
        if (channelClientConfiguration.externalBindings().foundAddresses().size() == 0) {
            throw new IOException("Not listening to anything. Maybe your binding information is wrong.");
        }
        InetAddress outsideAddress = channelClientConfiguration.externalBindings().foundAddresses().get(0);
        PeerSocketAddress peerSocketAddress = new PeerSocketAddress(outsideAddress, channelServerConficuration.ports().externalTCPPort(), channelServerConficuration.ports().externalUDPPort());
        PeerAddress self = new PeerAddress(peerId, peerSocketAddress, channelServerConficuration.isBehindFirewall(), channelServerConficuration.isBehindFirewall(), false, PeerAddress.EMPTY_PEER_SOCKET_ADDRESSES);
        return self;
    }
}

