/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.connection;

import io.netty.channel.ChannelFuture;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Semaphore;
import net.tomp2p.connection.ChannelCreator;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.BaseFutureListener;
import net.tomp2p.futures.FutureChannelCreator;
import net.tomp2p.futures.FutureDone;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.peers.PeerAddress;

public class PeerConnection {
    public static final int HEART_BEAT_MILLIS = 2000;
    private final Semaphore oneConnection = new Semaphore(1);
    private final PeerAddress remotePeer;
    private final ChannelCreator cc;
    private final Map<FutureChannelCreator, FutureResponse> map = new LinkedHashMap<FutureChannelCreator, FutureResponse>();
    private final FutureDone<Void> closeFuture = new FutureDone();
    private final int heartBeatMillis;
    private volatile ChannelFuture channelFuture;

    public PeerConnection(PeerAddress remotePeer, ChannelCreator cc, int heartBeatMillis) {
        this.remotePeer = remotePeer;
        this.cc = cc;
        this.heartBeatMillis = heartBeatMillis;
    }

    public PeerConnection(PeerAddress remotePeer, ChannelFuture channelFuture, int heartBeatMillis) {
        this.remotePeer = remotePeer;
        this.channelFuture = channelFuture;
        this.addCloseListener(channelFuture);
        this.cc = null;
        this.heartBeatMillis = heartBeatMillis;
    }

    public PeerConnection channelFuture(ChannelFuture channelFuture) {
        this.channelFuture = channelFuture;
        this.addCloseListener(channelFuture);
        return this;
    }

    public int heartBeatMillis() {
        return this.heartBeatMillis;
    }

    public ChannelFuture channelFuture() {
        return this.channelFuture;
    }

    public FutureDone<Void> closeFuture() {
        return this.closeFuture;
    }

    private void addCloseListener(ChannelFuture channelFuture2) {
        this.channelFuture.channel().closeFuture().addListener((GenericFutureListener)new GenericFutureListener<Future<? super Void>>(){

            public void operationComplete(Future<? super Void> arg0) throws Exception {
                PeerConnection.this.closeFuture.setDone();
            }
        });
    }

    public FutureDone<Void> close() {
        if (this.cc != null) {
            FutureDone<Void> future = this.cc.shutdown();
            future.addListener((BaseFutureListener<BaseFuture>)new BaseFutureAdapter<FutureDone<Void>>(){

                @Override
                public void operationComplete(FutureDone<Void> future) throws Exception {
                    PeerConnection.this.closeFuture.setDone();
                }
            });
        } else {
            this.channelFuture.channel().close();
        }
        return this.closeFuture;
    }

    public FutureChannelCreator acquire(FutureResponse futureResponse) {
        FutureChannelCreator futureChannelCreator = new FutureChannelCreator();
        return this.acquire(futureChannelCreator, futureResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FutureChannelCreator acquire(FutureChannelCreator futureChannelCreator, FutureResponse futureResponse) {
        if (this.oneConnection.tryAcquire()) {
            futureResponse.addListener((BaseFutureListener<BaseFuture>)new BaseFutureAdapter<FutureResponse>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void operationComplete(FutureResponse future) throws Exception {
                    PeerConnection.this.oneConnection.release();
                    Map map = PeerConnection.this.map;
                    synchronized (map) {
                        Iterator iterator = PeerConnection.this.map.entrySet().iterator();
                        if (iterator.hasNext()) {
                            Map.Entry entry = iterator.next();
                            iterator.remove();
                            PeerConnection.this.acquire((FutureChannelCreator)entry.getKey(), (FutureResponse)entry.getValue());
                        }
                    }
                }
            });
            futureChannelCreator.reserved(this.cc);
            return futureChannelCreator;
        }
        Map<FutureChannelCreator, FutureResponse> map = this.map;
        synchronized (map) {
            this.map.put(futureChannelCreator, futureResponse);
        }
        return futureChannelCreator;
    }

    public ChannelCreator channelCreator() {
        return this.cc;
    }

    public PeerAddress remotePeer() {
        return this.remotePeer;
    }

    public boolean isOpen() {
        if (this.channelFuture != null) {
            return this.channelFuture.channel().isOpen();
        }
        return false;
    }
}

