/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.storage;

import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.tomp2p.message.TrackerData;
import net.tomp2p.p2p.Maintenance;
import net.tomp2p.p2p.Replication;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.Number320;
import net.tomp2p.peers.Number640;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.peers.PeerStatusListener;
import net.tomp2p.rpc.DigestInfo;
import net.tomp2p.rpc.SimpleBloomFilter;
import net.tomp2p.storage.Data;
import net.tomp2p.storage.Digest;
import net.tomp2p.storage.IdentityManagement;
import net.tomp2p.storage.ReplicationStorage;
import net.tomp2p.storage.StorageMemoryReplication;
import net.tomp2p.utils.ConcurrentCacheMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrackerStorage
implements PeerStatusListener,
Digest,
ReplicationStorage {
    private static final Logger logger = LoggerFactory.getLogger(TrackerStorage.class);
    private static final DigestInfo EMPTY_DIGEST_INFO = new DigestInfo(0);
    public static final int TRACKER_SIZE = 35;
    public static final int TRACKER_CACHE_SIZE = 1000;
    private final ConcurrentMap<Number320, TrackerData> trackerDataActive;
    private final ConcurrentCacheMap<Number320, TrackerData> trackerDataMesh;
    private final ConcurrentCacheMap<Number320, TrackerData> trackerDataSecondary;
    private final ConcurrentCacheMap<Number160, Collection<Number320>> reverseTrackerDataMesh;
    private final ConcurrentCacheMap<Number160, Collection<Number320>> reverseTrackerDataSecondary;
    private final ConcurrentCacheMap<Number160, Collection<Number160>> peerOffline;
    private final IdentityManagement identityManagement;
    private final int trackerTimoutSeconds;
    private final Replication replication;
    private final Maintenance maintenance;
    private boolean fillPrimaryStorageFast = false;
    private int secondaryFactor = 5;
    private int primanyFactor = 1;
    private final StorageMemoryReplication storageMemoryReplication = new StorageMemoryReplication();

    public TrackerStorage(IdentityManagement identityManagement, int trackerTimoutSeconds, Replication replication, Maintenance maintenance) {
        this.trackerTimoutSeconds = trackerTimoutSeconds;
        this.identityManagement = identityManagement;
        this.replication = replication;
        this.maintenance = maintenance;
        this.trackerDataActive = new ConcurrentHashMap<Number320, TrackerData>();
        this.trackerDataMesh = new ConcurrentCacheMap(trackerTimoutSeconds, 1000, true);
        this.trackerDataSecondary = new ConcurrentCacheMap(trackerTimoutSeconds, 1000, true);
        this.reverseTrackerDataMesh = new ConcurrentCacheMap(trackerTimoutSeconds, 1000, true);
        this.reverseTrackerDataSecondary = new ConcurrentCacheMap(trackerTimoutSeconds, 1000, true);
        this.peerOffline = new ConcurrentCacheMap(trackerTimoutSeconds * 5, 1000, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TrackerData activePeers(Number160 locationKey, Number160 domainKey) {
        Number320 keys = new Number320(locationKey, domainKey);
        TrackerData data = (TrackerData)this.trackerDataActive.get(keys);
        if (data == null) {
            return null;
        }
        TrackerData trackerData = data;
        synchronized (trackerData) {
            return new TrackerData(data.getPeerAddresses(), this.identityManagement.getPeerAddress());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TrackerData meshPeers(Number160 locationKey, Number160 domainKey) {
        Number320 keys = new Number320(locationKey, domainKey);
        TrackerData data = this.trackerDataMesh.get(keys);
        if (data == null) {
            return null;
        }
        TrackerData trackerData = data;
        synchronized (trackerData) {
            return new TrackerData(data.getPeerAddresses(), this.identityManagement.getPeerAddress());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TrackerData secondaryPeers(Number160 locationKey, Number160 domainKey) {
        Number320 keys = new Number320(locationKey, domainKey);
        TrackerData data = this.trackerDataSecondary.get(keys);
        if (data == null) {
            return null;
        }
        TrackerData trackerData = data;
        synchronized (trackerData) {
            return new TrackerData(data.getPeerAddresses(), this.identityManagement.getPeerAddress());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addActive(Number160 locationKey, Number160 domainKey, PeerAddress remotePeer, Data attachement) {
        Number320 key = new Number320(locationKey, domainKey);
        TrackerData trackerData = (TrackerData)this.trackerDataActive.get(key);
        if (trackerData == null) {
            trackerData = new TrackerData(new HashMap<PeerAddress, Data>(), this.identityManagement.getPeerAddress());
            this.trackerDataActive.put(key, trackerData);
        }
        TrackerData trackerData2 = trackerData;
        synchronized (trackerData2) {
            trackerData.put(remotePeer, attachement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeActive(Number160 locationKey, Number160 domainKey, Number160 remotePeerId) {
        Map.Entry<PeerAddress, Data> retVal;
        Number320 key = new Number320(locationKey, domainKey);
        TrackerData data = (TrackerData)this.trackerDataActive.get(key);
        if (data == null) {
            return false;
        }
        TrackerData trackerData = data;
        synchronized (trackerData) {
            retVal = data.remove(remotePeerId);
        }
        return retVal != null;
    }

    public boolean put(Number160 locationKey, Number160 domainKey, PeerAddress peerAddress, PublicKey publicKey, Data attachement) {
        Number320 key;
        if (logger.isDebugEnabled()) {
            logger.debug("try to store on tracker " + locationKey);
        }
        Number160 peerId = peerAddress.getPeerId();
        if (this.isOffline(peerAddress)) {
            return false;
        }
        if (!this.identityManagement.checkIdentity(peerId, publicKey)) {
            return false;
        }
        if (this.canStorePrimary(locationKey, domainKey, false) && this.storeData(peerAddress, attachement, peerId, key = new Number320(locationKey, domainKey), this.trackerDataMesh, this.reverseTrackerDataMesh, this.getPrimanyFactor())) {
            if (this.replication != null) {
                this.replication.updateAndNotifyResponsibilities(locationKey);
            }
            return true;
        }
        return false;
    }

    private boolean isOffline(PeerAddress peerAddress) {
        return this.peerOffline.containsKey(peerAddress.getPeerId());
    }

    public boolean putReferred(Number160 locationKey, Number160 domainKey, PeerAddress peerAddress, PeerAddress referrer, Data attachement, ReferrerType type) {
        Number320 key;
        Number160 peerId = peerAddress.getPeerId();
        if (this.canStoreSecondary(locationKey, domainKey) && this.storeData(peerAddress, attachement, peerId, key = new Number320(locationKey, domainKey), this.trackerDataSecondary, this.reverseTrackerDataSecondary, this.getSecondaryFactor())) {
            if (ReferrerType.MESH == type && !this.isSecondaryTracker(locationKey, domainKey)) {
                this.maintenance.addTrackerMaintenance(peerAddress, referrer, locationKey, domainKey, this);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean moveFromSecondaryToMesh(PeerAddress peerAddress, PeerAddress referrer, Number160 locationKey, Number160 domainKey, PublicKey publicKey) {
        Number320 key = new Number320(locationKey, domainKey);
        TrackerData map = this.trackerDataSecondary.get(key);
        if (map == null) {
            return false;
        }
        TrackerData trackerData = map;
        synchronized (trackerData) {
            Map.Entry<PeerAddress, Data> data = map.remove(peerAddress.getPeerId());
            if (data != null) {
                return this.put(locationKey, domainKey, data.getKey(), publicKey, data.getValue());
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean storeData(PeerAddress peerAddress, Data attachement, Number160 peerId, Number320 key, ConcurrentMap<Number320, TrackerData> trackerData, ConcurrentMap<Number160, Collection<Number320>> reverseTrackerData, int factor) {
        TrackerData data = (TrackerData)trackerData.get(key);
        if (data == null) {
            data = new TrackerData(new HashMap<PeerAddress, Data>(), null);
            trackerData.put(key, data);
        }
        TrackerData trackerData2 = data;
        synchronized (trackerData2) {
            if (data.size() > 35 * factor) {
                return false;
            }
            data.put(peerAddress, attachement);
        }
        HashSet<Number320> collection = (HashSet<Number320>)reverseTrackerData.get(peerId);
        if (collection == null) {
            collection = new HashSet<Number320>();
        }
        HashSet<Number320> hashSet = collection;
        synchronized (hashSet) {
            collection.add(key);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean remove(Number160 peerId, ConcurrentMap<Number320, TrackerData> trackerData, ConcurrentMap<Number160, Collection<Number320>> reverseTrackerData) {
        boolean retVal = false;
        Collection collection = (Collection)reverseTrackerData.remove(peerId);
        if (collection == null) {
            return false;
        }
        Collection collection2 = collection;
        synchronized (collection2) {
            for (Number320 key : collection) {
                TrackerData data = (TrackerData)trackerData.get(key);
                if (data == null) continue;
                TrackerData trackerData2 = data;
                synchronized (trackerData2) {
                    if (data.remove(peerId) != null) {
                        retVal = true;
                    }
                    if (data.size() == 0) {
                        trackerData.remove(key);
                    }
                }
            }
        }
        return retVal;
    }

    private boolean canStorePrimary(Number160 locationKey, Number160 domainKey, boolean referred) {
        if (!referred || this.isFillPrimaryStorageFast()) {
            return this.sizePrimary(locationKey, domainKey) <= 35 * this.getPrimanyFactor();
        }
        return false;
    }

    private boolean canStoreSecondary(Number160 locationKey, Number160 domainKey) {
        return this.sizeSecondary(locationKey, domainKey) <= 35 * this.getSecondaryFactor();
    }

    public int sizePrimary(Number160 locationKey, Number160 domainKey) {
        return this.size(locationKey, domainKey, this.trackerDataMesh);
    }

    public int sizeSecondary(Number160 locationKey, Number160 domainKey) {
        return this.size(locationKey, domainKey, this.trackerDataSecondary);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int size(Number160 locationKey, Number160 domainKey, ConcurrentMap<Number320, TrackerData> trackerData) {
        Number320 key = new Number320(locationKey, domainKey);
        TrackerData data = (TrackerData)trackerData.get(key);
        if (data == null) {
            return 0;
        }
        TrackerData trackerData2 = data;
        synchronized (trackerData2) {
            return data.size();
        }
    }

    public void setSecondaryFactor(int secondaryFactor) {
        this.secondaryFactor = secondaryFactor;
    }

    public int getSecondaryFactor() {
        return this.secondaryFactor;
    }

    public void setPrimanyFactor(int primanyFactor) {
        this.primanyFactor = primanyFactor;
    }

    public int getPrimanyFactor() {
        return this.primanyFactor;
    }

    @Override
    public boolean peerFailed(PeerAddress remotePeer, PeerStatusListener.FailReason reason) {
        this.peerOffline(remotePeer.getPeerId(), this.identityManagement.getSelf());
        return true;
    }

    private void peerOffline(Number160 peerId, Number160 referrerId) {
        this.indicateOffline(peerId, referrerId);
        this.remove(peerId, this.trackerDataMesh, this.reverseTrackerDataMesh);
        this.remove(peerId, this.trackerDataSecondary, this.reverseTrackerDataSecondary);
    }

    private void indicateOffline(Number160 peerId, Number160 referrerId) {
        HashSet<Number160> collection = new HashSet<Number160>();
        Collection collection2 = this.peerOffline.putIfAbsent(peerId, collection);
        collection = collection2 == null ? collection : collection2;
        collection.add(referrerId);
    }

    @Override
    public boolean peerFound(PeerAddress remotePeer, PeerAddress referrer) {
        this.peerOffline.remove(remotePeer.getPeerId());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DigestInfo digest(Number160 locationKey, Number160 domainKey) {
        TrackerData data = this.trackerDataMesh.get(new Number320(locationKey, domainKey));
        if (data == null) {
            return EMPTY_DIGEST_INFO;
        }
        TrackerData trackerData = data;
        synchronized (trackerData) {
            return new DigestInfo(data.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DigestInfo digest(Number160 locationKey, Number160 domainKey, Number160 contentKey) {
        if (contentKey == null) {
            return this.digest(locationKey, domainKey);
        }
        TrackerData data = this.trackerDataMesh.get(new Number320(locationKey, domainKey));
        if (data == null) {
            return EMPTY_DIGEST_INFO;
        }
        int counter = 0;
        TrackerData trackerData = data;
        synchronized (trackerData) {
            if (data.containsKey(contentKey)) {
                ++counter;
            }
        }
        return new DigestInfo(counter);
    }

    public void removeReferred(Number160 locationKey, Number160 domainKey, Number160 key, PeerAddress referrer) {
        this.indicateOffline(key, referrer.getPeerId());
    }

    public void setFillPrimaryStorageFast(boolean fillPrimaryStorageFast) {
        this.fillPrimaryStorageFast = fillPrimaryStorageFast;
    }

    public boolean isFillPrimaryStorageFast() {
        return this.fillPrimaryStorageFast;
    }

    public int getTrackerTimoutSeconds() {
        return this.trackerTimoutSeconds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSecondaryTracker(Number160 locationKey, Number160 domainKey) {
        Number320 keys = new Number320(locationKey, domainKey);
        TrackerData data = this.trackerDataMesh.get(keys);
        if (data == null) {
            return false;
        }
        TrackerData trackerData = data;
        synchronized (trackerData) {
            return data.containsKey(this.identityManagement.getSelf());
        }
    }

    public Collection<Number160> responsibleDomains(Number160 locationKey) {
        ArrayList<Number160> retVal = new ArrayList<Number160>();
        for (Number320 number320 : this.trackerDataMesh.keySet()) {
            if (!number320.getLocationKey().equals(locationKey)) continue;
            retVal.add(number320.getDomainKey());
        }
        return retVal;
    }

    @Override
    public Number160 findPeerIDForResponsibleContent(Number160 locationKey) {
        return this.storageMemoryReplication.findPeerIDForResponsibleContent(locationKey);
    }

    @Override
    public Collection<Number160> findContentForResponsiblePeerID(Number160 peerID) {
        return this.storageMemoryReplication.findContentForResponsiblePeerID(peerID);
    }

    @Override
    public boolean updateResponsibilities(Number160 locationKey, Number160 peerId) {
        return this.storageMemoryReplication.updateResponsibilities(locationKey, peerId);
    }

    @Override
    public void removeResponsibility(Number160 locationKey) {
        this.storageMemoryReplication.removeResponsibility(locationKey);
    }

    @Override
    public DigestInfo digest(Number640 from, Number640 to) {
        throw new UnsupportedOperationException("Bloom filters and trackers are not supported");
    }

    @Override
    public DigestInfo digest(Number320 key, SimpleBloomFilter<Number160> keyBloomFilter, SimpleBloomFilter<Number160> contentBloomFilter) {
        throw new UnsupportedOperationException("Bloom filters and trackers are not supported");
    }

    public static enum ReferrerType {
        ACTIVE,
        MESH;

    }
}

