/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.futures;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.BaseFutureImpl;
import net.tomp2p.futures.BaseFutureListener;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.utils.Timings;

public class FutureDiscover
extends BaseFutureImpl<FutureDiscover> {
    private PeerAddress ourPeerAddress;
    private PeerAddress reporter;
    private boolean discoveredTCP = false;
    private boolean discoveredUDP = false;
    private boolean setupRelay = false;

    public FutureDiscover() {
        this.self(this);
    }

    public void setTimeout(ScheduledExecutorService timer, int delaySec) {
        DiscoverTimeoutTask task = new DiscoverTimeoutTask();
        final ScheduledFuture<?> scheduledFuture = timer.schedule(task, TimeUnit.SECONDS.toMillis(delaySec), TimeUnit.MILLISECONDS);
        this.addListener((BaseFutureListener<BaseFuture>)new BaseFutureAdapter<FutureDiscover>(){

            @Override
            public void operationComplete(FutureDiscover future) throws Exception {
                scheduledFuture.cancel(false);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void done(PeerAddress ourPeerAddress, PeerAddress reporter) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.setCompletedAndNotify()) {
                return;
            }
            this.type = BaseFuture.FutureType.OK;
            this.ourPeerAddress = ourPeerAddress;
            this.reporter = reporter;
        }
        this.notifyListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PeerAddress getPeerAddress() {
        Object object = this.lock;
        synchronized (object) {
            return this.ourPeerAddress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PeerAddress getReporter() {
        Object object = this.lock;
        synchronized (object) {
            return this.reporter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDiscoveredTCP() {
        Object object = this.lock;
        synchronized (object) {
            this.discoveredTCP = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDiscoveredUDP() {
        Object object = this.lock;
        synchronized (object) {
            this.discoveredUDP = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDiscoveredTCP() {
        Object object = this.lock;
        synchronized (object) {
            return this.discoveredTCP;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDiscoveredUDP() {
        Object object = this.lock;
        synchronized (object) {
            return this.discoveredUDP;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSetupRealy() {
        Object object = this.lock;
        synchronized (object) {
            return this.setupRelay;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FutureDiscover setFailedRelayPossible(String failed) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.setCompletedAndNotify()) {
                return this;
            }
            this.reason = failed;
            this.type = BaseFuture.FutureType.FAILED;
            this.setupRelay = true;
        }
        this.notifyListeners();
        return this;
    }

    private final class DiscoverTimeoutTask
    implements Runnable {
        private final long start = Timings.currentTimeMillis();

        private DiscoverTimeoutTask() {
        }

        @Override
        public void run() {
            FutureDiscover.this.setFailedRelayPossible("Timeout in Discover: " + (Timings.currentTimeMillis() - this.start) + "ms");
        }
    }
}

