/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.connection;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.DefaultChannelPromise;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.DatagramChannel;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.tomp2p.connection.PeerBean;
import net.tomp2p.connection.PeerConnection;
import net.tomp2p.connection.PeerException;
import net.tomp2p.connection.Responder;
import net.tomp2p.connection.TimeoutFactory;
import net.tomp2p.message.Message;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.Number320;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.peers.PeerStatusListener;
import net.tomp2p.rpc.DispatchHandler;
import net.tomp2p.rpc.RPC;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class Dispatcher
extends SimpleChannelInboundHandler<Message> {
    private static final Logger LOG = LoggerFactory.getLogger(Dispatcher.class);
    private final int p2pID;
    private final PeerBean peerBeanMaster;
    private final int heartBeatMillis;
    private volatile Map<Number320, Map<Integer, DispatchHandler>> ioHandlers = new HashMap<Number320, Map<Integer, DispatchHandler>>();

    public Dispatcher(int p2pID, PeerBean peerBeanMaster, int heartBeatMillis) {
        this.p2pID = p2pID;
        this.peerBeanMaster = peerBeanMaster;
        this.heartBeatMillis = heartBeatMillis;
    }

    public void registerIoHandler(Number160 peerId, Number160 onBehalfOf, DispatchHandler ioHandler, int ... names) {
        HashMap<Number320, Map<Integer, DispatchHandler>> copy = new HashMap<Number320, Map<Integer, DispatchHandler>>(this.ioHandlers);
        HashMap<Integer, DispatchHandler> types = (HashMap<Integer, DispatchHandler>)copy.get(new Number320(peerId, onBehalfOf));
        if (types == null) {
            types = new HashMap<Integer, DispatchHandler>();
            copy.put(new Number320(peerId, onBehalfOf), types);
        }
        int[] arr$ = names;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Integer name = arr$[i$];
            types.put(name, ioHandler);
        }
        this.ioHandlers = Collections.unmodifiableMap(copy);
    }

    public void removeIoHandler(Number160 peerId, Number160 onBehalfOf) {
        HashMap<Number320, Map<Integer, DispatchHandler>> copy = new HashMap<Number320, Map<Integer, DispatchHandler>>(this.ioHandlers);
        copy.remove(new Number320(peerId, onBehalfOf));
        this.ioHandlers = Collections.unmodifiableMap(copy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void channelRead0(ChannelHandlerContext ctx, Message message) throws Exception {
        LOG.debug("received request {} from channel {}", (Object)message, (Object)ctx.channel());
        if (message.version() != this.p2pID) {
            LOG.error("Wrong version. We are looking for {} but we got {}, received: {}", new Object[]{this.p2pID, message.version(), message});
            ctx.close();
            List<PeerStatusListener> list = this.peerBeanMaster.peerStatusListeners();
            synchronized (list) {
                for (PeerStatusListener peerStatusListener : this.peerBeanMaster.peerStatusListeners()) {
                    peerStatusListener.peerFailed(message.sender(), new PeerException(PeerException.AbortCause.PEER_ERROR, "wrong P2P version"));
                }
            }
            return;
        }
        if (!message.isRequest()) {
            LOG.debug("handing message to the next handler {}", (Object)message);
            ctx.fireChannelRead((Object)message);
            return;
        }
        DirectResponder responder = new DirectResponder(ctx, message);
        DispatchHandler myHandler = this.associatedHandler(message);
        if (myHandler != null) {
            boolean isUdp = ctx.channel() instanceof DatagramChannel;
            LOG.debug("about to respond to {}", (Object)message);
            PeerConnection peerConnection = new PeerConnection(message.sender(), (ChannelFuture)new DefaultChannelPromise(ctx.channel()).setSuccess(), this.heartBeatMillis);
            myHandler.forwardMessage(message, isUdp ? null : peerConnection, responder);
        } else {
            if (this.ioHandlers.isEmpty()) {
                LOG.debug("No handler found for {}. Probably we have shutdown this peer.", (Object)message);
            } else {
                Collection<Integer> knownCommands = this.knownCommands();
                if (!knownCommands.contains(message.command())) {
                    StringBuilder sb = new StringBuilder("known cmds");
                    for (Integer integer : this.knownCommands()) {
                        sb.append(", ").append((Object)RPC.Commands.find(integer));
                    }
                    LOG.warn("No handler found for {}. Did you register the RPC command {}? I have {}.", new Object[]{message, RPC.Commands.find(message.command()), sb});
                } else {
                    LOG.debug("No handler found for {}. Probably we have partially shutdown this peer.", (Object)message);
                }
            }
            Message responseMessage = DispatchHandler.createResponseMessage(message, Message.Type.UNKNOWN_ID, this.peerBeanMaster.serverPeerAddress());
            this.response(ctx, responseMessage);
        }
    }

    private Collection<Integer> knownCommands() {
        HashSet<Integer> retVal = new HashSet<Integer>();
        for (Map.Entry<Number320, Map<Integer, DispatchHandler>> entry : this.ioHandlers.entrySet()) {
            retVal.addAll(entry.getValue().keySet());
        }
        return retVal;
    }

    private void response(ChannelHandlerContext ctx, Message response) {
        if (ctx.channel() instanceof DatagramChannel) {
            if (!ctx.channel().isOpen()) {
                LOG.debug("channel UDP is not open, do not reply {}", (Object)response);
                return;
            }
            LOG.debug("reply UDP message {}", (Object)response);
        } else {
            if (!ctx.channel().isActive()) {
                LOG.debug("channel TCP is not open, do not reply {}", (Object)response);
                return;
            }
            LOG.debug("reply TCP message {} to {}", (Object)response, (Object)ctx.channel().remoteAddress());
        }
        ctx.channel().writeAndFlush((Object)response);
    }

    public DispatchHandler associatedHandler(Message message) {
        if (message == null || !message.isRequest()) {
            return null;
        }
        PeerAddress recipient = message.recipient();
        if (recipient.peerId().isZero() && message.command() == RPC.Commands.PING.getNr()) {
            Number160 peerId = this.peerBeanMaster.serverPeerAddress().peerId();
            return this.searchHandler(peerId, peerId, RPC.Commands.PING.getNr());
        }
        DispatchHandler handler = this.searchHandler(recipient.peerId(), recipient.peerId(), message.command());
        if (handler != null) {
            return handler;
        }
        Map<Number320, DispatchHandler> map = this.searchHandler(Integer.valueOf(message.command()));
        for (Map.Entry<Number320, DispatchHandler> entry : map.entrySet()) {
            if (!entry.getKey().domainKey().equals(recipient.peerId())) continue;
            return entry.getValue();
        }
        return null;
    }

    public DispatchHandler searchHandler(Number160 recipientID, Number160 onBehalfOf, int cmd) {
        Integer command = cmd;
        Map<Integer, DispatchHandler> types = this.ioHandlers.get(new Number320(recipientID, onBehalfOf));
        if (types != null && types.containsKey(command)) {
            return types.get(command);
        }
        LOG.debug("Handler not found for type {} we are looking for the server with ID {}", (Object)command, (Object)recipientID);
        return null;
    }

    public Map<Number320, DispatchHandler> searchHandler(Integer command) {
        HashMap<Number320, DispatchHandler> result = new HashMap<Number320, DispatchHandler>();
        for (Map.Entry<Number320, Map<Integer, DispatchHandler>> entry : this.ioHandlers.entrySet()) {
            for (Map.Entry<Integer, DispatchHandler> entry2 : entry.getValue().entrySet()) {
                DispatchHandler handlerh = entry.getValue().get(command);
                if (handlerh == null || !entry2.getKey().equals(command)) continue;
                result.put(entry.getKey(), handlerh);
            }
        }
        return result;
    }

    public Map<Integer, DispatchHandler> searchHandlerMap(Number160 peerId, Number160 onBehalfOf) {
        Map<Integer, DispatchHandler> ioHandlerMap = this.ioHandlers.get(new Number320(peerId, onBehalfOf));
        return ioHandlerMap;
    }

    public class DirectResponder
    implements Responder {
        final ChannelHandlerContext ctx;
        final Message requestMessage;

        DirectResponder(ChannelHandlerContext ctx, Message requestMessage) {
            this.ctx = ctx;
            this.requestMessage = requestMessage;
        }

        @Override
        public void response(Message responseMessage) {
            Dispatcher.this.response(this.ctx, responseMessage);
        }

        @Override
        public void failed(Message.Type type, String reason) {
            Message responseMessage = DispatchHandler.createResponseMessage(this.requestMessage, type, Dispatcher.this.peerBeanMaster.serverPeerAddress());
            Dispatcher.this.response(this.ctx, responseMessage);
        }

        @Override
        public void responseFireAndForget() {
            LOG.debug("The reply handler was a fire-and-forget handler, we don't send any message back! {}", (Object)this.requestMessage);
            if (!(this.ctx.channel() instanceof DatagramChannel)) {
                LOG.warn("There is no TCP fire and forget, use UDP in that case {}", (Object)this.requestMessage);
                throw new RuntimeException("There is no TCP fire and forget, use UDP in that case.");
            }
            TimeoutFactory.removeTimeout(this.ctx);
        }
    }
}

