/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.peers;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;

public class PeerStatatistic
implements Serializable {
    private static final long serialVersionUID = -6225586345726672194L;
    private final AtomicLong lastSeenOnline = new AtomicLong(0L);
    private final long created = System.currentTimeMillis();
    private final AtomicInteger successfullyChecked = new AtomicInteger(0);
    private final AtomicInteger failed = new AtomicInteger(0);
    private final Number160 peerId;
    private PeerAddress peerAddress;

    public PeerStatatistic(PeerAddress peerAddress) {
        if (peerAddress == null) {
            throw new IllegalArgumentException("PeerAddress cannot be null");
        }
        this.peerId = peerAddress.peerId();
        this.peerAddress = peerAddress;
    }

    public int successfullyChecked() {
        this.lastSeenOnline.set(System.currentTimeMillis());
        this.failed.set(0);
        return this.successfullyChecked.incrementAndGet();
    }

    public long lastSeenOnline() {
        return this.lastSeenOnline.get();
    }

    public int successfullyCheckedCounter() {
        return this.successfullyChecked.get();
    }

    public int failed() {
        return this.failed.incrementAndGet();
    }

    public long created() {
        return this.created;
    }

    public int onlineTime() {
        return (int)(this.lastSeenOnline.get() - this.created);
    }

    public PeerAddress peerAddress() {
        return this.peerAddress;
    }

    public PeerAddress peerAddress(PeerAddress peerAddress) {
        if (!this.peerId.equals(peerAddress.peerId())) {
            throw new IllegalArgumentException("can only update the same peer address");
        }
        PeerAddress previousPeerAddress = this.peerAddress;
        this.peerAddress = peerAddress;
        return previousPeerAddress;
    }

    public int hashCode() {
        return this.peerId.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PeerStatatistic)) {
            return false;
        }
        PeerStatatistic p = (PeerStatatistic)obj;
        return p.peerId.equals(this.peerId);
    }
}

