/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.connection;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import net.tomp2p.connection.StandardProtocolFamily;

public class Bindings {
    private final List<InetAddress> addresses = new ArrayList<InetAddress>(1);
    private final List<String> interfaceHints = new ArrayList<String>(1);
    private final List<StandardProtocolFamily> protocolHint = new ArrayList<StandardProtocolFamily>(1);
    private final List<InetAddress> foundBroadcastAddresses = new ArrayList<InetAddress>(1);
    private final List<Inet4Address> foundAddresses4 = new ArrayList<Inet4Address>(1);
    private final List<Inet6Address> foundAddresses6 = new ArrayList<Inet6Address>(1);

    Bindings addFoundAddress(InetAddress address) {
        if (address == null) {
            throw new IllegalArgumentException("Cannot add null");
        }
        if (address instanceof Inet4Address) {
            this.foundAddresses4.add((Inet4Address)address);
        } else if (address instanceof Inet6Address) {
            this.foundAddresses6.add((Inet6Address)address);
        } else {
            throw new IllegalArgumentException("Unknown address family " + address.getClass());
        }
        return this;
    }

    boolean containsAddress(InetAddress address) {
        boolean contains = this.foundAddresses4.contains(address);
        if (contains) {
            return true;
        }
        return this.foundAddresses6.contains(address);
    }

    public List<InetAddress> foundAddresses() {
        ArrayList<InetAddress> listenAddresses2 = new ArrayList<InetAddress>(this.foundAddresses4.size() + this.foundAddresses6.size());
        listenAddresses2.addAll(this.foundAddresses4);
        listenAddresses2.addAll(this.foundAddresses6);
        return listenAddresses2;
    }

    public InetAddress foundAddress() {
        List<InetAddress> addresses = this.foundAddresses();
        if (addresses.isEmpty()) {
            return null;
        }
        return addresses.get(0);
    }

    public List<InetAddress> broadcastAddresses() {
        return this.foundBroadcastAddresses;
    }

    public Bindings addAddress(InetAddress address) {
        this.addresses.add(address);
        return this;
    }

    public List<InetAddress> addresses() {
        return this.addresses;
    }

    public Bindings addInterface(String interfaceHint) {
        if (interfaceHint == null) {
            throw new IllegalArgumentException("Cannot add null");
        }
        this.interfaceHints.add(interfaceHint);
        return this;
    }

    public Bindings addProtocol(StandardProtocolFamily protocolFamily) {
        if (protocolFamily == null) {
            throw new IllegalArgumentException("Cannot add null");
        }
        this.protocolHint.add(protocolFamily);
        return this;
    }

    public List<String> interfaceHints() {
        return this.interfaceHints;
    }

    public List<StandardProtocolFamily> protocolHint() {
        return this.protocolHint;
    }

    public void clear() {
        this.interfaceHints.clear();
        this.addresses.clear();
        this.foundAddresses4.clear();
        this.foundAddresses6.clear();
        this.foundBroadcastAddresses.clear();
    }

    public boolean anyAddresses() {
        return this.addresses.size() == 0;
    }

    public boolean anyInterfaces() {
        return this.interfaceHints.size() == 0;
    }

    public boolean anyProtocols() {
        return this.protocolHint.size() == 0;
    }

    public boolean isIPv4() {
        return this.anyProtocols() || this.protocolHint.contains((Object)StandardProtocolFamily.INET);
    }

    public boolean isIPv6() {
        return this.anyProtocols() || this.protocolHint.contains((Object)StandardProtocolFamily.INET6);
    }

    public boolean isListenAll() {
        return this.anyProtocols() && this.anyInterfaces() && this.anyAddresses();
    }

    public boolean containsInterface(String name) {
        return this.interfaceHints.contains(name);
    }

    public Bindings add(Bindings other) {
        this.foundAddresses4.addAll(other.foundAddresses4);
        this.foundAddresses6.addAll(other.foundAddresses6);
        this.foundBroadcastAddresses.addAll(other.foundBroadcastAddresses);
        return this;
    }

    public SocketAddress wildCardSocket() {
        if (!this.isListenAll()) {
            if (this.foundAddresses4.size() > 0) {
                return new InetSocketAddress(this.foundAddresses4.get(0), 0);
            }
            if (this.foundAddresses6.size() > 0) {
                return new InetSocketAddress(this.foundAddresses6.get(0), 0);
            }
        }
        return new InetSocketAddress(0);
    }
}

