/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.connection;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.util.List;
import net.tomp2p.connection.ChannelCreator;
import net.tomp2p.connection.ConnectionBean;
import net.tomp2p.connection.ConnectionConfiguration;
import net.tomp2p.connection.PeerBean;
import net.tomp2p.connection.PeerConnection;
import net.tomp2p.connection.PeerException;
import net.tomp2p.futures.BaseFutureImpl;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.message.Message;
import net.tomp2p.message.MessageID;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.peers.PeerStatusListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestHandler<K extends FutureResponse>
extends SimpleChannelInboundHandler<Message> {
    private static final Logger LOG = LoggerFactory.getLogger(RequestHandler.class);
    private final K futureResponse;
    private final PeerBean peerBean;
    private final ConnectionBean connectionBean;
    private final Message message;
    private final MessageID sendMessageID;
    private final int idleTCPSeconds;
    private final int idleUDPSeconds;
    private final int connectionTimeoutTCPMillis;

    public RequestHandler(K futureResponse, PeerBean peerBean, ConnectionBean connectionBean, ConnectionConfiguration configuration) {
        this.peerBean = peerBean;
        this.connectionBean = connectionBean;
        this.futureResponse = futureResponse;
        this.message = ((FutureResponse)futureResponse).request();
        this.sendMessageID = new MessageID(this.message);
        this.idleTCPSeconds = configuration.idleTCPSeconds();
        this.idleUDPSeconds = configuration.idleUDPSeconds();
        this.connectionTimeoutTCPMillis = configuration.connectionTimeoutTCPMillis();
    }

    public K futureResponse() {
        return this.futureResponse;
    }

    public PeerBean peerBean() {
        return this.peerBean;
    }

    public ConnectionBean connectionBean() {
        return this.connectionBean;
    }

    public int idleTCPSeconds() {
        return this.idleTCPSeconds;
    }

    public int idleUDPSeconds() {
        return this.idleUDPSeconds;
    }

    public int connectionTimeoutTCPMillis() {
        return this.connectionTimeoutTCPMillis;
    }

    public K sendUDP(ChannelCreator channelCreator) {
        this.connectionBean.sender().sendUDP(this, (FutureResponse)this.futureResponse, this.message, channelCreator, this.idleUDPSeconds, false);
        return this.futureResponse;
    }

    public K fireAndForgetUDP(ChannelCreator channelCreator) {
        this.connectionBean.sender().sendUDP(null, (FutureResponse)this.futureResponse, this.message, channelCreator, 0, false);
        return this.futureResponse;
    }

    public K sendBroadcastUDP(ChannelCreator channelCreator) {
        this.connectionBean.sender().sendUDP(this, (FutureResponse)this.futureResponse, this.message, channelCreator, this.idleUDPSeconds, true);
        return this.futureResponse;
    }

    public K sendTCP(ChannelCreator channelCreator) {
        this.connectionBean.sender().sendTCP(this, (FutureResponse)this.futureResponse, this.message, channelCreator, this.idleTCPSeconds, this.connectionTimeoutTCPMillis, null);
        return this.futureResponse;
    }

    public K sendTCP(PeerConnection peerConnection) {
        this.connectionBean.sender().sendTCP(this, (FutureResponse)this.futureResponse, this.message, null, this.idleTCPSeconds, this.connectionTimeoutTCPMillis, peerConnection);
        return this.futureResponse;
    }

    public K sendTCP(ChannelCreator channelCreator, PeerConnection peerConnection) {
        this.connectionBean.sender().sendTCP(this, (FutureResponse)this.futureResponse, this.message, channelCreator, this.idleTCPSeconds, this.connectionTimeoutTCPMillis, peerConnection);
        return this.futureResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        LOG.debug("Error originating from: {}, cause {}", (Object)((FutureResponse)this.futureResponse).request(), (Object)cause);
        if (((BaseFutureImpl)this.futureResponse).isCompleted()) {
            LOG.warn("Got exception, but ignored (future response completed): {}", (Object)((BaseFutureImpl)this.futureResponse).failedReason());
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("exception caugth, but handled properly: " + cause.toString());
            }
            if (cause instanceof PeerException) {
                PeerException pe = (PeerException)cause;
                if (pe.abortCause() != PeerException.AbortCause.USER_ABORT) {
                    PeerStatusListener.FailReason reason = pe.abortCause() == PeerException.AbortCause.TIMEOUT ? PeerStatusListener.FailReason.Timeout : PeerStatusListener.FailReason.Exception;
                    List<PeerStatusListener> list = this.peerBean.peerStatusListeners();
                    synchronized (list) {
                        for (PeerStatusListener peerStatusListener : this.peerBean.peerStatusListeners()) {
                            peerStatusListener.peerFailed(((FutureResponse)this.futureResponse).request().recipient(), reason);
                        }
                    }
                    LOG.warn("removed from map, cause: {} msg: {}", (Object)pe.toString(), (Object)this.message);
                } else {
                    LOG.warn("error in request", cause);
                }
            } else {
                List<PeerStatusListener> list = this.peerBean.peerStatusListeners();
                synchronized (list) {
                    for (PeerStatusListener peerStatusListener : this.peerBean.peerStatusListeners()) {
                        peerStatusListener.peerFailed(((FutureResponse)this.futureResponse).request().recipient(), PeerStatusListener.FailReason.Exception);
                    }
                }
            }
        }
        LOG.debug("report failure", cause);
        ((FutureResponse)this.futureResponse).failedLater(cause);
        ctx.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void channelRead0(ChannelHandlerContext ctx, Message responseMessage) throws Exception {
        MessageID recvMessageID = new MessageID(responseMessage);
        if (responseMessage.type() == Message.Type.UNKNOWN_ID) {
            String msg = "Message was not delivered successfully, unknow id (peer may be offline or unknown RPC handler): " + this.message;
            this.exceptionCaught(ctx, new PeerException(PeerException.AbortCause.PEER_ABORT, msg));
            return;
        }
        if (responseMessage.type() == Message.Type.EXCEPTION) {
            String msg = "Message caused an exception on the other side, handle as peer_abort: " + this.message;
            this.exceptionCaught(ctx, new PeerException(PeerException.AbortCause.PEER_ABORT, msg));
            return;
        }
        if (responseMessage.isRequest()) {
            ctx.fireChannelRead((Object)responseMessage);
            return;
        }
        if (!this.sendMessageID.equals(recvMessageID)) {
            String msg = "Message [" + responseMessage + "] sent to the node is not the same as we expect. We sent [" + this.message + "]";
            this.exceptionCaught(ctx, new PeerException(PeerException.AbortCause.PEER_ABORT, msg));
            return;
        }
        if (responseMessage.isOk() || responseMessage.isNotOk()) {
            List<PeerStatusListener> msg = this.peerBean.peerStatusListeners();
            synchronized (msg) {
                for (PeerStatusListener peerStatusListener : this.peerBean.peerStatusListeners()) {
                    peerStatusListener.peerFound(responseMessage.sender(), null);
                }
            }
        }
        ((FutureResponse)this.futureResponse).progress(responseMessage);
        if (!responseMessage.isDone()) {
            LOG.debug("good message is streaming {}", (Object)responseMessage);
            return;
        }
        if (this.message.sender().isRelayed()) {
            LOG.debug("good message is relayed {}", (Object)responseMessage);
            PeerAddress sender = this.message.sender().changePeerSocketAddresses(this.message.peerSocketAddresses());
            this.message.sender(sender);
        }
        if (!this.message.isKeepAlive()) {
            LOG.debug("good message, we can close {}, {}", (Object)responseMessage, (Object)ctx.channel());
            ((FutureResponse)this.futureResponse).responseLater(responseMessage);
            ctx.close();
        } else {
            LOG.debug("good message, leave open {}", (Object)responseMessage);
            ((FutureResponse)this.futureResponse).response(responseMessage);
        }
    }
}

