/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.peers;

import java.util.Random;
import net.tomp2p.utils.Utils;

public final class Number160
extends Number
implements Comparable<Number160> {
    private static final long serialVersionUID = -6386562272459272306L;
    public static final int BITS = 160;
    public static final Number160 MAX_VALUE = new Number160(-1, -1, -1, -1, -1);
    private static final long LONG_MASK = 0xFFFFFFFFL;
    private static final int BYTE_MASK = 255;
    private static final int CHAR_MASK = 15;
    private static final int STRING_LENGTH = 42;
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    public static final int INT_ARRAY_SIZE = 5;
    public static final int BYTE_ARRAY_SIZE = 20;
    public static final int CHARS_PER_INT = 8;
    private final int[] val;
    public static final Number160 ZERO = new Number160(0);
    public static final Number160 ONE = new Number160(1);

    public Number160() {
        this.val = new int[5];
    }

    public Number160(int ... val) {
        if (val.length > 5) {
            throw new IllegalArgumentException("Can only deal with arrays of smaller or equal 5. Your array has " + val.length);
        }
        this.val = new int[5];
        int len = val.length;
        int i = len - 1;
        int j = 4;
        while (i >= 0) {
            this.val[j] = val[i];
            --i;
            --j;
        }
    }

    public Number160(String val) {
        if (val.length() > 42) {
            throw new IllegalArgumentException("Can only deal with strings of size smaller or equal than 42. Your string has " + val.length());
        }
        if (val.indexOf("0x") != 0) {
            throw new IllegalArgumentException(val + " is not in hexadecimal form. Decimal form is not supported yet");
        }
        this.val = new int[5];
        char[] tmp = val.toCharArray();
        int len = tmp.length;
        int i = 42 - len;
        int j = 2;
        while (i < 40) {
            int n = i >> 3;
            this.val[n] = this.val[n] << 4;
            int digit = Character.digit(tmp[j], 16);
            if (digit < 0) {
                throw new RuntimeException("Not a hexadecimal number \"" + tmp[j] + "\". The range is [0-9a-f]");
            }
            int n2 = i >> 3;
            this.val[n2] = this.val[n2] + (digit & 0xF);
            ++i;
            ++j;
        }
    }

    public Number160(int val) {
        this.val = new int[5];
        this.val[4] = val;
    }

    public Number160(long val) {
        this.val = new int[5];
        this.val[4] = (int)val;
        this.val[3] = (int)(val >> 32);
    }

    public Number160(byte[] val) {
        this(val, 0, val.length);
    }

    public Number160(byte[] val, int offset, int length) {
        if (length > 20) {
            throw new IllegalArgumentException("Can only deal with byte arrays of size smaller or equal than 20. Your array has " + length);
        }
        this.val = new int[5];
        int i = length + offset - 1;
        int j = 19;
        int k = 0;
        while (i >= offset) {
            int n = j >> 2;
            this.val[n] = this.val[n] | (val[i] & 0xFF) << (k % 4 << 3);
            --i;
            --j;
            ++k;
        }
    }

    public Number160(Random random) {
        this.val = new int[5];
        for (int i = 0; i < 5; ++i) {
            this.val[i] = random.nextInt();
        }
    }

    public Number160(long timestamp, Number160 number96) {
        this.val = new int[5];
        this.val[0] = (int)(timestamp >> 32);
        this.val[1] = (int)timestamp;
        this.val[2] = number96.val[2];
        this.val[3] = number96.val[3];
        this.val[4] = number96.val[4];
    }

    public long timestamp() {
        return (((long)this.val[0] & 0xFFFFFFFFL) << 32) + ((long)this.val[1] & 0xFFFFFFFFL);
    }

    public Number160 number96() {
        return new Number160(0, 0, this.val[2], this.val[3], this.val[4]);
    }

    public Number160 xor(Number160 key) {
        int[] result = new int[5];
        for (int i = 0; i < 5; ++i) {
            result[i] = this.val[i] ^ key.val[i];
        }
        return new Number160(result);
    }

    public int[] toIntArray() {
        int[] retVal = new int[5];
        for (int i = 0; i < 5; ++i) {
            retVal[i] = this.val[i];
        }
        return retVal;
    }

    public int toByteArray(byte[] me, int offset) {
        if (offset + 20 > me.length) {
            throw new RuntimeException("array too small");
        }
        for (int i = 0; i < 5; ++i) {
            int idx = offset + (i << 2);
            me[idx + 0] = (byte)(this.val[i] >> 24);
            me[idx + 1] = (byte)(this.val[i] >> 16);
            me[idx + 2] = (byte)(this.val[i] >> 8);
            me[idx + 3] = (byte)this.val[i];
        }
        return offset + 20;
    }

    public byte[] toByteArray() {
        byte[] retVal = new byte[20];
        this.toByteArray(retVal, 0);
        return retVal;
    }

    public String toString(boolean removeLeadingZero) {
        boolean removeZero = removeLeadingZero;
        StringBuilder sb = new StringBuilder("0x");
        for (int i = 0; i < 5; ++i) {
            Number160.toHex(this.val[i], removeZero, sb);
            if (!removeZero || this.val[i] == 0) continue;
            removeZero = false;
        }
        return sb.toString();
    }

    public boolean isZero() {
        for (int i = 0; i < 5; ++i) {
            if (this.val[i] == 0) continue;
            return false;
        }
        return true;
    }

    public int bitLength() {
        int bits = 0;
        for (int i = 0; i < 5; ++i) {
            if (this.val[i] == 0) continue;
            bits += 32 - Integer.numberOfLeadingZeros(this.val[i]);
            bits += 32 * (5 - ++i);
            break;
        }
        return bits;
    }

    public String toString() {
        return this.toString(true);
    }

    @Override
    public double doubleValue() {
        double d = 0.0;
        for (int i = 0; i < 5; ++i) {
            d *= 4.294967296E9;
            d += (double)((long)this.val[i] & 0xFFFFFFFFL);
        }
        return d;
    }

    @Override
    public float floatValue() {
        return (float)this.doubleValue();
    }

    @Override
    public int intValue() {
        return this.val[4];
    }

    long unsignedInt(int pos) {
        return (long)this.val[pos] & 0xFFFFFFFFL;
    }

    @Override
    public long longValue() {
        return (((long)this.val[4] & 0xFFFFFFFFL) << 32) + ((long)this.val[3] & 0xFFFFFFFFL);
    }

    @Override
    public int compareTo(Number160 o) {
        for (int i = 0; i < 5; ++i) {
            long b1 = (long)this.val[i] & 0xFFFFFFFFL;
            long b2 = (long)o.val[i] & 0xFFFFFFFFL;
            if (b1 < b2) {
                return -1;
            }
            if (b1 <= b2) continue;
            return 1;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Number160)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        Number160 key = (Number160)obj;
        for (int i = 0; i < 5; ++i) {
            if (key.val[i] == this.val[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 0;
        for (int i = 0; i < 5; ++i) {
            hashCode = (int)((long)(31 * hashCode) + ((long)this.val[i] & 0xFFFFFFFFL));
        }
        return hashCode;
    }

    private static void toHex(int integer2, boolean removeLeadingZero, StringBuilder sb) {
        char[] buf = new char[8];
        int charPos = 8;
        int integer = integer2;
        for (int i = 0; !(i >= 8 || removeLeadingZero && integer == 0); integer >>>= 4, ++i) {
            buf[--charPos] = DIGITS[integer & 0xF];
        }
        sb.append(buf, charPos, 8 - charPos);
    }

    public static Number160 createHash(int integerValue) {
        Random r = new Random(integerValue);
        return new Number160(r);
    }

    public static Number160 createHash(long longValue) {
        Random r = new Random(longValue);
        return new Number160(r);
    }

    public static Number160 createHash(String string) {
        return Utils.makeSHAHash(string);
    }
}

