/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.storage;

import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.Number320;
import net.tomp2p.peers.Number480;
import net.tomp2p.peers.Number640;
import net.tomp2p.storage.Data;
import net.tomp2p.storage.Storage;
import net.tomp2p.storage.StorageMemoryReplication;

public class StorageMemory
implements Storage {
    private final NavigableMap<Number640, Data> dataMap = new ConcurrentSkipListMap<Number640, Data>();
    private final Map<Number640, Long> timeoutMap = new ConcurrentHashMap<Number640, Long>();
    private final ConcurrentSkipListMap<Long, Set<Number640>> timeoutMapRev = new ConcurrentSkipListMap();
    private final Map<Number320, PublicKey> protectedMap = new ConcurrentHashMap<Number320, PublicKey>();
    private final Map<Number480, PublicKey> entryMap = new ConcurrentHashMap<Number480, PublicKey>();
    private final StorageMemoryReplication storageMemoryReplication = new StorageMemoryReplication();

    @Override
    public boolean put(Number640 key, Data value) {
        this.dataMap.put(key, value);
        return true;
    }

    @Override
    public Data get(Number640 key) {
        return (Data)this.dataMap.get(key);
    }

    @Override
    public boolean contains(Number640 key) {
        return this.dataMap.containsKey(key);
    }

    @Override
    public int contains(Number640 fromKey, Number640 toKey) {
        NavigableMap<Number640, Data> tmp = this.dataMap.subMap(fromKey, true, toKey, true);
        return tmp.size();
    }

    @Override
    public Data remove(Number640 key, boolean returnData) {
        return (Data)this.dataMap.remove(key);
    }

    @Override
    public NavigableMap<Number640, Data> remove(Number640 fromKey, Number640 toKey, boolean returnData) {
        NavigableMap<Number640, Data> tmp = this.dataMap.subMap(fromKey, true, toKey, true);
        TreeMap<Number640, Data> copy = new TreeMap<Number640, Data>((SortedMap<Number640, Data>)tmp);
        tmp.clear();
        return copy;
    }

    @Override
    public NavigableMap<Number640, Data> subMap(Number640 fromKey, Number640 toKey, int limit, boolean ascending) {
        NavigableMap<Number640, Data> tmp = this.dataMap.subMap(fromKey, true, toKey, true);
        if (limit < 0) {
            return new TreeMap<Number640, Data>((SortedMap<Number640, Data>)(ascending ? tmp : tmp.descendingMap()));
        }
        TreeMap<Number640, Data> retVal = new TreeMap<Number640, Data>();
        limit = Math.min(limit, tmp.size());
        Iterator iterator = ascending ? tmp.entrySet().iterator() : tmp.descendingMap().entrySet().iterator();
        for (int i = 0; iterator.hasNext() && i < limit; ++i) {
            Map.Entry entry = iterator.next();
            retVal.put((Number640)entry.getKey(), (Data)entry.getValue());
        }
        return retVal;
    }

    @Override
    public NavigableMap<Number640, Data> map() {
        return new TreeMap<Number640, Data>((SortedMap<Number640, Data>)this.dataMap);
    }

    @Override
    public void addTimeout(Number640 key, long expiration) {
        Long oldExpiration = this.timeoutMap.put(key, expiration);
        Set<Number640> tmp = this.putIfAbsent2(expiration, Collections.newSetFromMap(new ConcurrentHashMap()));
        tmp.add(key);
        if (oldExpiration == null) {
            return;
        }
        this.removeRevTimeout(key, oldExpiration);
    }

    @Override
    public void removeTimeout(Number640 key) {
        Long expiration = this.timeoutMap.remove(key);
        if (expiration == null) {
            return;
        }
        this.removeRevTimeout(key, expiration);
    }

    private void removeRevTimeout(Number640 key, Long expiration) {
        Set<Number640> tmp = this.timeoutMapRev.get(expiration);
        if (tmp != null) {
            tmp.remove(key);
            if (tmp.isEmpty()) {
                this.timeoutMapRev.remove(expiration);
            }
        }
    }

    @Override
    public Collection<Number640> subMapTimeout(long to) {
        SortedMap tmp = this.timeoutMapRev.subMap((Object)0L, (Object)to);
        ArrayList<Number640> toRemove = new ArrayList<Number640>();
        for (Set set : tmp.values()) {
            toRemove.addAll(set);
        }
        return toRemove;
    }

    @Override
    public boolean protectDomain(Number320 key, PublicKey publicKey) {
        this.protectedMap.put(key, publicKey);
        return true;
    }

    @Override
    public boolean isDomainProtectedByOthers(Number320 key, PublicKey publicKey) {
        PublicKey other = this.protectedMap.get(key);
        if (other == null) {
            return false;
        }
        return !other.equals(publicKey);
    }

    private Set<Number640> putIfAbsent2(long expiration, Set<Number640> hashSet) {
        Set<Number640> timeouts = this.timeoutMapRev.putIfAbsent(expiration, hashSet);
        return timeouts == null ? hashSet : timeouts;
    }

    @Override
    public Number160 findPeerIDForResponsibleContent(Number160 locationKey) {
        return this.storageMemoryReplication.findPeerIDForResponsibleContent(locationKey);
    }

    @Override
    public Collection<Number160> findContentForResponsiblePeerID(Number160 peerID) {
        return this.storageMemoryReplication.findContentForResponsiblePeerID(peerID);
    }

    @Override
    public boolean updateResponsibilities(Number160 locationKey, Number160 peerId) {
        return this.storageMemoryReplication.updateResponsibilities(locationKey, peerId);
    }

    @Override
    public void removeResponsibility(Number160 locationKey) {
        this.storageMemoryReplication.removeResponsibility(locationKey);
    }

    @Override
    public void close() {
        this.dataMap.clear();
        this.protectedMap.clear();
        this.timeoutMap.clear();
        this.timeoutMapRev.clear();
    }

    @Override
    public boolean protectEntry(Number480 key, PublicKey publicKey) {
        this.entryMap.put(key, publicKey);
        return true;
    }

    @Override
    public boolean isEntryProtectedByOthers(Number480 key, PublicKey publicKey) {
        PublicKey other = this.entryMap.get(key);
        if (other == null) {
            return false;
        }
        return !other.equals(publicKey);
    }
}

