/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.p2p;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.tomp2p.connection.ChannelCreator;
import net.tomp2p.connection.ConnectionBean;
import net.tomp2p.connection.PeerBean;
import net.tomp2p.connection.PeerConnection;
import net.tomp2p.connection.PeerCreator;
import net.tomp2p.connection.Ports;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.BaseFutureListener;
import net.tomp2p.futures.FutureChannelCreator;
import net.tomp2p.futures.FutureDone;
import net.tomp2p.futures.FutureLateJoin;
import net.tomp2p.futures.FuturePeerConnection;
import net.tomp2p.natpmp.NatPmpException;
import net.tomp2p.p2p.AutomaticFuture;
import net.tomp2p.p2p.DistributedHashTable;
import net.tomp2p.p2p.DistributedRouting;
import net.tomp2p.p2p.DistributedTracker;
import net.tomp2p.p2p.Shutdown;
import net.tomp2p.p2p.builder.AddBuilder;
import net.tomp2p.p2p.builder.AddTrackerBuilder;
import net.tomp2p.p2p.builder.BootstrapBuilder;
import net.tomp2p.p2p.builder.BroadcastBuilder;
import net.tomp2p.p2p.builder.DigestBuilder;
import net.tomp2p.p2p.builder.DiscoverBuilder;
import net.tomp2p.p2p.builder.GetBuilder;
import net.tomp2p.p2p.builder.GetTrackerBuilder;
import net.tomp2p.p2p.builder.ParallelRequestBuilder;
import net.tomp2p.p2p.builder.PingBuilder;
import net.tomp2p.p2p.builder.PutBuilder;
import net.tomp2p.p2p.builder.RemoveBuilder;
import net.tomp2p.p2p.builder.SendBuilder;
import net.tomp2p.p2p.builder.SendDirectBuilder;
import net.tomp2p.p2p.builder.ShutdownBuilder;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.rpc.BroadcastRPC;
import net.tomp2p.rpc.DirectDataRPC;
import net.tomp2p.rpc.NeighborRPC;
import net.tomp2p.rpc.ObjectDataReply;
import net.tomp2p.rpc.PeerExchangeRPC;
import net.tomp2p.rpc.PingRPC;
import net.tomp2p.rpc.QuitRPC;
import net.tomp2p.rpc.RawDataReply;
import net.tomp2p.rpc.StorageRPC;
import net.tomp2p.rpc.TrackerRPC;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Peer {
    private static final Logger LOG = LoggerFactory.getLogger(Peer.class);
    private final PeerCreator peerCreator;
    private final Number160 peerId;
    private final int p2pID;
    private DistributedHashTable distributedHashMap;
    private DistributedTracker distributedTracker;
    private DistributedRouting distributedRouting;
    private PingRPC handshakeRCP;
    private StorageRPC storageRPC;
    private NeighborRPC neighborRPC;
    private QuitRPC quitRCP;
    private PeerExchangeRPC peerExchangeRPC;
    private DirectDataRPC directDataRPC;
    private TrackerRPC trackerRPC;
    private BroadcastRPC broadcastRPC;
    private boolean shutdown = false;
    private List<AutomaticFuture> automaticFutures = null;
    private List<Shutdown> shutdownListeners = Collections.synchronizedList(new ArrayList());

    Peer(int p2pID, Number160 peerId, PeerCreator peerCreator) {
        this.p2pID = p2pID;
        this.peerId = peerId;
        this.peerCreator = peerCreator;
    }

    PeerCreator peerCreator() {
        return this.peerCreator;
    }

    public PingRPC getHandshakeRPC() {
        if (this.handshakeRCP == null) {
            throw new RuntimeException("Not enabled, please enable this RPC in PeerMaker");
        }
        return this.handshakeRCP;
    }

    public void setHandshakeRPC(PingRPC handshakeRPC) {
        this.handshakeRCP = handshakeRPC;
    }

    public StorageRPC getStoreRPC() {
        if (this.storageRPC == null) {
            throw new RuntimeException("Not enabled, please enable this RPC in PeerMaker");
        }
        return this.storageRPC;
    }

    public void setStorageRPC(StorageRPC storageRPC) {
        this.storageRPC = storageRPC;
    }

    public NeighborRPC getNeighborRPC() {
        if (this.neighborRPC == null) {
            throw new RuntimeException("Not enabled, please enable this RPC in PeerMaker");
        }
        return this.neighborRPC;
    }

    public void setNeighborRPC(NeighborRPC neighborRPC) {
        this.neighborRPC = neighborRPC;
    }

    public QuitRPC getQuitRPC() {
        if (this.quitRCP == null) {
            throw new RuntimeException("Not enabled, please enable this RPC in PeerMaker");
        }
        return this.quitRCP;
    }

    public void setQuitRPC(QuitRPC quitRCP) {
        this.quitRCP = quitRCP;
    }

    public PeerExchangeRPC getPeerExchangeRPC() {
        if (this.peerExchangeRPC == null) {
            throw new RuntimeException("Not enabled, please enable this RPC in PeerMaker");
        }
        return this.peerExchangeRPC;
    }

    public void setPeerExchangeRPC(PeerExchangeRPC peerExchangeRPC) {
        this.peerExchangeRPC = peerExchangeRPC;
    }

    public DirectDataRPC getDirectDataRPC() {
        if (this.directDataRPC == null) {
            throw new RuntimeException("Not enabled, please enable this RPC in PeerMaker");
        }
        return this.directDataRPC;
    }

    public void setDirectDataRPC(DirectDataRPC directDataRPC) {
        this.directDataRPC = directDataRPC;
    }

    public TrackerRPC getTrackerRPC() {
        if (this.trackerRPC == null) {
            throw new RuntimeException("Not enabled, please enable this RPC in PeerMaker");
        }
        return this.trackerRPC;
    }

    public void setTrackerRPC(TrackerRPC trackerRPC) {
        this.trackerRPC = trackerRPC;
    }

    public void setBroadcastRPC(BroadcastRPC broadcastRPC) {
        this.broadcastRPC = broadcastRPC;
    }

    public BroadcastRPC getBroadcastRPC() {
        if (this.broadcastRPC == null) {
            throw new RuntimeException("Not enabled, please enable this RPC in PeerMaker");
        }
        return this.broadcastRPC;
    }

    public DistributedRouting getDistributedRouting() {
        if (this.distributedRouting == null) {
            throw new RuntimeException("Not enabled, please enable this P2P function in PeerMaker");
        }
        return this.distributedRouting;
    }

    public void setDistributedRouting(DistributedRouting distributedRouting) {
        this.distributedRouting = distributedRouting;
    }

    public DistributedHashTable getDistributedHashMap() {
        if (this.distributedHashMap == null) {
            throw new RuntimeException("Not enabled, please enable this P2P function in PeerMaker");
        }
        return this.distributedHashMap;
    }

    public void setDistributedHashMap(DistributedHashTable distributedHashMap) {
        this.distributedHashMap = distributedHashMap;
    }

    public DistributedTracker getDistributedTracker() {
        if (this.distributedTracker == null) {
            throw new RuntimeException("Not enabled, please enable this P2P function in PeerMaker");
        }
        return this.distributedTracker;
    }

    public void setDistributedTracker(DistributedTracker distributedTracker) {
        this.distributedTracker = distributedTracker;
    }

    public PeerBean getPeerBean() {
        return this.peerCreator.peerBean();
    }

    public ConnectionBean getConnectionBean() {
        return this.peerCreator.connectionBean();
    }

    public Number160 getPeerID() {
        return this.peerId;
    }

    public int getP2PID() {
        return this.p2pID;
    }

    public PeerAddress getPeerAddress() {
        return this.getPeerBean().serverPeerAddress();
    }

    Peer setAutomaticFutures(List<AutomaticFuture> automaticFutures) {
        this.automaticFutures = Collections.unmodifiableList(automaticFutures);
        return this;
    }

    public Peer notifyAutomaticFutures(BaseFuture future) {
        if (this.automaticFutures != null) {
            for (AutomaticFuture automaticFuture : this.automaticFutures) {
                automaticFuture.futureCreated(future);
            }
        }
        return this;
    }

    public void setRawDataReply(RawDataReply rawDataReply) {
        this.getDirectDataRPC().setReply(rawDataReply);
    }

    public void setObjectDataReply(ObjectDataReply objectDataReply) {
        this.getDirectDataRPC().setReply(objectDataReply);
    }

    public FuturePeerConnection createPeerConnection(PeerAddress destination) {
        return this.createPeerConnection(destination, 2000);
    }

    public FuturePeerConnection createPeerConnection(final PeerAddress destination, final int heartBeatMillis) {
        final FuturePeerConnection futureDone = new FuturePeerConnection(destination);
        final FutureChannelCreator fcc = this.getConnectionBean().reservation().createPermanent(1);
        fcc.addListener((BaseFutureListener<BaseFuture>)new BaseFutureAdapter<FutureChannelCreator>(){

            @Override
            public void operationComplete(FutureChannelCreator future) throws Exception {
                if (future.isSuccess()) {
                    ChannelCreator cc = fcc.getChannelCreator();
                    PeerConnection peerConnection = new PeerConnection(destination, cc, heartBeatMillis);
                    futureDone.setDone(peerConnection);
                } else {
                    futureDone.setFailed(future);
                }
            }
        });
        return futureDone;
    }

    public Ports setupPortForwanding(String internalHost) {
        boolean success;
        Ports ports;
        block8: {
            ports = new Ports();
            try {
                success = this.getConnectionBean().natUtils().mapUPNP(internalHost, this.getPeerAddress().tcpPort(), this.getPeerAddress().udpPort(), ports.externalUDPPort(), ports.externalTCPPort());
            }
            catch (IOException e) {
                success = false;
            }
            if (!success) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn("cannot find UPNP devices");
                }
                try {
                    success = this.getConnectionBean().natUtils().mapPMP(this.getPeerAddress().tcpPort(), this.getPeerAddress().udpPort(), ports.externalUDPPort(), ports.externalTCPPort());
                    if (!success && LOG.isWarnEnabled()) {
                        LOG.warn("cannot find NAT-PMP devices");
                    }
                }
                catch (NatPmpException e1) {
                    if (!LOG.isWarnEnabled()) break block8;
                    LOG.warn("cannot find NAT-PMP devices ", (Throwable)e1);
                }
            }
        }
        if (success) {
            return ports;
        }
        return null;
    }

    public AddBuilder add(Number160 locationKey) {
        return new AddBuilder(this, locationKey);
    }

    public PutBuilder put(Number160 locationKey) {
        return new PutBuilder(this, locationKey);
    }

    public GetBuilder get(Number160 locationKey) {
        return new GetBuilder(this, locationKey);
    }

    public DigestBuilder digest(Number160 locationKey) {
        return new DigestBuilder(this, locationKey);
    }

    public RemoveBuilder remove(Number160 locationKey) {
        return new RemoveBuilder(this, locationKey);
    }

    public SendBuilder send(Number160 locationKey) {
        return new SendBuilder(this, locationKey);
    }

    public SendDirectBuilder sendDirect(PeerAddress recipientAddress) {
        return new SendDirectBuilder(this, recipientAddress);
    }

    public SendDirectBuilder sendDirect(FuturePeerConnection recipientConnection) {
        return new SendDirectBuilder(this, recipientConnection);
    }

    public SendDirectBuilder sendDirect(PeerConnection peerConnection) {
        return new SendDirectBuilder(this, peerConnection);
    }

    public BootstrapBuilder bootstrap() {
        return new BootstrapBuilder(this);
    }

    public PingBuilder ping() {
        return new PingBuilder(this);
    }

    public DiscoverBuilder discover() {
        return new DiscoverBuilder(this);
    }

    public AddTrackerBuilder addTracker(Number160 locationKey) {
        return new AddTrackerBuilder(this, locationKey);
    }

    public GetTrackerBuilder getTracker(Number160 locationKey) {
        return new GetTrackerBuilder(this, locationKey);
    }

    public ParallelRequestBuilder<?> parallelRequest(Number160 locationKey) {
        return new ParallelRequestBuilder(this, locationKey);
    }

    public BroadcastBuilder broadcast(Number160 messageKey) {
        return new BroadcastBuilder(this, messageKey);
    }

    public ShutdownBuilder announceShutdown() {
        return new ShutdownBuilder(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseFuture shutdown() {
        if (!this.shutdown) {
            ArrayList<Shutdown> copy;
            this.shutdown = true;
            List<Shutdown> list = this.shutdownListeners;
            synchronized (list) {
                copy = new ArrayList<Shutdown>(this.shutdownListeners);
            }
            FutureLateJoin<BaseFuture> futureLateJoin = new FutureLateJoin<BaseFuture>(this.shutdownListeners.size() + 1);
            for (Shutdown shutdown : copy) {
                futureLateJoin.add(shutdown.shutdown());
                this.removeShutdownListener(shutdown);
            }
            futureLateJoin.add(this.peerCreator.shutdown());
            return futureLateJoin;
        }
        return new FutureDone().setFailed("already shutting / shut down");
    }

    public boolean isShutdown() {
        return this.shutdown;
    }

    public void addShutdownListener(Shutdown shutdown) {
        this.shutdownListeners.add(shutdown);
    }

    public void removeShutdownListener(Shutdown shutdown) {
        this.shutdownListeners.remove(shutdown);
    }
}

